/*
 * Decompiled with CFR 0.152.
 */
package medusa.example;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import medusa.MedusaSettings;
import medusa.applet.MedusaAppletPanel;
import medusa.applet.MedusaLite;
import medusa.graph.Edge;
import medusa.graph.Node;

public class GeoAppletPanel
extends MedusaAppletPanel {
    public GeoAppletPanel(MedusaSettings stringSettings, MedusaLite parent, String linkStart, String linkEnd) {
        super(stringSettings, parent, linkStart, linkEnd);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Graphics2D g2d = this.prePaint(g);
        if (this.hideWhenMove) {
            if (!this.isRunning() & this.getPick() != null) {
                this.paintVisibleNet(g2d);
            } else {
                this.paintNet(g2d);
            }
        } else {
            this.paintNet(g2d);
        }
        g2d.setStroke(new BasicStroke(1.0f));
    }

    public void paintVisibleNet(Graphics2D g2d) {
        Iterator<Edge> edges = this.getVisibleGraph().edgesIterator();
        while (edges.hasNext()) {
            Edge e = edges.next();
            int col = e.getType();
            this.paintEdge(g2d, e);
        }
        g2d.setComposite(this.makeComposite(1.0f));
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            this.paintNode(g2d, node);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Node n;
        if (e.getClickCount() == 2 && (n = this.getClosest(e)) != null) {
            n.setColor(Color.pink);
            System.out.println("You double-clicked " + n.getLabel());
        }
    }

    @Override
    public void paintEdge(Graphics2D g, Edge e) {
        g.setPaint(Color.BLACK);
        Node from = this.graph.getNode(e.getFromName());
        Node to = this.graph.getNode(e.n2);
        int x1 = (int)from.getX();
        int y1 = (int)from.getY();
        int x2 = (int)to.getX();
        int y2 = (int)to.getY();
        g.drawLine(x1, y1, x2, y2);
        int centerPointX = (x1 + x2) / 2;
        int centerPointY = (y1 + y2) / 2;
        int offsetE = 8;
        g.setColor(Color.blue.brighter());
        Rectangle2D.Double box = new Rectangle2D.Double(centerPointX - offsetE, centerPointY - offsetE, 2 * offsetE, 2 * offsetE);
        g.fill(box);
        g.setColor(Color.white);
        g.drawString(Integer.toString(e.getType()), centerPointX - offsetE, centerPointY + offsetE);
    }
}

