/*
 * Decompiled with CFR 0.152.
 */
package QuasiBayesianNetworks;

import BayesianNetworks.BayesNet;
import CredalSets.QBProbabilityFunction;
import InterchangeFormat.IFException;
import InterchangeFormat.InterchangeFormat;
import QuasiBayesianNetworks.QBConvertInterchangeFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class QuasiBayesNet
extends BayesNet {
    int global_neighborhood_type;
    double global_neighborhood_parameter;
    static final String[] global_neighborhood_keywords = new String[]{"none", "credal-set", "constant-density-ratio", "epsilon-contaminated", "constant-density-bounded", "total-variation"};
    public static final int NO_CREDAL_SET = 0;
    static final int CREDAL_SET = 1;
    public static final int CONSTANT_DENSITY_RATIO = 2;
    public static final int EPSILON_CONTAMINATED = 3;
    public static final int CONSTANT_DENSITY_BOUNDED = 4;
    public static final int TOTAL_VARIATION = 5;

    public QuasiBayesNet() {
        this.global_neighborhood_type = 0;
        this.global_neighborhood_parameter = 0.0;
    }

    public QuasiBayesNet(String n_n, int n_v, int n_f) {
        super(n_n, n_v, n_f);
        this.global_neighborhood_type = 0;
        this.global_neighborhood_parameter = 0.0;
    }

    public QuasiBayesNet(String n_n, Vector p) {
        super(n_n, p);
        this.global_neighborhood_type = 0;
        this.global_neighborhood_parameter = 0.0;
    }

    public QuasiBayesNet(BayesNet bn) {
        super(bn);
        if (bn instanceof QuasiBayesNet) {
            this.global_neighborhood_type = ((QuasiBayesNet)bn).global_neighborhood_type;
            this.global_neighborhood_parameter = ((QuasiBayesNet)bn).global_neighborhood_parameter;
        }
    }

    public QuasiBayesNet(String s) throws IFException {
        super(s);
    }

    public QuasiBayesNet(InputStream istream) throws IFException {
        super(istream);
    }

    public QuasiBayesNet(URL context, String spec) throws IFException, IOException {
        super(context, spec);
    }

    public QuasiBayesNet(URL url) throws IFException, IOException {
        super(url);
    }

    @Override
    protected void translate(InterchangeFormat ifo) {
        int i;
        QBConvertInterchangeFormat qbcbn = new QBConvertInterchangeFormat(ifo);
        this.name = qbcbn.get_name();
        this.properties = qbcbn.get_properties();
        this.probability_variables = qbcbn.get_probability_variables(this);
        this.probability_functions = qbcbn.get_probability_functions(this);
        this.process_properties();
        for (i = 0; i < this.probability_variables.length; ++i) {
            this.process_probability_variable_properties(i);
        }
        for (i = 0; i < this.probability_functions.length; ++i) {
            this.process_probability_function_properties(i);
        }
    }

    @Override
    protected void process_properties() {
        String property;
        String delimiters = " \n\t\r\f";
        Vector<String> properties_to_remove = new Vector<String>();
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            String keyword;
            property = (String)e.nextElement();
            StringTokenizer st = new StringTokenizer(property, delimiters);
            String token = st.nextToken();
            if (!token.equals(keyword = global_neighborhood_keywords[1])) continue;
            properties_to_remove.addElement(property);
            token = st.nextToken();
            boolean is_property_value_available = false;
            for (int i = 2; i < 6; ++i) {
                keyword = global_neighborhood_keywords[i];
                if (!token.equals(keyword)) continue;
                this.global_neighborhood_type = i;
                is_property_value_available = true;
                break;
            }
            if (!is_property_value_available) continue;
            String property_value = st.nextToken();
            this.global_neighborhood_parameter = Double.valueOf(property_value);
        }
        e = properties_to_remove.elements();
        while (e.hasMoreElements()) {
            property = (String)e.nextElement();
            this.properties.removeElement(property);
        }
    }

    public boolean are_local_credal_sets_present() {
        for (int i = 0; i < this.probability_functions.length; ++i) {
            if (!(this.probability_functions[i] instanceof QBProbabilityFunction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void print(PrintStream out) {
        int i;
        out.println("// Bayesian network ");
        if (this.name != null) {
            out.print("network \"" + this.name + "\" {");
        }
        if (this.probability_variables != null) {
            out.print(" //" + this.probability_variables.length + " variables");
        }
        if (this.probability_functions != null) {
            out.print(" and " + this.probability_functions.length + " probability distributions");
        }
        out.println();
        if (this.global_neighborhood_type != 0) {
            out.println("\tproperty \"" + global_neighborhood_keywords[1] + " " + global_neighborhood_keywords[this.global_neighborhood_type] + " " + this.global_neighborhood_parameter + "\" ;");
        }
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                out.println("\tproperty \"" + property + "\" ;");
            }
        }
        out.println("}");
        if (this.probability_variables != null) {
            for (i = 0; i < this.probability_variables.length; ++i) {
                if (this.probability_variables[i] == null) continue;
                this.probability_variables[i].print(out);
            }
        }
        if (this.probability_functions != null) {
            for (i = 0; i < this.probability_functions.length; ++i) {
                if (this.probability_functions[i] == null) continue;
                this.probability_functions[i].print(out);
            }
        }
    }

    public int get_global_neighborhood_type() {
        return this.global_neighborhood_type;
    }

    public void set_global_neighborhood_type(int type) {
        this.global_neighborhood_type = type;
    }

    public double get_global_neighborhood_parameter() {
        return this.global_neighborhood_parameter;
    }

    public void set_global_neighborhood_parameter(double p) {
        this.global_neighborhood_parameter = p;
    }
}

