/*
 * Decompiled with CFR 0.152.
 */
package JavaBayesInterface;

import InferenceGraphs.InferenceGraph;
import JavaBayesInterface.PropertyManager;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.util.Vector;

class EditNetworkDialog
extends Dialog {
    InferenceGraph ig;
    PropertyManager property_manager;
    int displayed_network_property_index;
    Panel np;
    Panel npp;
    Panel gnp;
    Panel gncp;
    Panel gnpp;
    Panel tp;
    Panel okp;
    Label name;
    Label network_properties;
    TextField text_name;
    TextField text_global_parameter;
    Label global;
    Label global_parameter;
    CheckboxGroup globals;
    Checkbox no_global;
    Checkbox epsilon_global;
    Checkbox ratio_global;
    Checkbox total_global;
    Checkbox bounded_global;
    Button new_network_property;
    Button next_network_property;
    TextField network_properties_text;
    Button ok_button;
    Button dismiss_button;
    private static final int TOP_INSET = 5;
    private static final int LEFT_INSET = 10;
    private static final int RIGHT_INSET = 10;
    private static final int BOTTOM_INSET = 0;
    private static final String dialog_title = "Edit Network";
    private static final String name_label = "Name:";
    private static final String network_properties_label = "Network properties:";
    private static final String next_property_label = "Next";
    private static final String new_property_label = "New";
    private static final String global_label = "Network neighborhood model:";
    private static final String no_global_label = "No global neighborhood";
    private static final String epsilon_global_label = "Epsilon contaminated neighborhood";
    private static final String ratio_global_label = "Constant density ratio neighborhood";
    private static final String total_global_label = "Total variation neighborhood";
    private static final String bounded_global_label = "Constant density bounded neighborhood";
    private static final String global_parameter_label = "Global neighborhood parameter:";
    private static final String ok_label = "Apply";
    private static final String dismiss_label = "Dismiss";

    public EditNetworkDialog(Frame parent, InferenceGraph i_g) {
        super(parent, dialog_title, true);
        this.ig = i_g;
        this.np = new Panel();
        this.np.setLayout(new BorderLayout());
        this.name = new Label(name_label);
        this.text_name = new TextField(30);
        this.np.add("West", this.name);
        this.np.add("Center", this.text_name);
        this.npp = new Panel();
        this.npp.setLayout(new BorderLayout());
        this.network_properties = new Label(network_properties_label);
        this.next_network_property = new Button(next_property_label);
        this.new_network_property = new Button(new_property_label);
        this.network_properties_text = new TextField(40);
        this.npp.add("North", this.network_properties);
        this.npp.add("West", this.next_network_property);
        this.npp.add("Center", this.network_properties_text);
        this.npp.add("East", this.new_network_property);
        this.gnp = new Panel();
        this.gnp.setLayout(new BorderLayout());
        this.global = new Label(global_label);
        this.gncp = new Panel();
        this.gncp.setLayout(new GridLayout(5, 1));
        this.globals = new CheckboxGroup();
        this.no_global = new Checkbox(no_global_label, this.globals, true);
        this.epsilon_global = new Checkbox(epsilon_global_label, this.globals, false);
        this.ratio_global = new Checkbox(ratio_global_label, this.globals, false);
        this.total_global = new Checkbox(total_global_label, this.globals, false);
        this.bounded_global = new Checkbox(bounded_global_label, this.globals, false);
        this.gncp.add(this.no_global);
        this.gncp.add(this.epsilon_global);
        this.gncp.add(this.ratio_global);
        this.gncp.add(this.total_global);
        this.gncp.add(this.bounded_global);
        this.gnpp = new Panel();
        this.gnpp.setLayout(new BorderLayout());
        this.global_parameter = new Label(global_parameter_label);
        this.text_global_parameter = new TextField(10);
        this.gnpp.add("West", this.global_parameter);
        this.gnpp.add("Center", this.text_global_parameter);
        this.gnp.add("North", this.global);
        this.gnp.add("Center", this.gncp);
        this.gnp.add("South", this.gnpp);
        this.tp = new Panel();
        this.tp.setLayout(new BorderLayout());
        this.tp.add("North", this.np);
        this.tp.add("Center", this.npp);
        this.tp.add("South", this.gnp);
        this.okp = new Panel();
        this.okp.setLayout(new FlowLayout(1));
        this.ok_button = new Button(ok_label);
        this.dismiss_button = new Button(dismiss_label);
        this.okp.add(this.ok_button);
        this.okp.add(this.dismiss_button);
        this.setLayout(new BorderLayout());
        this.add("North", this.tp);
        this.add("Center", this.okp);
        this.pack();
        this.fill_dialog();
    }

    @Override
    public void show() {
        Rectangle bounds = this.getParent().bounds();
        Rectangle abounds = this.bounds();
        this.move(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        super.show();
    }

    @Override
    public Insets insets() {
        Insets ins = super.insets();
        return new Insets(ins.top + 5, ins.left + 10, ins.bottom + 0, ins.right + 10);
    }

    @Override
    public boolean handleEvent(Event evt) {
        if (evt.id == 201) {
            this.dispose();
        }
        return super.handleEvent(evt);
    }

    private void fill_dialog() {
        String all_values = "";
        this.ig.get_bayes_net();
        this.text_name.setText(this.ig.get_name());
        this.property_manager = new PropertyManager(this.ig.get_network_properties(), this.network_properties_text);
        switch (this.ig.get_global_neighborhood_type()) {
            case 0: {
                this.globals.setCurrent(this.no_global);
                break;
            }
            case 2: {
                this.globals.setCurrent(this.ratio_global);
                break;
            }
            case 3: {
                this.globals.setCurrent(this.epsilon_global);
                break;
            }
            case 4: {
                this.globals.setCurrent(this.bounded_global);
                break;
            }
            case 5: {
                this.globals.setCurrent(this.total_global);
            }
        }
        double par = this.ig.get_global_neighborhood_parameter();
        this.text_global_parameter.setText(String.valueOf(par));
    }

    @Override
    public boolean action(Event evt, Object arg) {
        if (evt.target == this.dismiss_button) {
            this.dispose();
        } else if (evt.target == this.ok_button) {
            this.update_dialog();
        } else if (evt.target == this.new_network_property) {
            this.property_manager.new_property();
        } else if (evt.target == this.next_network_property) {
            this.property_manager.next_property();
        } else if (evt.target == this.network_properties_text) {
            this.property_manager.update_property();
        } else {
            return super.action(evt, arg);
        }
        return true;
    }

    private void update_dialog() {
        Checkbox selected_global_neighborhood;
        Vector prop;
        String new_network_name = this.text_name.getText();
        if (!new_network_name.equals(this.ig.get_name()) && (new_network_name = this.ig.check_name(new_network_name)) != null) {
            this.ig.set_name(new_network_name);
        }
        if ((prop = this.property_manager.update_property_on_exit()) != null) {
            this.ig.set_network_properties(prop);
        }
        if ((selected_global_neighborhood = this.globals.getCurrent()) == this.no_global) {
            this.ig.set_global_neighborhood(0);
        } else if (selected_global_neighborhood == this.epsilon_global) {
            this.ig.set_global_neighborhood(3);
        } else if (selected_global_neighborhood == this.ratio_global) {
            this.ig.set_global_neighborhood(2);
        } else if (selected_global_neighborhood == this.bounded_global) {
            this.ig.set_global_neighborhood(4);
        } else if (selected_global_neighborhood == this.total_global) {
            this.ig.set_global_neighborhood(5);
        }
        try {
            double par = new Double(this.text_global_parameter.getText());
            if (par <= 0.0) {
                par = 0.0;
            }
            this.ig.set_global_neighborhood_parameter(par);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

