/*
 * Decompiled with CFR 0.152.
 */
package JavaBayesInterface;

import InferenceGraphs.InferenceGraph;
import InferenceGraphs.InferenceGraphNode;
import JavaBayesInterface.EditFunctionPanel;
import JavaBayesInterface.FunctionTablePanel;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.Vector;

class EditCredalSet
extends EditFunctionPanel {
    private InferenceGraph ig;
    private InferenceGraphNode node;
    private String[] all_variable_names;
    private String[][] all_variable_values;
    private double[][] all_probability_values;
    private int index_extreme_point;
    private FunctionTablePanel probability_table;
    private Panel csp;
    private Panel ics;
    private Panel qbpp;
    private Choice credal_set_choice;
    private Label local_parameter;
    private TextField text_local_parameter;
    private static final String credal_set_specification = "Credal set specification";
    private static final String credal_set = "Index of extreme distribution:";
    private static final String number_extreme_points_label = "Number of extreme points:";

    public EditCredalSet(InferenceGraph i_g, InferenceGraphNode i_g_n) {
        this.ig = i_g;
        this.node = i_g_n;
        this.copy_probability_values();
        this.all_variable_names = this.node.get_all_names();
        this.all_variable_values = this.node.get_all_values();
        Label probability_name = this.create_credal_set_name();
        this.index_extreme_point = 0;
        this.probability_table = new FunctionTablePanel(this.all_variable_names, this.all_variable_values, this.all_probability_values[this.index_extreme_point]);
        this.generate_credal_set_panel();
        this.setLayout(new BorderLayout());
        this.add("North", probability_name);
        this.add("Center", this.probability_table);
        this.add("South", this.csp);
    }

    private void copy_probability_values() {
        this.all_probability_values = new double[this.node.number_extreme_distributions()][];
        for (int i = 0; i < this.all_probability_values.length; ++i) {
            double[] original_probability_values = this.node.get_function_values(i);
            this.all_probability_values[i] = new double[original_probability_values.length];
            for (int j = 0; j < this.all_probability_values[i].length; ++j) {
                this.all_probability_values[i][j] = original_probability_values[j];
            }
        }
    }

    private Label create_credal_set_name() {
        StringBuffer name = new StringBuffer("K(");
        name.append(this.node.get_name());
        if (this.node.hasParent()) {
            name.append(" |");
            Vector parents = this.node.get_parents();
            Enumeration e = parents.elements();
            while (e.hasMoreElements()) {
                name.append(" " + ((InferenceGraphNode)e.nextElement()).get_name() + ",");
            }
            name.setCharAt(name.length() - 1, ')');
        } else {
            name.append(")");
        }
        return new Label(name.toString(), 1);
    }

    @Override
    void accept() {
        this.all_probability_values[this.index_extreme_point] = this.probability_table.get_table();
        for (int i = 0; i < this.all_probability_values.length; ++i) {
            this.node.set_function_values(i, this.all_probability_values[i]);
        }
        try {
            int old_number_extreme_points = this.all_probability_values.length;
            int number_extreme_points = new Integer(this.text_local_parameter.getText());
            if (number_extreme_points != this.all_probability_values.length) {
                int k;
                this.node.set_local_credal_set(number_extreme_points);
                this.copy_probability_values();
                if (this.index_extreme_point >= number_extreme_points) {
                    this.index_extreme_point = number_extreme_points - 1;
                }
                this.probability_table.insert_table(this.all_probability_values[this.index_extreme_point]);
                if (number_extreme_points > old_number_extreme_points) {
                    for (k = old_number_extreme_points; k < number_extreme_points; ++k) {
                        this.credal_set_choice.addItem(String.valueOf(k));
                    }
                }
                if (old_number_extreme_points > number_extreme_points) {
                    for (k = old_number_extreme_points - 1; k >= number_extreme_points; --k) {
                        this.credal_set_choice.remove(k);
                    }
                }
                this.credal_set_choice.select(this.index_extreme_point);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    void dismiss() {
    }

    private void generate_credal_set_panel() {
        this.csp = new Panel();
        this.csp.setLayout(new BorderLayout());
        Label credal_set_specification_label = new Label(credal_set_specification, 1);
        this.ics = new Panel();
        this.ics.setLayout(new BorderLayout());
        Label credal_set_label = new Label(credal_set);
        this.credal_set_choice = new Choice();
        for (int i = 0; i < this.node.number_extreme_distributions(); ++i) {
            this.credal_set_choice.addItem(String.valueOf(i));
        }
        this.ics.add("West", credal_set_label);
        this.ics.add("Center", this.credal_set_choice);
        this.qbpp = new Panel();
        this.qbpp.setLayout(new BorderLayout());
        this.local_parameter = new Label(number_extreme_points_label);
        this.text_local_parameter = new TextField(5);
        int number_extreme_points = this.node.number_extreme_distributions();
        this.text_local_parameter.setText(String.valueOf(number_extreme_points));
        this.qbpp.add("West", this.local_parameter);
        this.qbpp.add("Center", this.text_local_parameter);
        this.csp.add("North", credal_set_specification_label);
        this.csp.add("Center", this.qbpp);
        this.csp.add("South", this.ics);
    }

    @Override
    public boolean action(Event evt, Object arg) {
        if (evt.target == this.credal_set_choice) {
            this.all_probability_values[this.index_extreme_point] = this.probability_table.get_table();
            this.index_extreme_point = this.credal_set_choice.getSelectedIndex();
            this.probability_table.insert_table(this.all_probability_values[this.index_extreme_point]);
            return true;
        }
        return super.action(evt, arg);
    }
}

