/*
 * Decompiled with CFR 0.152.
 */
package InterchangeFormat;

import InterchangeFormat.IFBayesNet;
import InterchangeFormat.IFProbabilityVariable;
import java.util.Enumeration;
import java.util.Vector;

public class IFProbabilityFunction {
    String[] s_variables;
    int conditional_index;
    Vector properties;
    Vector defaults;
    Vector tables;
    Vector entries;

    public void set_variables(String[] vs) {
        this.s_variables = vs;
    }

    public void set_properties(Vector p) {
        this.properties = p;
    }

    public void set_defaults(Vector d) {
        this.defaults = d;
    }

    public void set_tables(Vector t) {
        this.tables = t;
    }

    public void set_entries(Vector e) {
        this.entries = e;
    }

    public void set_conditional_index(int c) {
        this.conditional_index = c;
    }

    public String[] get_variables() {
        return this.s_variables;
    }

    public Vector get_properties() {
        return this.properties;
    }

    public Vector get_defaults() {
        return this.defaults;
    }

    public Vector get_tables() {
        return this.tables;
    }

    public Vector get_entries() {
        return this.entries;
    }

    public int get_conditional_index() {
        return this.conditional_index;
    }

    public void invert_tables(IFBayesNet ifbn) {
        int size_of_first = 0;
        int size_of_others = 1;
        if (this.s_variables.length > 1) {
            Vector<double[]> new_tables = new Vector<double[]>();
            Enumeration e = this.tables.elements();
            while (e.hasMoreElements()) {
                int j;
                String running_name;
                IFProbabilityVariable pv;
                size_of_first = 0;
                size_of_others = 1;
                double[] t = (double[])e.nextElement();
                Enumeration ee = ifbn.pvs.elements();
                while (ee.hasMoreElements()) {
                    pv = (IFProbabilityVariable)ee.nextElement();
                    running_name = pv.get_name();
                    if (!running_name.equals(this.s_variables[0])) continue;
                    size_of_first = pv.get_values().length;
                    break;
                }
                block2: for (j = 1; j < this.s_variables.length; ++j) {
                    ee = ifbn.pvs.elements();
                    while (ee.hasMoreElements()) {
                        pv = (IFProbabilityVariable)ee.nextElement();
                        running_name = pv.get_name();
                        if (!running_name.equals(this.s_variables[j])) continue;
                        size_of_others *= pv.get_values().length;
                        continue block2;
                    }
                }
                double[] new_table = new double[t.length];
                for (int i = 0; i < size_of_first; ++i) {
                    for (j = 0; j < size_of_others; ++j) {
                        new_table[i * size_of_others + j] = t[j * size_of_first + i];
                    }
                }
                new_tables.addElement(new_table);
            }
            this.tables = new_tables;
        }
    }
}

