/*
 * Decompiled with CFR 0.152.
 */
package CredalSets;

import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import CredalSets.Bracketing;
import CredalSets.FinitelyGeneratedSet;
import CredalSets.MappingDouble;
import CredalSets.QBProbabilityFunction;

public class ConstantDensityRatioSet
extends FinitelyGeneratedSet
implements MappingDouble {
    private double k;
    private DiscreteFunction temporary_discrete_function;
    private static final int LOWER_EXPECTATION_BRACKET = 0;
    private static final int UPPER_EXPECTATION_BRACKET = 1;
    private static final double ACCURACY = 1.0E-7;

    public ConstantDensityRatioSet(ProbabilityFunction pf, double kk) {
        super((DiscreteFunction)pf, pf.get_values());
        this.k = kk;
        if (this.k <= 0.0) {
            this.k = 1.0;
        } else if (this.k < 1.0) {
            this.k = 1.0 / this.k;
        }
    }

    public ProbabilityFunction posterior_marginal() {
        double[] lower_values = new double[this.values.length];
        double[] upper_values = new double[this.values.length];
        if (this.variables[0] instanceof ProbabilityVariable && ((ProbabilityVariable)this.variables[0]).is_observed()) {
            for (int i = 0; i < this.values.length; ++i) {
                lower_values[i] = this.values[i];
                upper_values[i] = this.values[i];
            }
        } else {
            int i;
            double total = 0.0;
            for (i = 0; i < this.values.length; ++i) {
                total += this.values[i];
            }
            for (i = 0; i < this.values.length; ++i) {
                lower_values[i] = this.values[i] / this.k / (this.values[i] / this.k + this.k * (total - this.values[i]));
            }
            for (i = 0; i < this.values.length; ++i) {
                upper_values[i] = this.k * this.values[i] / (this.k * this.values[i] + (total - this.values[i]) / this.k);
            }
        }
        return new QBProbabilityFunction(this.bn, this.variables, this.values, lower_values, upper_values, this.properties);
    }

    public double[] expected_values(DiscreteFunction df) {
        Bracketing bracket = new Bracketing();
        double[] results = new double[2];
        if (this.variables[0] instanceof ProbabilityVariable && ((ProbabilityVariable)this.variables[0]).is_observed()) {
            results[0] = df.get_value(((ProbabilityVariable)this.variables[0]).get_observed_index());
            results[1] = results[0];
            return results;
        }
        double max_df_value = df.get_value(0);
        double min_df_value = df.get_value(0);
        for (int i = 1; i < df.number_values(); ++i) {
            if (max_df_value < df.get_value(i)) {
                max_df_value = df.get_value(i);
            }
            if (!(min_df_value > df.get_value(i))) continue;
            min_df_value = df.get_value(i);
        }
        this.temporary_discrete_function = df;
        double lower_expectation = bracket.perform(this, 0, min_df_value, max_df_value, 1.0E-7);
        double upper_expectation = bracket.perform(this, 1, min_df_value, max_df_value, 1.0E-7);
        results[0] = lower_expectation;
        results[1] = upper_expectation;
        return results;
    }

    public double[] posterior_expected_values(DiscreteFunction df) {
        return this.expected_values(df);
    }

    @Override
    public double map(int map_type, double map_input) {
        double map_output_upper = 0.0;
        double map_output_lower = 0.0;
        double map_output = 0.0;
        DiscreteFunction tdf = this.temporary_discrete_function;
        switch (map_type) {
            case 0: {
                for (int i = 0; i < this.values.length; ++i) {
                    double aux = tdf.get_value(i) - map_input;
                    map_output_upper += this.k * this.values[i] * -Math.max(-aux, 0.0);
                    map_output_lower += this.values[i] / this.k * Math.max(aux, 0.0);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.values.length; ++i) {
                    double aux = tdf.get_value(i) - map_input;
                    map_output_upper += this.k * this.values[i] * Math.max(aux, 0.0);
                    map_output_lower += this.values[i] / this.k * -Math.max(-aux, 0.0);
                }
                break;
            }
        }
        map_output = map_output_upper + map_output_lower;
        return map_output;
    }
}

