/*
 * Decompiled with CFR 0.152.
 */
package CredalSets;

import CredalSets.MappingDouble;

class Bracketing {
    int status;
    private static final int MAXIMUM_ITERATIONS = 40;
    private static final int ERROR = -1;
    private static final int TOO_MANY_BISECTIONS = 0;
    private static final int EXACT_ROOT_FOUND = 1;
    private static final int APPROXIMATE_ROOT_FOUND = 2;

    Bracketing() {
    }

    double perform(MappingDouble function, double x1, double x2, double x_accuracy) {
        return this.perform(function, 0, x1, x2, x_accuracy);
    }

    double perform(MappingDouble function, int function_type, double x1, double x2, double x_accuracy) {
        double current_solution_point;
        double dx;
        double f1 = function.map(function_type, x1);
        double f2 = function.map(function_type, x2);
        if (f1 == 0.0) {
            this.status = 1;
            return x1;
        }
        if (f2 == 0.0) {
            this.status = 1;
            return x2;
        }
        if (f1 * f2 > 0.0) {
            this.status = -1;
            return 0.0;
        }
        if (f1 < 0.0) {
            dx = x2 - x1;
            current_solution_point = x1;
        } else {
            dx = x1 - x2;
            current_solution_point = x2;
        }
        for (int j = 1; j <= 40; ++j) {
            double x_middle = current_solution_point + (dx *= 0.5);
            f2 = function.map(function_type, x_middle);
            if (f2 <= 0.0) {
                current_solution_point = x_middle;
            }
            if (f2 == 0.0) {
                this.status = 1;
                return current_solution_point;
            }
            if (!(Math.abs(dx) < x_accuracy)) continue;
            this.status = 2;
            return current_solution_point;
        }
        this.status = 0;
        return 0.0;
    }
}

