/*
 * Decompiled with CFR 0.152.
 */
package BayesianInferences;

import BayesianInferences.Inference;
import BayesianNetworks.BayesNet;
import BayesianNetworks.DiscreteFunction;
import BayesianNetworks.ProbabilityFunction;
import BayesianNetworks.ProbabilityVariable;
import java.io.PrintStream;

public class Expectation {
    protected BayesNet bn;
    protected Inference inference;
    protected double[] results;
    protected boolean do_produce_clusters;
    protected DiscreteFunction current_function;
    static final int EXPECTED_VALUE = 1;
    static final int SECOND_MOMENT = 2;
    static final int THIRD_MOMENT = 3;
    static final int FOURTH_MOMENT = 4;

    public Expectation(BayesNet b_n, boolean dpc) {
        this.bn = b_n;
        this.do_produce_clusters = dpc;
        this.initialize_inference();
    }

    protected void initialize_inference() {
        this.inference = new Inference(this.bn, this.do_produce_clusters);
    }

    public void expectation() {
        ProbabilityVariable pv = this.bn.get_probability_variable(0);
        DiscreteFunction df = this.construct_values(pv, 1);
        this.expectation(df);
    }

    public void expectation(String queried_variable_name) {
        int index = this.bn.index_of_variable(queried_variable_name);
        if (index == -1) {
            this.expectation();
            return;
        }
        ProbabilityVariable pv = this.bn.get_probability_variable(index);
        DiscreteFunction df = this.construct_values(pv, 1);
        this.expectation(df, queried_variable_name);
    }

    public void expectation(String[] order) {
        int index = this.bn.index_of_variable(order[order.length - 1]);
        if (index == -1) {
            this.expectation();
            return;
        }
        ProbabilityVariable pv = this.bn.get_probability_variable(index);
        DiscreteFunction df = this.construct_values(pv, 1);
        this.expectation(df, order);
    }

    public void expectation(int moment_order) {
        ProbabilityVariable pv = this.bn.get_probability_variable(0);
        DiscreteFunction df = this.construct_values(pv, moment_order);
        this.expectation(df);
    }

    public void expectation(int moment_order, String queried_variable_name) {
        int index = this.bn.index_of_variable(queried_variable_name);
        if (index == -1) {
            this.expectation();
            return;
        }
        ProbabilityVariable pv = this.bn.get_probability_variable(index);
        DiscreteFunction df = this.construct_values(pv, moment_order);
        this.expectation(df, queried_variable_name);
    }

    public void expectation(int moment_order, String[] order) {
        int index = this.bn.index_of_variable(order[order.length - 1]);
        if (index == -1) {
            this.expectation();
            return;
        }
        ProbabilityVariable pv = this.bn.get_probability_variable(index);
        DiscreteFunction df = this.construct_values(pv, moment_order);
        this.expectation(df, order);
    }

    public void expectation(DiscreteFunction df) {
        this.inference.inference();
        this.do_expectation_from_inference(df);
    }

    public void expectation(DiscreteFunction df, String queried_variable_name) {
        this.inference.inference(queried_variable_name);
        this.do_expectation_from_inference(df);
    }

    public void expectation(DiscreteFunction df, String[] order) {
        this.inference.inference(order);
        this.do_expectation_from_inference(df);
    }

    private DiscreteFunction construct_values(ProbabilityVariable pv, int moment_order) {
        DiscreteFunction df = pv.get_numeric_values();
        if (moment_order > 1) {
            for (int i = 0; i < df.number_values(); ++i) {
                df.set_value(i, Math.pow(df.get_value(i), moment_order));
            }
        }
        return df;
    }

    protected void do_expectation_from_inference(DiscreteFunction df) {
        this.current_function = df;
        ProbabilityFunction res = this.inference.get_result();
        this.results = new double[1];
        this.results[0] = res.expected_value(df);
    }

    public void print() {
        this.print(System.out, true);
    }

    public void print(PrintStream out) {
        this.print(out, true);
    }

    public void print(boolean should_print_bucket_tree) {
        this.print(System.out, should_print_bucket_tree);
    }

    public void print(PrintStream out, boolean should_print_bucket_tree) {
        out.print("Posterior expectation: [");
        for (int i = 0; i < this.results.length; ++i) {
            out.print(this.results[i] + " ");
        }
        out.println("], for function:");
        this.current_function.print(out);
        out.println();
        if (should_print_bucket_tree) {
            this.inference.bucket_tree.print(out);
        }
    }

    public double[] get_results() {
        return this.results;
    }
}

