/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.relativity;

import jsci.GlobalSettings;
import jsci.maths.DimensionException;
import jsci.maths.vectors.Double3Vector;
import jsci.physics.relativity.Rank2Tensor;
import jsci.physics.relativity.Rank3Tensor;
import jsci.physics.relativity.Rank4Tensor;
import jsci.physics.relativity.Tensor;

public class Rank1Tensor
extends Tensor {
    protected double[] rank1 = new double[4];

    public Rank1Tensor() {
    }

    public Rank1Tensor(double s, Double3Vector v) {
        this();
        this.rank1[0] = s;
        this.rank1[1] = v.getComponent(0);
        this.rank1[2] = v.getComponent(1);
        this.rank1[3] = v.getComponent(2);
    }

    public Rank1Tensor(double s, double v1, double v2, double v3) {
        this();
        this.rank1[0] = s;
        this.rank1[1] = v1;
        this.rank1[2] = v2;
        this.rank1[3] = v3;
    }

    public boolean equals(Object a) {
        if (a instanceof Rank1Tensor) {
            Rank1Tensor v = (Rank1Tensor)a;
            return Math.abs(this.rank1[0] - v.rank1[0]) <= GlobalSettings.ZERO_TOL && Math.abs(this.rank1[1] - v.rank1[1]) <= GlobalSettings.ZERO_TOL && Math.abs(this.rank1[2] - v.rank1[2]) <= GlobalSettings.ZERO_TOL && Math.abs(this.rank1[3] - v.rank1[3]) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        return new String(this.rank1[0] + "," + this.rank1[1] + "," + this.rank1[2] + "," + this.rank1[3]);
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public double getComponent(int i) {
        if (i >= 0 && i < 4) {
            return this.rank1[i];
        }
        throw new DimensionException("Invalid component.");
    }

    public void setComponent(int i, double x) {
        if (i < 0 || i >= 4) {
            throw new DimensionException("Invalid component.");
        }
        this.rank1[i] = x;
    }

    public double norm() {
        return Math.sqrt(this.rank1[0] * this.rank1[0] - this.rank1[1] * this.rank1[1] - this.rank1[2] * this.rank1[2] - this.rank1[3] * this.rank1[3]);
    }

    public Rank1Tensor add(Rank1Tensor t) {
        Rank1Tensor ans = new Rank1Tensor();
        ans.rank1[0] = this.rank1[0] + t.rank1[0];
        ans.rank1[1] = this.rank1[1] + t.rank1[1];
        ans.rank1[2] = this.rank1[2] + t.rank1[2];
        ans.rank1[3] = this.rank1[3] + t.rank1[3];
        return ans;
    }

    public Rank1Tensor subtract(Rank1Tensor t) {
        Rank1Tensor ans = new Rank1Tensor();
        ans.rank1[0] = this.rank1[0] - t.rank1[0];
        ans.rank1[1] = this.rank1[1] - t.rank1[1];
        ans.rank1[2] = this.rank1[2] - t.rank1[2];
        ans.rank1[3] = this.rank1[3] - t.rank1[3];
        return ans;
    }

    public Rank2Tensor tensorProduct(Rank1Tensor t) {
        Rank2Tensor ans = new Rank2Tensor();
        for (int i = 0; i < 4; ++i) {
            ans.setComponent(i, 0, this.rank1[i] * t.rank1[0]);
            ans.setComponent(i, 1, this.rank1[i] * t.rank1[1]);
            ans.setComponent(i, 2, this.rank1[i] * t.rank1[2]);
            ans.setComponent(i, 3, this.rank1[i] * t.rank1[3]);
        }
        return ans;
    }

    public Rank3Tensor tensorProduct(Rank2Tensor t) {
        Rank3Tensor ans = new Rank3Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ans.setComponent(i, j, 0, this.rank1[i] * t.getComponent(j, 0));
                ans.setComponent(i, j, 1, this.rank1[i] * t.getComponent(j, 1));
                ans.setComponent(i, j, 2, this.rank1[i] * t.getComponent(j, 2));
                ans.setComponent(i, j, 3, this.rank1[i] * t.getComponent(j, 3));
            }
        }
        return ans;
    }

    public Rank4Tensor tensorProduct(Rank3Tensor t) {
        Rank4Tensor ans = new Rank4Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    ans.setComponent(i, j, k, 0, this.rank1[i] * t.getComponent(j, k, 0));
                    ans.setComponent(i, j, k, 1, this.rank1[i] * t.getComponent(j, k, 1));
                    ans.setComponent(i, j, k, 2, this.rank1[i] * t.getComponent(j, k, 2));
                    ans.setComponent(i, j, k, 3, this.rank1[i] * t.getComponent(j, k, 3));
                }
            }
        }
        return ans;
    }
}

