/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.relativity;

import jsci.maths.vectors.Double3Vector;
import jsci.physics.relativity.Rank2Tensor;

public final class LorentzBoost
extends Rank2Tensor {
    public LorentzBoost(Double3Vector v) {
        this(v.getComponent(0), v.getComponent(1), v.getComponent(2));
    }

    public LorentzBoost(double vx, double vy, double vz) {
        double vv = vx * vx + vy * vy + vz * vz;
        double gamma = 1.0 / Math.sqrt(1.0 - vv);
        double k = (gamma - 1.0) / vv;
        this.rank2[0][0] = gamma;
        double d = -gamma * vx;
        this.rank2[1][0] = d;
        this.rank2[0][1] = d;
        double d2 = -gamma * vy;
        this.rank2[2][0] = d2;
        this.rank2[0][2] = d2;
        double d3 = -gamma * vz;
        this.rank2[3][0] = d3;
        this.rank2[0][3] = d3;
        this.rank2[1][1] = 1.0 + k * vx * vx;
        double d4 = k * vx * vy;
        this.rank2[2][1] = d4;
        this.rank2[1][2] = d4;
        double d5 = k * vx * vz;
        this.rank2[3][1] = d5;
        this.rank2[1][3] = d5;
        this.rank2[2][2] = 1.0 + k * vy * vy;
        double d6 = k * vy * vz;
        this.rank2[3][2] = d6;
        this.rank2[2][3] = d6;
        this.rank2[3][3] = 1.0 + k * vz * vz;
    }
}

