/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.AntiElectronNeutrino;
import jsci.physics.particles.Electron;
import jsci.physics.particles.Lepton;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class ElectronNeutrino
extends Lepton {
    @Override
    public double restMass() {
        return 0.0;
    }

    @Override
    public int charge() {
        return 0;
    }

    @Override
    public int eLeptonQN() {
        return 1;
    }

    @Override
    public int muLeptonQN() {
        return 0;
    }

    @Override
    public int tauLeptonQN() {
        return 0;
    }

    @Override
    public QuantumParticle anti() {
        return new AntiElectronNeutrino();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof AntiElectronNeutrino;
    }

    public String toString() {
        return new String("Electron neutrino");
    }

    public Electron emit(WPlus w) {
        Electron e = new Electron();
        e.momentum = this.momentum.subtract(w.momentum);
        return e;
    }

    public Electron absorb(WMinus w) {
        Electron e = new Electron();
        e.momentum = this.momentum.add(w.momentum);
        return e;
    }

    public ElectronNeutrino emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public ElectronNeutrino absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

