/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.AntiLepton;
import jsci.physics.particles.AntiTau;
import jsci.physics.particles.TauNeutrino;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class AntiTauNeutrino
extends AntiLepton {
    @Override
    public double restMass() {
        return 0.0;
    }

    @Override
    public int charge() {
        return 0;
    }

    @Override
    public int eLeptonQN() {
        return 0;
    }

    @Override
    public int muLeptonQN() {
        return 0;
    }

    @Override
    public int tauLeptonQN() {
        return -1;
    }

    @Override
    public QuantumParticle anti() {
        return new TauNeutrino();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof TauNeutrino;
    }

    public String toString() {
        return new String("Antitau neutrino");
    }

    public AntiTau emit(WMinus w) {
        AntiTau e = new AntiTau();
        e.momentum = this.momentum.subtract(w.momentum);
        return e;
    }

    public AntiTau absorb(WPlus w) {
        AntiTau e = new AntiTau();
        e.momentum = this.momentum.add(w.momentum);
        return e;
    }

    public AntiTauNeutrino emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public AntiTauNeutrino absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

