/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.symmlet8;

import jsci.maths.wavelet.FWT;

public final class FastSymmlet8
extends FWT {
    static final float[] scale = new float[]{0.0322231f, -0.012603967f, -0.099219546f, 0.2978578f, 0.8037388f, 0.49761868f, -0.029635528f, -0.075765714f};
    static final float[] wavelet = new float[]{-scale[7], scale[6], -scale[5], scale[4], -scale[3], scale[2], -scale[1], scale[0]};

    public static void transform(float[] v, int last) {
        float[] ans = new float[last];
        int half = last / 2;
        try {
            int k = 0;
            while (true) {
                ans[k + half] = v[2 * k + 0] * wavelet[0] + v[2 * k + 1] * wavelet[1] + v[2 * k + 2] * wavelet[2] + v[2 * k + 3] * wavelet[3] + v[2 * k + 4] * wavelet[4] + v[2 * k + 5] * wavelet[5] + v[2 * k + 6] * wavelet[6] + v[2 * k + 7] * wavelet[7];
                ans[k] = v[2 * k + 0] * scale[0] + v[2 * k + 1] * scale[1] + v[2 * k + 2] * scale[2] + v[2 * k + 3] * scale[3] + v[2 * k + 4] * scale[4] + v[2 * k + 5] * scale[5] + v[2 * k + 6] * scale[6] + v[2 * k + 7] * scale[7];
                ++k;
            }
        }
        catch (IndexOutOfBoundsException e) {
            ans[last - 3] = v[last - 6] * wavelet[0] + v[last - 5] * wavelet[1] + v[last - 4] * wavelet[2] + v[last - 3] * wavelet[3] + v[last - 2] * wavelet[4] + v[last - 1] * wavelet[5] + v[0] * wavelet[6] + v[1] * wavelet[7];
            ans[half - 3] = v[last - 6] * scale[0] + v[last - 5] * scale[1] + v[last - 4] * scale[2] + v[last - 3] * scale[3] + v[last - 2] * scale[4] + v[last - 1] * scale[5] + v[0] * scale[6] + v[1] * scale[7];
            ans[last - 2] = v[last - 4] * wavelet[0] + v[last - 3] * wavelet[1] + v[last - 2] * wavelet[2] + v[last - 1] * wavelet[3] + v[0] * wavelet[4] + v[1] * wavelet[5] + v[2] * wavelet[6] + v[3] * wavelet[7];
            ans[half - 2] = v[last - 4] * scale[0] + v[last - 3] * scale[1] + v[last - 2] * scale[2] + v[last - 1] * scale[3] + v[0] * scale[4] + v[1] * scale[5] + v[2] * scale[6] + v[3] * scale[7];
            ans[last - 1] = v[last - 2] * wavelet[0] + v[last - 1] * wavelet[1] + v[0] * wavelet[2] + v[1] * wavelet[3] + v[2] * wavelet[4] + v[3] * wavelet[5] + v[4] * wavelet[6] + v[5] * wavelet[7];
            ans[half - 1] = v[last - 2] * scale[0] + v[last - 1] * scale[1] + v[0] * scale[2] + v[1] * scale[3] + v[2] * scale[4] + v[3] * scale[5] + v[4] * scale[6] + v[5] * scale[7];
            System.arraycopy(ans, 0, v, 0, last);
            return;
        }
    }

    @Override
    public void transform(float[] v) {
        int last;
        for (last = v.length; last > 8; last /= 2) {
            FastSymmlet8.transform(v, last);
        }
        if (last != 8) {
            System.err.println("Careful! this should be a power of 2 : " + v.length);
        }
    }

    @Override
    public void invTransform(float[] v) {
        int last = 8;
        while (2 * last <= v.length) {
            FastSymmlet8.invTransform(v, last);
            last *= 2;
        }
        if (last != v.length) {
            System.err.println("Careful! this should be a power of 2 : " + v.length);
        }
    }

    public static void invTransform(float[] v, int last) {
        int ResultingLength = 2 * last;
        float[] ans = new float[ResultingLength];
        try {
            int k = 0;
            while (true) {
                int n = 2 * k + 7;
                ans[n] = ans[n] + (scale[7] * v[k] + wavelet[7] * v[k + last]);
                int n2 = 2 * k + 6;
                ans[n2] = ans[n2] + (scale[6] * v[k] + wavelet[6] * v[k + last]);
                int n3 = 2 * k + 5;
                ans[n3] = ans[n3] + (scale[5] * v[k] + wavelet[5] * v[k + last]);
                int n4 = 2 * k + 4;
                ans[n4] = ans[n4] + (scale[4] * v[k] + wavelet[4] * v[k + last]);
                int n5 = 2 * k + 3;
                ans[n5] = ans[n5] + (scale[3] * v[k] + wavelet[3] * v[k + last]);
                int n6 = 2 * k + 2;
                ans[n6] = ans[n6] + (scale[2] * v[k] + wavelet[2] * v[k + last]);
                int n7 = 2 * k + 1;
                ans[n7] = ans[n7] + (scale[1] * v[k] + wavelet[1] * v[k + last]);
                int n8 = 2 * k + 0;
                ans[n8] = ans[n8] + (scale[0] * v[k] + wavelet[0] * v[k + last]);
                ++k;
            }
        }
        catch (IndexOutOfBoundsException e) {
            int n = ResultingLength - 6;
            ans[n] = ans[n] + (scale[0] * v[last - 3] + wavelet[0] * v[ResultingLength - 3]);
            int n9 = ResultingLength - 5;
            ans[n9] = ans[n9] + (scale[1] * v[last - 3] + wavelet[1] * v[ResultingLength - 3]);
            int n10 = ResultingLength - 4;
            ans[n10] = ans[n10] + (scale[2] * v[last - 3] + wavelet[2] * v[ResultingLength - 3]);
            int n11 = ResultingLength - 3;
            ans[n11] = ans[n11] + (scale[3] * v[last - 3] + wavelet[3] * v[ResultingLength - 3]);
            int n12 = ResultingLength - 2;
            ans[n12] = ans[n12] + (scale[4] * v[last - 3] + wavelet[4] * v[ResultingLength - 3]);
            int n13 = ResultingLength - 1;
            ans[n13] = ans[n13] + (scale[5] * v[last - 3] + wavelet[5] * v[ResultingLength - 3]);
            ans[0] = ans[0] + (scale[6] * v[last - 3] + wavelet[6] * v[ResultingLength - 3]);
            ans[1] = ans[1] + (scale[7] * v[last - 3] + wavelet[7] * v[ResultingLength - 3]);
            int n14 = ResultingLength - 4;
            ans[n14] = ans[n14] + (scale[0] * v[last - 2] + wavelet[0] * v[ResultingLength - 2]);
            int n15 = ResultingLength - 3;
            ans[n15] = ans[n15] + (scale[1] * v[last - 2] + wavelet[1] * v[ResultingLength - 2]);
            int n16 = ResultingLength - 2;
            ans[n16] = ans[n16] + (scale[2] * v[last - 2] + wavelet[2] * v[ResultingLength - 2]);
            int n17 = ResultingLength - 1;
            ans[n17] = ans[n17] + (scale[3] * v[last - 2] + wavelet[3] * v[ResultingLength - 2]);
            ans[0] = ans[0] + (scale[4] * v[last - 2] + wavelet[4] * v[ResultingLength - 2]);
            ans[1] = ans[1] + (scale[5] * v[last - 2] + wavelet[5] * v[ResultingLength - 2]);
            ans[2] = ans[2] + (scale[6] * v[last - 2] + wavelet[6] * v[ResultingLength - 2]);
            ans[3] = ans[3] + (scale[7] * v[last - 2] + wavelet[7] * v[ResultingLength - 2]);
            int n18 = ResultingLength - 2;
            ans[n18] = ans[n18] + (scale[0] * v[last - 1] + wavelet[0] * v[ResultingLength - 1]);
            int n19 = ResultingLength - 1;
            ans[n19] = ans[n19] + (scale[1] * v[last - 1] + wavelet[1] * v[ResultingLength - 1]);
            ans[0] = ans[0] + (scale[2] * v[last - 1] + wavelet[2] * v[ResultingLength - 1]);
            ans[1] = ans[1] + (scale[3] * v[last - 1] + wavelet[3] * v[ResultingLength - 1]);
            ans[2] = ans[2] + (scale[4] * v[last - 1] + wavelet[4] * v[ResultingLength - 1]);
            ans[3] = ans[3] + (scale[5] * v[last - 1] + wavelet[5] * v[ResultingLength - 1]);
            ans[4] = ans[4] + (scale[6] * v[last - 1] + wavelet[6] * v[ResultingLength - 1]);
            ans[5] = ans[5] + (scale[7] * v[last - 1] + wavelet[7] * v[ResultingLength - 1]);
            System.arraycopy(ans, 0, v, 0, ans.length);
            return;
        }
    }
}

