/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.splines;

import jsci.maths.ArrayMath;
import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.splines.Spline;
import jsci.maths.wavelet.splines.SumOfDiracs;

public class PiecewiseConstant
extends Spline
implements Filter,
Cloneable {
    protected static final int filtretype = 0;
    private double[] vecteur;
    static final double[] vg = new double[]{1.0, 1.0};

    @Override
    public String toString() {
        return ArrayMath.toString(this.vecteur);
    }

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof PiecewiseConstant && this.vecteur.length == ((PiecewiseConstant)a).dimension()) {
            PiecewiseConstant iv = (PiecewiseConstant)a;
            for (int i = 0; i < this.vecteur.length; ++i) {
                if (this.vecteur[i] == iv.getValue(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int previousDimension(int k) {
        int i = (int)Math.round((double)k / 2.0);
        if (2 * i == k) {
            return i;
        }
        throw new IllegalArgumentException("Odd number of values into an even Filter.");
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] gete) {
        if (gete.length < 1) {
            throw new IllegalArgumentException("The array is not long enough : " + gete.length + " < 1");
        }
        double[] sortie = new double[2 * gete.length];
        for (int k = 0; k < gete.length; ++k) {
            int n = 2 * k;
            sortie[n] = sortie[n] + gete[k] * vg[0];
            int n2 = 2 * k + 1;
            sortie[n2] = sortie[n2] + gete[k] * vg[1];
        }
        return sortie;
    }

    @Override
    public double[] highpass(double[] gete) {
        if (gete.length < 2) {
            throw new IllegalArgumentException("The array is not long enough : " + gete.length + " < 2");
        }
        double[] data = Cascades.doublesample(gete);
        int dl = data.length - 1;
        double[] sortie = new double[2 * gete.length];
        double[] vg = new double[]{-1.0, 1.0};
        for (int k = 0; k <= dl - 1; ++k) {
            sortie[k] = ArrayMath.scalarProduct(ArrayMath.extract(k, k + 1, data), vg);
        }
        sortie[dl] = ArrayMath.scalarProduct(ArrayMath.extract(dl - vg.length + 2, dl, data), ArrayMath.extract(0, vg.length - 2, vg));
        return sortie;
    }

    public PiecewiseConstant(double[] v) {
        this.vecteur = v;
    }

    public PiecewiseConstant() {
    }

    @Override
    public Object clone() {
        PiecewiseConstant sod = (PiecewiseConstant)super.clone();
        if (this.vecteur != null) {
            sod.vecteur = ArrayMath.copy(this.vecteur);
        }
        return sod;
    }

    public double getValue(int i) {
        if (i < 0 || i > this.vecteur.length - 1) {
            throw new IllegalArgumentException("Incorrect parameters : " + i + ", " + this.vecteur.length);
        }
        return this.vecteur[i];
    }

    public void setValues(double[] v) {
        this.vecteur = v;
    }

    public double mass(double a, double b) {
        double mass = 0.0;
        for (int i = 0; i < this.vecteur.length; ++i) {
            mass += this.vecteur[i];
        }
        mass = mass * Math.abs(b - a) / (double)this.vecteur.length;
        return mass;
    }

    public void setValue(int i, double d) {
        if (i < 0) {
            throw new IllegalArgumentException("The parameter must be positive : " + i + " < 0");
        }
        this.vecteur[i] = d;
    }

    public SumOfDiracs derive() {
        return this.derive(0.0, 1.0);
    }

    public SumOfDiracs derive(double a, double b) {
        double[] v = new double[this.vecteur.length + 1];
        for (int i = 1; i < this.vecteur.length; ++i) {
            v[i] = (this.vecteur[i] - this.vecteur[i - 1]) * (double)this.vecteur.length / Math.abs(b - a);
        }
        v[0] = 0.0;
        v[this.vecteur.length] = 0.0;
        SumOfDiracs d = new SumOfDiracs(v);
        return d;
    }

    @Override
    public int dimension() {
        return this.vecteur.length + 1;
    }

    @Override
    public int dimension(int j) {
        return Cascades.dimensionHaar(this.vecteur.length, j);
    }

    @Override
    public double[] interpolate(int j) {
        if (j < 0) {
            throw new IllegalArgumentException("This parameter must be postive : " + j);
        }
        return Cascades.evaluation(this, j, this.vecteur);
    }

    @Override
    public double[] evaluate(int j) {
        return this.interpolate(j);
    }
}

