/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.daubechies8;

import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.daubechies8.Daubechies8;

public final class Wavelet8
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies8 cdf = new Daubechies8();

    @Override
    public String toString() {
        String ans = new String("[n0=");
        ans.concat(Integer.toString(this.n0));
        ans.concat("][k=");
        ans.concat(Integer.toString(this.k));
        ans.concat("]");
        return ans;
    }

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof Wavelet8) {
            Wavelet8 iv = (Wavelet8)a;
            return this.dimension(0) == iv.dimension(0) && this.position() == iv.position();
        }
        return false;
    }

    public Wavelet8(int N0, int K) {
        this.setParameters(N0, K);
    }

    public Wavelet8() {
    }

    @Override
    public int getFilterType() {
        return 14;
    }

    public void setParameters(int N0, int K) {
        if (N0 < 28) {
            throw new IllegalScalingException(N0, 28);
        }
        this.n0 = N0;
        this.k = K;
    }

    @Override
    public Object clone() {
        Wavelet8 w = (Wavelet8)super.clone();
        w.n0 = this.n0;
        w.k = this.k;
        return w;
    }

    @Override
    public double[] evaluate(int j) {
        return cdf.evalWavelet(this.n0, this.k, j);
    }

    @Override
    public int dimension(int jfin) {
        return Cascades.dimension(this.n0, jfin + 1, 14);
    }

    @Override
    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

