/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.daubechies2;

import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.daubechies2.Daubechies2;

public final class Scaling2
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies2 cdf = new Daubechies2();

    public Scaling2(int N0, int K) {
        this.setParameters(N0, K);
    }

    @Override
    public String toString() {
        String ans = new String("[n0=");
        ans.concat(Integer.toString(this.n0));
        ans.concat("][k=");
        ans.concat(Integer.toString(this.k));
        ans.concat("]");
        return ans;
    }

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof Scaling2) {
            Scaling2 iv = (Scaling2)a;
            return this.dimension(0) == iv.dimension(0) && this.position() == iv.position();
        }
        return false;
    }

    @Override
    public int getFilterType() {
        return 2;
    }

    public Scaling2() {
    }

    public void setParameters(int N0, int K) {
        if (N0 < 4) {
            throw new IllegalScalingException(N0, 4);
        }
        this.n0 = N0;
        this.k = K;
    }

    @Override
    public Object clone() {
        Scaling2 s = (Scaling2)super.clone();
        s.n0 = this.n0;
        s.k = this.k;
        return s;
    }

    @Override
    public double[] evaluate(int j) {
        return cdf.evalScaling(this.n0, this.k, j);
    }

    @Override
    public int dimension(int jfin) {
        return Cascades.dimension(this.n0, jfin, 2);
    }

    @Override
    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

