/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.cdf2_4;

import jsci.maths.wavelet.FWT;

public class FastCDF2_4
extends FWT {
    static int FilterType = 1;
    static final float[] scale = new float[]{0.03314563f, -0.06629126f, -0.17677669f, 0.41984466f, 0.9943689f, 0.41984466f, -0.17677669f, -0.06629126f, 0.03314563f};
    static final float[] wavelet = new float[]{-0.5f, 1.0f, -0.5f};
    static final float[][] scaleLeft = new float[][]{{1.0275146f, 0.77339804f, -0.22097087f, -0.3314563f, 0.16572815f}, {-0.22189158f, 0.44378316f, 0.90229774f, 0.58004856f, -0.25687864f, -0.06629126f, 0.03314563f}, {0.07549838f, -0.15099676f, -0.09575404f, 0.34250486f, 1.0330389f, 0.41984466f, -0.17677669f, -0.06629126f, 0.03314563f}, {-0.013810679f, 0.027621359f, 0.011048543f, -0.049718447f, -0.18506311f, 0.41984466f, 0.9943689f, 0.41984466f, -0.17677669f, -0.06629126f, 0.03314563f}};
    static final float[][] scaleRight = new float[][]{{0.03314563f, -0.06629126f, -0.17677669f, 0.41984466f, 0.9943689f, 0.41984466f, -0.18506311f, -0.049718447f, 0.011048543f, 0.027621359f, -0.013810679f}, {0.03314563f, -0.06629126f, -0.17677669f, 0.41984466f, 1.0330389f, 0.34250486f, -0.09575404f, -0.15099676f, 0.07549838f}, {0.03314563f, -0.06629126f, -0.25687864f, 0.58004856f, 0.90229774f, 0.44378316f, -0.22189158f}, {0.16572815f, -0.3314563f, -0.22097087f, 0.77339804f, 1.0275146f}};
    static final float[] scalePrimary = new float[]{0.35355338f, 0.70710677f, 0.35355338f};
    static final float[] waveletPrimary = new float[]{0.0234375f, 0.046875f, -0.125f, -0.296875f, 0.703125f, -0.296875f, -0.125f, 0.046875f, 0.0234375f};
    static final float[][] scalePrimaryLeft = new float[][]{{0.70710677f, 0.35355338f}};
    static final float[][] scalePrimaryRight = new float[][]{{0.35355338f, 0.70710677f}};
    static final float[][] waveletPrimaryLeft = new float[][]{{-0.546875f, 0.56966144f, -0.3138021f, -0.103515625f, 0.106770836f, 0.043619793f, -0.01953125f, -0.009765625f}, {0.234375f, -0.087890625f, -0.41015625f, 0.6738281f, -0.2421875f, -0.103515625f, 0.03515625f, 0.017578125f}};
    static final float[][] waveletPrimaryRight = new float[][]{{0.017578125f, 0.03515625f, -0.103515625f, -0.2421875f, 0.6738281f, -0.41015625f, -0.087890625f, 0.234375f}, {-0.009765625f, -0.01953125f, 0.043619793f, 0.106770836f, -0.103515625f, -0.3138021f, 0.56966144f, -0.546875f}};

    @Override
    public void transform(float[] v) {
        int last = v.length;
        while (last >= 15) {
            FastCDF2_4.transform(v, last);
            last = (last + FilterType) / 2;
        }
    }

    @Override
    public void invTransform(float[] v) {
        int last = v.length;
        while (last >= 15) {
            last = last / 2 + FilterType;
        }
        while (2 * last - FilterType <= v.length) {
            FastCDF2_4.invTransform(v, last);
            last = 2 * last - FilterType;
        }
    }

    public static void transform(float[] v, int last) {
        int l;
        int k;
        float[] ans = new float[last];
        int half = (last + FilterType) / 2;
        if (2 * half - FilterType != last) {
            throw new IllegalArgumentException("Illegal subband : " + last + " within array of length " + v.length);
        }
        for (k = 0; k < scaleLeft.length; ++k) {
            for (l = 0; l < scaleLeft[k].length; ++l) {
                int n = k;
                ans[n] = ans[n] + scaleLeft[k][l] * v[l];
            }
        }
        for (k = scaleLeft.length; k < half - scaleRight.length; ++k) {
            for (l = 0; l < scale.length; ++l) {
                int n = k;
                ans[n] = ans[n] + scale[l] * v[2 * k + l - scaleLeft.length];
            }
        }
        for (k = 0; k < scaleRight.length; ++k) {
            for (l = 0; l < scaleRight[k].length; ++l) {
                int n = k + half - scaleRight.length;
                ans[n] = ans[n] + scaleRight[k][l] * v[v.length - scaleRight[k].length + l];
            }
        }
        for (k = 0; k < half - FilterType; ++k) {
            for (l = 0; l < wavelet.length; ++l) {
                int n = k + half;
                ans[n] = ans[n] + wavelet[l] * v[2 * k + l];
            }
        }
        System.arraycopy(ans, 0, v, 0, last);
    }

    public static void invTransform(float[] v, int last) {
        int l;
        int k;
        float[] ans = new float[2 * last - FilterType];
        for (k = 0; k < scalePrimaryLeft.length; ++k) {
            for (l = 0; l < scalePrimaryLeft[k].length; ++l) {
                int n = l;
                ans[n] = ans[n] + scalePrimaryLeft[k][l] * v[k];
            }
        }
        for (k = scalePrimaryLeft.length; k < last - scalePrimaryRight.length; ++k) {
            for (l = 0; l < scalePrimary.length; ++l) {
                int n = 2 * k - FilterType + l;
                ans[n] = ans[n] + scalePrimary[l] * v[k];
            }
        }
        for (k = 0; k < scalePrimaryRight.length; ++k) {
            for (l = 0; l < scalePrimaryRight[k].length; ++l) {
                int n = l - scalePrimaryRight[k].length + ans.length;
                ans[n] = ans[n] + scalePrimaryRight[k][l] * v[k + last - scalePrimaryRight.length];
            }
        }
        for (k = 0; k < waveletPrimaryLeft.length; ++k) {
            for (l = 0; l < waveletPrimaryLeft[k].length; ++l) {
                int n = l;
                ans[n] = ans[n] + waveletPrimaryLeft[k][l] * v[k + last];
            }
        }
        for (k = waveletPrimaryLeft.length; k < last - FilterType - waveletPrimaryRight.length; ++k) {
            for (l = 0; l < waveletPrimary.length; ++l) {
                int n = 2 * (k - FilterType) - 1 + l;
                ans[n] = ans[n] + waveletPrimary[l] * v[k + last];
            }
        }
        for (k = 0; k < waveletPrimaryRight.length; ++k) {
            for (l = 0; l < waveletPrimaryRight[k].length; ++l) {
                int n = l - waveletPrimaryRight[k].length + ans.length;
                ans[n] = ans[n] + waveletPrimaryRight[k][l] * v[k + 2 * last - FilterType - waveletPrimaryRight.length];
            }
        }
        System.arraycopy(ans, 0, v, 0, ans.length);
    }
}

