/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.cdf2_4;

import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.cdf2_4.CDF2_4;

public final class DualWavelet2_4
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static CDF2_4 cdf = new CDF2_4();

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof DualWavelet2_4) {
            DualWavelet2_4 iv = (DualWavelet2_4)a;
            return this.dimension(0) == iv.dimension(0) && this.position() == iv.position();
        }
        return false;
    }

    @Override
    public String toString() {
        String ans = new String("[n0=");
        ans.concat(Integer.toString(this.n0));
        ans.concat("][k=");
        ans.concat(Integer.toString(this.k));
        ans.concat("]");
        return ans;
    }

    @Override
    public int getFilterType() {
        return 1;
    }

    public DualWavelet2_4(int N0, int K) {
        this.setParameters(N0, K);
    }

    public DualWavelet2_4() {
    }

    public void setParameters(int N0, int K) {
        if (N0 < 5) {
            throw new IllegalScalingException(N0, 5);
        }
        this.n0 = N0;
        this.k = K;
    }

    @Override
    public Object clone() {
        DualWavelet2_4 s = (DualWavelet2_4)super.clone();
        s.n0 = this.n0;
        s.k = this.k;
        return s;
    }

    @Override
    public double[] evaluate(int j) {
        return cdf.evalWavelet(this.n0, this.k, j);
    }

    @Override
    public int dimension(int jfin) {
        return Cascades.dimension(this.n0, jfin + 1);
    }

    @Override
    public int dimension() {
        return Cascades.dimension(this.n0, 1);
    }

    public int position() {
        return this.k;
    }
}

