/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet;

import jsci.maths.AbstractMath;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.IllegalScalingException;

public final class Cascades
extends AbstractMath {
    private Cascades() {
    }

    public static int previousDimension(int filtretype, int k) {
        int i = (int)Math.round((double)(k + filtretype) / 2.0);
        if (2 * i - filtretype == k) {
            return i;
        }
        if (2L * Math.round((double)k / 2.0) == (long)k) {
            throw new IllegalScalingException("Odd number of values into an even filter! Change the number of values/iterations: " + k);
        }
        throw new IllegalScalingException("Even number of values into an odd filter! Change the number of values/iterations: " + k);
    }

    public static double[] evalScaling(Filter filtre, int n0, int j1, int k) {
        if (j1 > 20) {
            throw new IllegalArgumentException("Too many iterations : " + j1);
        }
        if (n0 <= 0) {
            throw new IllegalArgumentException("Must have a positive number of scaling functions : " + n0 + " < 0.");
        }
        double[] init = new double[n0];
        if (k >= init.length || k < 0) {
            throw new IllegalArgumentException("There are " + init.length + " scaling functions going from 0 to " + (init.length - 1) + " and you are trying to get the " + k + "th function.");
        }
        init[k] = 1.0;
        return Cascades.evaluation(filtre, j1, init);
    }

    public static double[] evalWavelet(Filter filtre, int filtretype, int n0, int j1, int k) {
        if (j1 > 20) {
            throw new IllegalArgumentException("Too many iterations : " + j1);
        }
        if (n0 - filtretype <= 0) {
            throw new IllegalArgumentException("With " + n0 + " scaling functions and a filter of type " + filtretype + ", you are left with no wavelets. Please change the number of scaling functions, the multiresolution or the number of iterations");
        }
        double[] init = new double[n0 - filtretype];
        if (k >= init.length || k < 0) {
            throw new IllegalArgumentException("There are " + init.length + " wavelets going from 0 to " + (init.length - 1) + " and you are trying to get to the " + k + "th wavelet.");
        }
        init[k] = 1.0;
        double[] filtreWavelet = filtre.highpass(init);
        return Cascades.evaluation(filtre, j1, filtreWavelet);
    }

    public static double[] evalWavelet(Filter filtre, int n0, int j1, int k) {
        return Cascades.evalWavelet(filtre, 1, n0, j1, k);
    }

    public static double[] evalWaveletHaar(Filter filtre, int n0, int j1, int k) {
        return Cascades.evalWavelet(filtre, 0, n0, j1, k);
    }

    public static double[] evalWaveletQuadratic(Filter filtre, int n0, int j1, int k) {
        return Cascades.evalWavelet(filtre, 2, n0, j1, k);
    }

    public static int PowerOf2(int pwrOf2) {
        if (pwrOf2 < 0) {
            throw new IllegalArgumentException("This parametre must be positive : " + pwrOf2 + " < 0");
        }
        int reponse = 1;
        for (int i = pwrOf2; i > 0; --i) {
            reponse *= 2;
        }
        return reponse;
    }

    public static double[] oversample(double[] data) {
        double[] answer = new double[2 * data.length - 1];
        for (int i = 0; i < data.length - 1; ++i) {
            answer[2 * i] = data[i];
        }
        answer[2 * data.length - 2] = data[data.length - 1];
        return answer;
    }

    public static double[] doublesample(double[] data) {
        int Nombre = data.length;
        double[] answer = new double[2 * Nombre];
        for (int i = 0; i < Nombre; ++i) {
            answer[2 * i + 1] = data[i];
        }
        return answer;
    }

    public static double[] supersample(double[] data) {
        int Nombre = data.length;
        double[] answer = new double[2 * Nombre + 1];
        for (int i = 0; i < Nombre; ++i) {
            answer[2 * i + 1] = data[i];
        }
        return answer;
    }

    public static double[] quadraticOversample(double[] v) {
        double[] ans = new double[2 * v.length - 2];
        ans[0] = v[0];
        ans[ans.length - 1] = v[v.length - 1];
        for (int k = 1; k < v.length - 1; ++k) {
            ans[2 * k - 1] = v[k];
        }
        return ans;
    }

    public static int dimension(int n0, int jfin, int filtertype) {
        return Cascades.PowerOf2(jfin) * (n0 - filtertype) + filtertype;
    }

    public static int dimension(int n0, int jfin) {
        return Cascades.PowerOf2(jfin) * (n0 - 1) + 1;
    }

    public static int dimensionHaar(int n0, int jfin) {
        return Cascades.PowerOf2(jfin) * n0;
    }

    public static double[] evaluation(Filter filtre, int j1, double[] init) {
        if (j1 < 0) {
            throw new IllegalArgumentException("Incorrect parameters : " + j1 + " < 0 ");
        }
        if (j1 > 20) {
            throw new IllegalArgumentException("Excessive number of iterations: " + j1);
        }
        double[] data = init;
        for (int j = 0; j < j1; ++j) {
            data = filtre.lowpass(data);
        }
        return data;
    }
}

