/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.maths.MathInteger;
import jsci.maths.algebras.Module;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.Complex3Vector;
import jsci.maths.vectors.Double3Vector;
import jsci.maths.vectors.VectorDimensionException;

public final class Integer3Vector
extends AbstractIntegerVector {
    protected int x;
    protected int y;
    protected int z;

    public Integer3Vector() {
        super(3);
    }

    public Integer3Vector(int x, int y, int z) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Integer3Vector(int[] array) {
        this();
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
    }

    public boolean equals(Object obj, double tol) {
        if (obj != null && obj instanceof Integer3Vector) {
            Integer3Vector vec = (Integer3Vector)obj;
            int dx = this.x - vec.x;
            int dy = this.y - vec.y;
            int dz = this.z - vec.z;
            return dx * dx + dy * dy + dz * dz == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(15);
        buf.append(this.x).append(',').append(this.y).append(',').append(this.z);
        return buf.toString();
    }

    @Override
    public AbstractDoubleVector toDoubleVector() {
        return new Double3Vector(this.x, this.y, this.z);
    }

    public AbstractComplexVector toComplexVector() {
        return new Complex3Vector(this.x, 0.0, this.y, 0.0, this.z, 0.0);
    }

    @Override
    public int getComponent(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    @Override
    public void setComponent(int n, int value) {
        switch (n) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    @Override
    public double norm(int n) {
        double answer = Math.pow(Math.abs(this.x), n) + Math.pow(Math.abs(this.y), n) + Math.pow(Math.abs(this.z), n);
        return Math.pow(answer, 1.0 / (double)n);
    }

    @Override
    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public double infNorm() {
        int infNorm = 0;
        int abs = Math.abs(this.x);
        if (abs > infNorm) {
            infNorm = abs;
        }
        if ((abs = Math.abs(this.y)) > infNorm) {
            infNorm = abs;
        }
        if ((abs = Math.abs(this.z)) > infNorm) {
            infNorm = abs;
        }
        return infNorm;
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Integer3Vector(-this.x, -this.y, -this.z);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member vec) {
        if (vec instanceof AbstractIntegerVector) {
            return this.add((AbstractIntegerVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractIntegerVector add(AbstractIntegerVector vec) {
        if (vec.N == 3) {
            return new Integer3Vector(this.x + vec.getComponent(0), this.y + vec.getComponent(1), this.z + vec.getComponent(2));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member vec) {
        if (vec instanceof AbstractIntegerVector) {
            return this.subtract((AbstractIntegerVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractIntegerVector subtract(AbstractIntegerVector vec) {
        if (vec.N == 3) {
            return new Integer3Vector(this.x - vec.getComponent(0), this.y - vec.getComponent(1), this.z - vec.getComponent(2));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractIntegerVector scalarMultiply(int k) {
        return new Integer3Vector(k * this.x, k * this.y, k * this.z);
    }

    @Override
    public int scalarProduct(AbstractIntegerVector vec) {
        if (vec.N == 3) {
            return this.x * vec.getComponent(0) + this.y * vec.getComponent(1) + this.z * vec.getComponent(2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Integer3Vector multiply(Integer3Vector vec) {
        return new Integer3Vector(this.y * vec.z - vec.y * this.z, this.z * vec.x - vec.z * this.x, this.x * vec.y - vec.x * this.y);
    }
}

