/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.maths.Mapping;
import jsci.maths.MathDouble;
import jsci.maths.MathInteger;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.Complex3Vector;
import jsci.maths.vectors.Integer3Vector;
import jsci.maths.vectors.VectorDimensionException;

public final class Double3Vector
extends AbstractDoubleVector {
    protected double x;
    protected double y;
    protected double z;

    public Double3Vector() {
        super(3);
    }

    public Double3Vector(double x, double y, double z) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Double3Vector(double[] array) {
        this();
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
    }

    @Override
    public boolean equals(Object obj, double tol) {
        if (obj != null && obj instanceof Double3Vector) {
            Double3Vector vec = (Double3Vector)obj;
            double dx = this.x - vec.x;
            double dy = this.y - vec.y;
            double dz = this.z - vec.z;
            return dx * dx + dy * dy + dz * dz <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(15);
        buf.append(this.x).append(',').append(this.y).append(',').append(this.z);
        return buf.toString();
    }

    public AbstractIntegerVector toIntegerVector() {
        return new Integer3Vector(Math.round((float)this.x), Math.round((float)this.y), Math.round((float)this.z));
    }

    public AbstractComplexVector toComplexVector() {
        return new Complex3Vector(this.x, 0.0, this.y, 0.0, this.z, 0.0);
    }

    @Override
    public double getComponent(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    @Override
    public void setComponent(int n, double value) {
        switch (n) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    @Override
    public double norm(int n) {
        double answer = Math.pow(Math.abs(this.x), n) + Math.pow(Math.abs(this.y), n) + Math.pow(Math.abs(this.z), n);
        return Math.pow(answer, 1.0 / (double)n);
    }

    @Override
    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public double infNorm() {
        double infNorm = 0.0;
        double abs = Math.abs(this.x);
        if (abs > infNorm) {
            infNorm = abs;
        }
        if ((abs = Math.abs(this.y)) > infNorm) {
            infNorm = abs;
        }
        if ((abs = Math.abs(this.z)) > infNorm) {
            infNorm = abs;
        }
        return infNorm;
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Double3Vector(-this.x, -this.y, -this.z);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member vec) {
        if (vec instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector add(AbstractDoubleVector vec) {
        if (vec.N == 3) {
            return new Double3Vector(this.x + vec.getComponent(0), this.y + vec.getComponent(1), this.z + vec.getComponent(2));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member vec) {
        if (vec instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector subtract(AbstractDoubleVector vec) {
        if (vec.N == 3) {
            return new Double3Vector(this.x - vec.getComponent(0), this.y - vec.getComponent(1), this.z - vec.getComponent(2));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)x).value());
        }
        if (x instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector scalarMultiply(double k) {
        return new Double3Vector(k * this.x, k * this.y, k * this.z);
    }

    @Override
    public VectorSpace.Member scalarDivide(Field.Member x) {
        if (x instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector scalarDivide(double k) {
        return new Double3Vector(this.x / k, this.y / k, this.z / k);
    }

    @Override
    public double scalarProduct(AbstractDoubleVector vec) {
        if (vec.N == 3) {
            return this.x * vec.getComponent(0) + this.y * vec.getComponent(1) + this.z * vec.getComponent(2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Double3Vector multiply(Double3Vector vec) {
        return new Double3Vector(this.y * vec.z - vec.y * this.z, this.z * vec.x - vec.z * this.x, this.x * vec.y - vec.x * this.y);
    }

    @Override
    public AbstractDoubleVector mapComponents(Mapping mapping) {
        return new Double3Vector(mapping.map(this.x), mapping.map(this.y), mapping.map(this.z));
    }
}

