/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.MathDouble;
import jsci.maths.MathInteger;
import jsci.maths.algebras.HilbertSpace;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.DoubleVector;
import jsci.maths.vectors.IntegerVector;
import jsci.maths.vectors.VectorDimensionException;

public class ComplexVector
extends AbstractComplexVector {
    protected double[] vectorRe;
    protected double[] vectorIm;

    public ComplexVector(int dim) {
        super(dim);
        this.vectorRe = new double[dim];
        this.vectorIm = new double[dim];
    }

    public ComplexVector(double[] real, double[] imag) {
        super(real.length);
        this.vectorRe = real;
        this.vectorIm = imag;
    }

    public ComplexVector(Complex[] array) {
        this(array.length);
        for (int i = 0; i < this.N; ++i) {
            this.vectorRe[i] = array[i].real();
            this.vectorIm[i] = array[i].imag();
        }
    }

    @Override
    public boolean equals(Object a, double tol) {
        if (a != null && a instanceof ComplexVector && this.N == ((ComplexVector)a).N) {
            ComplexVector cv = (ComplexVector)a;
            double sumSqr = 0.0;
            for (int i = 0; i < this.N; ++i) {
                double deltaRe = this.vectorRe[i] - cv.getRealComponent(i);
                double deltaIm = this.vectorIm[i] - cv.getImagComponent(i);
                sumSqr += deltaRe * deltaRe + deltaIm * deltaIm;
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(8 * this.N);
        for (i = 0; i < this.N - 1; ++i) {
            buf.append(Complex.toString(this.vectorRe[i], this.vectorIm[i]));
            buf.append(',');
        }
        buf.append(Complex.toString(this.vectorRe[i], this.vectorIm[i]));
        return buf.toString();
    }

    @Override
    public AbstractDoubleVector real() {
        return new DoubleVector(this.vectorRe);
    }

    @Override
    public AbstractDoubleVector imag() {
        return new DoubleVector(this.vectorIm);
    }

    @Override
    public Complex getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return new Complex(this.vectorRe[n], this.vectorIm[n]);
        }
        throw new VectorDimensionException(ComplexVector.getInvalidComponentMsg(n));
    }

    @Override
    public double getRealComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vectorRe[n];
        }
        throw new VectorDimensionException(ComplexVector.getInvalidComponentMsg(n));
    }

    @Override
    public double getImagComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vectorIm[n];
        }
        throw new VectorDimensionException(ComplexVector.getInvalidComponentMsg(n));
    }

    @Override
    public void setComponent(int n, Complex z) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(ComplexVector.getInvalidComponentMsg(n));
        }
        this.vectorRe[n] = z.real();
        this.vectorIm[n] = z.imag();
    }

    @Override
    public void setComponent(int n, double x, double y) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(ComplexVector.getInvalidComponentMsg(n));
        }
        this.vectorRe[n] = x;
        this.vectorIm[n] = y;
    }

    @Override
    public double norm() {
        double answer = this.vectorRe[0] * this.vectorRe[0] + this.vectorIm[0] * this.vectorIm[0];
        for (int i = 1; i < this.N; ++i) {
            answer += this.vectorRe[i] * this.vectorRe[i] + this.vectorIm[i] * this.vectorIm[i];
        }
        return Math.sqrt(answer);
    }

    @Override
    public double infNorm() {
        double infNorm = this.vectorRe[0] * this.vectorRe[0] + this.vectorIm[0] * this.vectorIm[0];
        for (int i = 1; i < this.N; ++i) {
            double mod = this.vectorRe[i] * this.vectorRe[i] + this.vectorIm[i] * this.vectorIm[i];
            if (!(mod > infNorm)) continue;
            infNorm = mod;
        }
        return Math.sqrt(infNorm);
    }

    @Override
    public AbelianGroup.Member negate() {
        double[] arrayRe = new double[this.N];
        double[] arrayIm = new double[this.N];
        arrayRe[0] = -this.vectorRe[0];
        arrayIm[0] = -this.vectorIm[0];
        for (int i = 1; i < this.N; ++i) {
            arrayRe[i] = -this.vectorRe[i];
            arrayIm[i] = -this.vectorIm[i];
        }
        return new ComplexVector(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexVector conjugate() {
        double[] arrayIm = new double[this.N];
        arrayIm[0] = -this.vectorIm[0];
        for (int i = 1; i < this.N; ++i) {
            arrayIm[i] = -this.vectorIm[i];
        }
        return new ComplexVector(this.vectorRe, arrayIm);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member v) {
        if (v instanceof ComplexVector) {
            return this.add((ComplexVector)v);
        }
        if (v instanceof DoubleVector) {
            return this.add((DoubleVector)v);
        }
        if (v instanceof IntegerVector) {
            return this.add((IntegerVector)v);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector add(AbstractComplexVector v) {
        if (v instanceof ComplexVector) {
            return this.add((ComplexVector)v);
        }
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            double[] arrayIm = new double[this.N];
            arrayRe[0] = this.vectorRe[0] + v.getComponent(0).real();
            arrayIm[0] = this.vectorIm[0] + v.getComponent(0).imag();
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] + v.getComponent(i).real();
                arrayIm[i] = this.vectorIm[i] + v.getComponent(i).imag();
            }
            return new ComplexVector(arrayRe, arrayIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector add(ComplexVector v) {
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            double[] arrayIm = new double[this.N];
            arrayRe[0] = this.vectorRe[0] + v.vectorRe[0];
            arrayIm[0] = this.vectorIm[0] + v.vectorIm[0];
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] + v.vectorRe[i];
                arrayIm[i] = this.vectorIm[i] + v.vectorIm[i];
            }
            return new ComplexVector(arrayRe, arrayIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractDoubleVector v) {
        if (v instanceof DoubleVector) {
            return this.add((DoubleVector)v);
        }
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            arrayRe[0] = this.vectorRe[0] + v.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] + v.getComponent(i);
            }
            return new ComplexVector(arrayRe, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector add(DoubleVector v) {
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            arrayRe[0] = this.vectorRe[0] + v.vector[0];
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] + v.vector[i];
            }
            return new ComplexVector(arrayRe, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractIntegerVector v) {
        if (v instanceof IntegerVector) {
            return this.add((IntegerVector)v);
        }
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            arrayRe[0] = this.vectorRe[0] + (double)v.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] + (double)v.getComponent(i);
            }
            return new ComplexVector(arrayRe, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector add(IntegerVector v) {
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            arrayRe[0] = this.vectorRe[0] + (double)v.vector[0];
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] + (double)v.vector[i];
            }
            return new ComplexVector(arrayRe, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member v) {
        if (v instanceof ComplexVector) {
            return this.subtract((ComplexVector)v);
        }
        if (v instanceof DoubleVector) {
            return this.subtract((DoubleVector)v);
        }
        if (v instanceof IntegerVector) {
            return this.subtract((IntegerVector)v);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector subtract(AbstractComplexVector v) {
        if (v instanceof ComplexVector) {
            return this.subtract((ComplexVector)v);
        }
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            double[] arrayIm = new double[this.N];
            arrayRe[0] = this.vectorRe[0] - v.getComponent(0).real();
            arrayIm[0] = this.vectorIm[0] - v.getComponent(0).imag();
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] - v.getComponent(i).real();
                arrayIm[i] = this.vectorIm[i] - v.getComponent(i).imag();
            }
            return new ComplexVector(arrayRe, arrayIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector subtract(ComplexVector v) {
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            double[] arrayIm = new double[this.N];
            arrayRe[0] = this.vectorRe[0] - v.vectorRe[0];
            arrayIm[0] = this.vectorIm[0] - v.vectorIm[0];
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] - v.vectorRe[i];
                arrayIm[i] = this.vectorIm[i] - v.vectorIm[i];
            }
            return new ComplexVector(arrayRe, arrayIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractDoubleVector v) {
        if (v instanceof DoubleVector) {
            return this.subtract((DoubleVector)v);
        }
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            arrayRe[0] = this.vectorRe[0] - v.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] - v.getComponent(i);
            }
            return new ComplexVector(arrayRe, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector subtract(DoubleVector v) {
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            arrayRe[0] = this.vectorRe[0] - v.vector[0];
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] - v.vector[i];
            }
            return new ComplexVector(arrayRe, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractIntegerVector v) {
        if (v instanceof IntegerVector) {
            return this.subtract((IntegerVector)v);
        }
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            arrayRe[0] = this.vectorRe[0] - (double)v.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] - (double)v.getComponent(i);
            }
            return new ComplexVector(arrayRe, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector subtract(IntegerVector v) {
        if (this.N == v.N) {
            double[] arrayRe = new double[this.N];
            arrayRe[0] = this.vectorRe[0] - (double)v.vector[0];
            for (int i = 1; i < this.N; ++i) {
                arrayRe[i] = this.vectorRe[i] - (double)v.vector[i];
            }
            return new ComplexVector(arrayRe, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof Complex) {
            return this.scalarMultiply((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector scalarMultiply(Complex z) {
        double real = z.real();
        double imag = z.imag();
        double[] arrayRe = new double[this.N];
        double[] arrayIm = new double[this.N];
        arrayRe[0] = this.vectorRe[0] * real - this.vectorIm[0] * imag;
        arrayIm[0] = this.vectorRe[0] * imag + this.vectorIm[0] * real;
        for (int i = 1; i < this.N; ++i) {
            arrayRe[i] = this.vectorRe[i] * real - this.vectorIm[i] * imag;
            arrayIm[i] = this.vectorRe[i] * imag + this.vectorIm[i] * real;
        }
        return new ComplexVector(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexVector scalarMultiply(double x) {
        double[] arrayRe = new double[this.N];
        double[] arrayIm = new double[this.N];
        arrayRe[0] = x * this.vectorRe[0];
        arrayIm[0] = x * this.vectorIm[0];
        for (int i = 1; i < this.N; ++i) {
            arrayRe[i] = x * this.vectorRe[i];
            arrayIm[i] = x * this.vectorIm[i];
        }
        return new ComplexVector(arrayRe, arrayIm);
    }

    @Override
    public VectorSpace.Member scalarDivide(Field.Member x) {
        if (x instanceof Complex) {
            return this.scalarDivide((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector scalarDivide(Complex z) {
        double real = z.real();
        double imag = z.imag();
        double[] arrayRe = new double[this.N];
        double[] arrayIm = new double[this.N];
        if (Math.abs(real) < Math.abs(imag)) {
            double a = real / imag;
            double denom = real * a + imag;
            for (int i = 0; i < this.N; ++i) {
                arrayRe[i] = (this.vectorRe[i] * a + this.vectorIm[i]) / denom;
                arrayIm[i] = (this.vectorIm[i] * a - this.vectorRe[i]) / denom;
            }
        } else {
            double a = imag / real;
            double denom = real + imag * a;
            for (int i = 0; i < this.N; ++i) {
                arrayRe[i] = (this.vectorRe[i] + this.vectorIm[i] * a) / denom;
                arrayIm[i] = (this.vectorIm[i] - this.vectorRe[i] * a) / denom;
            }
        }
        return new ComplexVector(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexVector scalarDivide(double x) {
        double[] arrayRe = new double[this.N];
        double[] arrayIm = new double[this.N];
        arrayRe[0] = this.vectorRe[0] / x;
        arrayIm[0] = this.vectorIm[0] / x;
        for (int i = 1; i < this.N; ++i) {
            arrayRe[i] = this.vectorRe[i] / x;
            arrayIm[i] = this.vectorIm[i] / x;
        }
        return new ComplexVector(arrayRe, arrayIm);
    }

    @Override
    public Complex scalarProduct(HilbertSpace.Member v) {
        if (v instanceof ComplexVector) {
            return this.scalarProduct((ComplexVector)v);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public Complex scalarProduct(AbstractComplexVector v) {
        if (v instanceof ComplexVector) {
            return this.rawScalarProduct((ComplexVector)v);
        }
        if (this.N == v.N) {
            Complex comp = v.getComponent(0);
            double real = this.vectorRe[0] * comp.real() + this.vectorIm[0] * comp.imag();
            double imag = this.vectorIm[0] * comp.real() - this.vectorRe[0] * comp.imag();
            for (int i = 1; i < this.N; ++i) {
                comp = v.getComponent(i);
                real += this.vectorRe[i] * comp.real() + this.vectorIm[i] * comp.imag();
                imag += this.vectorIm[i] * comp.real() - this.vectorRe[i] * comp.imag();
            }
            return new Complex(real, imag);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private Complex rawScalarProduct(ComplexVector v) {
        if (this.N == v.N) {
            double real = this.vectorRe[0] * v.vectorRe[0] + this.vectorIm[0] * v.vectorIm[0];
            double imag = this.vectorIm[0] * v.vectorRe[0] - this.vectorRe[0] * v.vectorIm[0];
            for (int i = 1; i < this.N; ++i) {
                real += this.vectorRe[i] * v.vectorRe[i] + this.vectorIm[i] * v.vectorIm[i];
                imag += this.vectorIm[i] * v.vectorRe[i] - this.vectorRe[i] * v.vectorIm[i];
            }
            return new Complex(real, imag);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public AbstractComplexVector mapComponents(ComplexMapping f) {
        Complex[] array = new Complex[this.N];
        array[0] = f.map(this.vectorRe[0], this.vectorIm[0]);
        for (int i = 1; i < this.N; ++i) {
            array[i] = f.map(this.vectorRe[i], this.vectorIm[i]);
        }
        return new ComplexVector(array);
    }
}

