/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.symbolic;

import jsci.maths.Member;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.symbolic.Constant;
import jsci.maths.symbolic.Expression;

public class Variable
extends Expression {
    private final String name;
    private final Object valueSet;
    private Member value = null;

    public Variable(String n, Object valueSet) {
        this.name = n;
        this.valueSet = valueSet;
    }

    public void setValue(Member o) {
        if (o == null) {
            this.value = null;
            return;
        }
        if (!this.valueSet.getClass().isInstance(o.getSet())) {
            throw new ClassCastException("Variable " + this + " set to " + o.getSet() + " value (" + this.valueSet + " required.");
        }
        this.value = o;
    }

    public Member getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Variable)) {
            return false;
        }
        return this == o;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Expression differentiate(Variable x) {
        if (this.equals(x)) {
            return new Constant(((Ring)this.valueSet).one());
        }
        return new Constant(((AbelianGroup)this.valueSet).zero());
    }

    @Override
    public Expression evaluate() {
        if (this.value == null) {
            return this;
        }
        if (this.value instanceof Expression) {
            return ((Expression)this.value).evaluate();
        }
        return new Constant(this.value);
    }

    @Override
    protected int getPriority() {
        return 20;
    }

    @Override
    public Object getSet() {
        return (AbelianGroup)this.valueSet;
    }
}

