/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.symbolic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsci.maths.Member;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.symbolic.Constant;
import jsci.maths.symbolic.Expression;
import jsci.maths.symbolic.Variable;

class Sum
extends Expression {
    private final List terms;

    public Sum(Expression[] a) {
        this.terms = Arrays.asList(a);
    }

    public Sum(List a) {
        this.terms = a;
    }

    public Sum(Expression a, Expression b) {
        this.terms = new ArrayList();
        this.terms.add(a);
        this.terms.add(b);
    }

    public String toString() {
        String r = "";
        for (int j = 0; j < this.terms.size(); ++j) {
            Expression f;
            if (j > 0) {
                r = r + "+";
            }
            r = (f = (Expression)this.terms.get(j)).getPriority() < this.getPriority() ? r + "(" + f + ")" : r + "" + f;
        }
        return r;
    }

    @Override
    public Expression differentiate(Variable x) {
        ArrayList<Expression> r = new ArrayList<Expression>();
        for (int j = 0; j < this.terms.size(); ++j) {
            r.add(((Expression)this.terms.get(j)).differentiate(x));
        }
        return new Sum(r);
    }

    @Override
    public Expression evaluate() {
        ArrayList t = new ArrayList();
        for (int j = 0; j < this.terms.size(); ++j) {
            Expression f = ((Expression)this.terms.get(j)).evaluate();
            if (f instanceof Sum) {
                for (int k = 0; k < ((Sum)f).terms.size(); ++k) {
                    t.add(((Sum)f).terms.get(k));
                }
                continue;
            }
            t.add(f);
        }
        Member c = null;
        ArrayList<Expression> s = new ArrayList<Expression>();
        for (int j = 0; j < t.size(); ++j) {
            Expression f = (Expression)t.get(j);
            if (f instanceof Constant) {
                if (c == null) {
                    c = (AbelianGroup.Member)((Constant)f).getValue();
                    continue;
                }
                c = c.add((AbelianGroup.Member)((Constant)f).getValue());
                continue;
            }
            s.add(f);
        }
        if (c != null && !((AbelianGroup)c.getSet()).isZero((AbelianGroup.Member)c)) {
            s.add(new Constant(c));
        }
        if (s.size() == 0) {
            return new Constant(((AbelianGroup)this.getSet()).zero());
        }
        if (s.size() == 1) {
            return (Expression)s.get(0);
        }
        return new Sum(s);
    }

    @Override
    protected int getPriority() {
        return 0;
    }

    @Override
    public Object getSet() {
        return ((Member)this.terms.get(0)).getSet();
    }
}

