/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.symbolic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import jsci.maths.Member;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.symbolic.Constant;
import jsci.maths.symbolic.Expression;
import jsci.maths.symbolic.Power;
import jsci.maths.symbolic.Sum;
import jsci.maths.symbolic.Variable;

class Product
extends Expression {
    private final List terms;

    public Product(Expression[] a) {
        this.terms = Arrays.asList(a);
    }

    public Product(List a) {
        this.terms = a;
    }

    public Product(Expression a, Expression b) {
        this.terms = new ArrayList();
        this.terms.add(a);
        this.terms.add(b);
    }

    public String toString() {
        String r = "";
        for (int j = 0; j < this.terms.size(); ++j) {
            Expression f;
            if (j > 0) {
                r = r + "*";
            }
            r = (f = (Expression)this.terms.get(j)).getPriority() < this.getPriority() ? r + "(" + f + ")" : r + "" + f;
        }
        return r;
    }

    @Override
    public Expression differentiate(Variable x) {
        ArrayList<Product> r = new ArrayList<Product>();
        for (int j = 0; j < this.terms.size(); ++j) {
            ArrayList<Expression> p = new ArrayList<Expression>();
            for (int k = 0; k < this.terms.size(); ++k) {
                if (j == k) {
                    p.add(((Expression)this.terms.get(k)).differentiate(x));
                    continue;
                }
                p.add((Expression)this.terms.get(k));
            }
            r.add(new Product(p));
        }
        return new Sum(r);
    }

    @Override
    public Expression evaluate() {
        int e;
        Expression b;
        ArrayList t = new ArrayList();
        for (int j = 0; j < this.terms.size(); ++j) {
            Expression f = ((Expression)this.terms.get(j)).evaluate();
            if (Product.class.isInstance(f)) {
                for (int k = 0; k < ((Product)f).terms.size(); ++k) {
                    t.add(((Product)f).terms.get(k));
                }
                continue;
            }
            t.add(f);
        }
        Member c = null;
        ArrayList<Expression> s = new ArrayList<Expression>();
        for (int j = 0; j < t.size(); ++j) {
            Expression f = (Expression)t.get(j);
            if (f instanceof Constant) {
                if (c == null) {
                    c = (Ring.Member)((Constant)f).getValue();
                    continue;
                }
                c = c.multiply((Ring.Member)((Constant)f).getValue());
                continue;
            }
            s.add(f);
        }
        if (c != null && ((AbelianGroup)c.getSet()).isZero((AbelianGroup.Member)c)) {
            return new Constant(c);
        }
        if (c != null && !((Ring)c.getSet()).isOne((Ring.Member)c)) {
            s.add(new Constant(c));
        }
        Hashtable<Expression, Integer> h = new Hashtable<Expression, Integer>();
        for (int j = 0; j < s.size(); ++j) {
            if (s.get(j) instanceof Power) {
                b = ((Power)s.get(j)).getBase();
                e = ((Power)s.get(j)).getExponent();
            } else {
                b = (Expression)s.get(j);
                e = 1;
            }
            if (h.containsKey(b)) {
                e += ((Integer)h.get(b)).intValue();
            }
            h.put(b, new Integer(e));
        }
        s = new ArrayList();
        Enumeration fe = h.keys();
        while (fe.hasMoreElements()) {
            b = (Expression)fe.nextElement();
            e = (Integer)h.get(b);
            if (e == 0) continue;
            if (e == 1) {
                s.add(b);
                continue;
            }
            if (e == 0) continue;
            s.add(new Power(b, e));
        }
        if (s.size() == 0) {
            return new Constant(((Ring)this.getSet()).one());
        }
        if (s.size() == 1) {
            return (Expression)s.get(0);
        }
        return new Product(s);
    }

    @Override
    protected int getPriority() {
        return 10;
    }

    @Override
    public Object getSet() {
        return ((Member)this.terms.get(0)).getSet();
    }
}

