/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.symbolic;

import jsci.maths.Complex;
import jsci.maths.MathDouble;
import jsci.maths.fields.Ring;
import jsci.maths.symbolic.Constant;
import jsci.maths.symbolic.Expression;
import jsci.maths.symbolic.Variable;

public class Function
extends Expression {
    public static final String SIN = "sin";
    public static final String COS = "cos";
    public static final String TAN = "tan";
    public static final String ASIN = "asin";
    public static final String ACOS = "acos";
    public static final String ATAN = "atan";
    public static final String SINH = "sinh";
    public static final String COSH = "cosh";
    public static final String TANH = "tanh";
    public static final String ASINH = "asinh";
    public static final String ACOSH = "acosh";
    public static final String ATANH = "atanh";
    public static final String EXP = "exp";
    public static final String LOG = "log";
    public static final String SQRT = "sqrt";
    private final String type;
    private final Expression arg;

    public Function(String n, Expression a) {
        this.type = n;
        this.arg = a;
    }

    public String toString() {
        return this.type + "(" + this.arg + ")";
    }

    @Override
    public int getPriority() {
        return 15;
    }

    @Override
    public Expression differentiate(Variable x) {
        Expression d = null;
        if (this.type.equals(SIN)) {
            d = new Function(COS, this.arg);
        }
        if (this.type.equals(COS)) {
            d = Expression.negative(new Function(SIN, this.arg));
        }
        if (this.type.equals(TAN)) {
            d = Expression.power(new Function(COS, this.arg), -2);
        }
        if (this.type.equals(ASIN)) {
            d = Expression.inverse(new Function(SQRT, Expression.sum(((Ring)this.getSet()).one(), Expression.negative(Expression.power(this.arg, 2)))));
        }
        if (this.type.equals(ACOS)) {
            d = Expression.inverse(new Function(SQRT, Expression.sum(((Ring)this.getSet()).one(), Expression.negative(Expression.power(this.arg, 2)))));
        }
        if (this.type.equals(ATAN)) {
            d = Expression.inverse(Expression.sum(((Ring)this.getSet()).one(), Expression.power(this.arg, 2)));
        }
        if (this.type.equals(SINH)) {
            d = new Function(COSH, this.arg);
        }
        if (this.type.equals(COSH)) {
            d = new Function(SINH, this.arg);
        }
        if (this.type.equals(TANH)) {
            d = Expression.power(new Function(COSH, this.arg), -2);
        }
        if (this.type.equals(ASINH)) {
            d = Expression.inverse(new Function(SQRT, Expression.sum(((Ring)this.getSet()).one(), Expression.power(this.arg, 2))));
        }
        if (this.type.equals(ACOSH)) {
            d = Expression.inverse(new Function(SQRT, Expression.sum(((Ring)this.getSet()).one().negate(), Expression.power(this.arg, 2))));
        }
        if (this.type.equals(ATANH)) {
            d = Expression.inverse(new Function(SQRT, Expression.sum(((Ring)this.getSet()).one(), Expression.power(this.arg, 2).negate())));
        }
        if (this.type.equals(EXP)) {
            d = new Function(EXP, this.arg);
        }
        if (this.type.equals(LOG)) {
            d = Expression.inverse(this.arg);
        }
        if (this.type.equals(SQRT)) {
            d = Expression.inverse(Expression.product((Ring.Member)((Ring)this.getSet()).one().add(((Ring)this.getSet()).one()), new Function(SQRT, this.arg)));
        }
        if (d == null) {
            throw new IllegalArgumentException("Unknown Function type in derivative()");
        }
        return Expression.product(d, this.arg.differentiate(x));
    }

    public boolean equals(Object o) {
        if (!Function.class.isInstance(o)) {
            return false;
        }
        Function f = (Function)o;
        return this.type.equals(f.type) && this.arg.equals(f.arg);
    }

    @Override
    public Object getSet() {
        return this.arg.getSet();
    }

    @Override
    public Expression evaluate() {
        Expression sarg = this.arg.evaluate();
        if (sarg instanceof Constant) {
            if (((Constant)sarg).getValue() instanceof Complex) {
                Complex a = (Complex)((Constant)sarg).getValue();
                if (this.type.equals(SIN)) {
                    return new Constant(Complex.sin(a));
                }
                if (this.type.equals(COS)) {
                    return new Constant(Complex.cos(a));
                }
                if (this.type.equals(TAN)) {
                    return new Constant(Complex.tan(a));
                }
                if (this.type.equals(ASIN)) {
                    return new Constant(Complex.asin(a));
                }
                if (this.type.equals(ACOS)) {
                    return new Constant(Complex.acos(a));
                }
                if (this.type.equals(ATAN)) {
                    return new Constant(Complex.atan(a));
                }
                if (this.type.equals(SIN)) {
                    return new Constant(Complex.sinh(a));
                }
                if (this.type.equals(COS)) {
                    return new Constant(Complex.cosh(a));
                }
                if (this.type.equals(TAN)) {
                    return new Constant(Complex.tanh(a));
                }
                if (this.type.equals(ASIN)) {
                    return new Constant(Complex.asinh(a));
                }
                if (this.type.equals(ACOS)) {
                    return new Constant(Complex.acosh(a));
                }
                if (this.type.equals(ATAN)) {
                    return new Constant(Complex.atanh(a));
                }
                if (this.type.equals(EXP)) {
                    return new Constant(Complex.exp(a));
                }
                if (this.type.equals(LOG)) {
                    return new Constant(Complex.log(a));
                }
                if (this.type.equals(SQRT)) {
                    return new Constant(a.sqrt());
                }
                throw new IllegalArgumentException("Unknown Function type in evaluate()");
            }
            if (((Constant)sarg).getValue() instanceof MathDouble) {
                MathDouble a = (MathDouble)((Constant)sarg).getValue();
                if (this.type.equals(SIN)) {
                    return new Constant(MathDouble.sin(a));
                }
                if (this.type.equals(COS)) {
                    return new Constant(MathDouble.cos(a));
                }
                if (this.type.equals(TAN)) {
                    return new Constant(MathDouble.tan(a));
                }
                if (this.type.equals(ASIN)) {
                    return new Constant(MathDouble.asin(a));
                }
                if (this.type.equals(ACOS)) {
                    return new Constant(MathDouble.acos(a));
                }
                if (this.type.equals(ATAN)) {
                    return new Constant(MathDouble.atan(a));
                }
                if (this.type.equals(SIN)) {
                    return new Constant(MathDouble.sinh(a));
                }
                if (this.type.equals(COS)) {
                    return new Constant(MathDouble.cosh(a));
                }
                if (this.type.equals(TAN)) {
                    return new Constant(MathDouble.tanh(a));
                }
                if (this.type.equals(ASIN)) {
                    return new Constant(MathDouble.asinh(a));
                }
                if (this.type.equals(ACOS)) {
                    return new Constant(MathDouble.acosh(a));
                }
                if (this.type.equals(ATAN)) {
                    return new Constant(MathDouble.atanh(a));
                }
                if (this.type.equals(EXP)) {
                    return new Constant(MathDouble.exp(a));
                }
                if (this.type.equals(LOG)) {
                    return new Constant(MathDouble.log(a));
                }
                if (this.type.equals(SQRT)) {
                    return new Constant(new MathDouble(Math.sqrt(a.value())));
                }
                throw new IllegalArgumentException("Unknown Function type in evaluate()");
            }
            throw new IllegalArgumentException("Function argument is " + sarg.getSet() + " ; must be Complex or MathDouble");
        }
        if (sarg instanceof Function) {
            Function f = (Function)sarg;
            if (this.type.equals(SIN) && f.type.equals(ASIN)) {
                return f.arg;
            }
            if (this.type.equals(COS) && f.type.equals(ACOS)) {
                return f.arg;
            }
            if (this.type.equals(TAN) && f.type.equals(ATAN)) {
                return f.arg;
            }
            if (this.type.equals(ASIN) && f.type.equals(SIN)) {
                return f.arg;
            }
            if (this.type.equals(ACOS) && f.type.equals(COS)) {
                return f.arg;
            }
            if (this.type.equals(ATAN) && f.type.equals(TAN)) {
                return f.arg;
            }
            if (this.type.equals(SINH) && f.type.equals(ASINH)) {
                return f.arg;
            }
            if (this.type.equals(COSH) && f.type.equals(ACOSH)) {
                return f.arg;
            }
            if (this.type.equals(TANH) && f.type.equals(ATANH)) {
                return f.arg;
            }
            if (this.type.equals(ASINH) && f.type.equals(SINH)) {
                return f.arg;
            }
            if (this.type.equals(ACOSH) && f.type.equals(COSH)) {
                return f.arg;
            }
            if (this.type.equals(ATANH) && f.type.equals(TANH)) {
                return f.arg;
            }
            if (this.type.equals(EXP) && f.type.equals(LOG)) {
                return f.arg;
            }
            if (this.type.equals(LOG) && f.type.equals(EXP)) {
                return f.arg;
            }
        }
        return new Function(this.type, sarg);
    }
}

