/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.symbolic;

import java.util.Enumeration;
import java.util.Hashtable;
import jsci.maths.fields.Field;
import jsci.maths.fields.RealField;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.symbolic.Constant;
import jsci.maths.symbolic.ExpressionParser;
import jsci.maths.symbolic.Negative;
import jsci.maths.symbolic.ParseException;
import jsci.maths.symbolic.Power;
import jsci.maths.symbolic.Product;
import jsci.maths.symbolic.Sum;
import jsci.maths.symbolic.Variable;

public abstract class Expression
implements Field.Member {
    public Expression differentiate(Hashtable ht) {
        Expression r = this;
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Variable x = (Variable)e.nextElement();
            for (int n = 0; n < (Integer)ht.get(x); ++n) {
                r = r.differentiate(x);
            }
        }
        return r;
    }

    public abstract Expression differentiate(Variable var1);

    public abstract Expression evaluate();

    protected abstract int getPriority();

    @Override
    public Field.Member inverse() {
        return new Power(this, -1);
    }

    @Override
    public Field.Member divide(Field.Member f) {
        Expression e = f instanceof Expression ? (Expression)f.inverse() : new Constant(f.inverse());
        return new Product(this, e);
    }

    @Override
    public Ring.Member multiply(Ring.Member r) {
        Expression e = r instanceof Expression ? (Expression)r : new Constant(r);
        return new Product(this, e);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member g) {
        Expression e = g instanceof Expression ? (Expression)g : new Constant(g);
        return new Sum(this, e);
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Negative(this);
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member g) {
        Expression e = g instanceof Expression ? (Expression)g.negate() : new Constant(g.negate());
        return new Sum(this, e);
    }

    public Ring.Member rise(int f) {
        return new Power(this, f);
    }

    public static Expression negative(AbelianGroup.Member r) {
        if (r instanceof Expression) {
            return (Expression)r.negate();
        }
        return new Constant(r.negate());
    }

    public static Expression sum(AbelianGroup.Member a, AbelianGroup.Member b) {
        Expression ea = a instanceof Expression ? (Expression)a : new Constant(a);
        Expression eb = b instanceof Expression ? (Expression)b : new Constant(b);
        return (Expression)ea.add(eb);
    }

    public static Expression sum(AbelianGroup.Member[] args) {
        Expression[] exprs = new Expression[args.length];
        for (int j = 0; j < args.length; ++j) {
            exprs[j] = args[j] instanceof Expression ? (Expression)args[j] : new Constant(args[j]);
        }
        return new Sum(exprs);
    }

    public static Expression difference(AbelianGroup.Member a, AbelianGroup.Member b) {
        Expression ea = a instanceof Expression ? (Expression)a : new Constant(a);
        Expression eb = b instanceof Expression ? (Expression)b : new Constant(b);
        return (Expression)ea.subtract(eb);
    }

    public static Expression product(Ring.Member a, Ring.Member b) {
        Expression ea = a instanceof Expression ? (Expression)a : new Constant(a);
        Expression eb = b instanceof Expression ? (Expression)b : new Constant(b);
        return (Expression)ea.multiply(eb);
    }

    public static Expression product(Ring.Member[] args) {
        Expression[] exprs = new Expression[args.length];
        for (int j = 0; j < args.length; ++j) {
            exprs[j] = args[j] instanceof Expression ? (Expression)args[j] : new Constant(args[j]);
        }
        return new Product(exprs);
    }

    public static Expression inverse(Field.Member f) {
        if (f instanceof Expression) {
            return (Expression)f.inverse();
        }
        return new Constant(f.inverse());
    }

    public static Expression divide(Field.Member f, Field.Member g) {
        Expression ef = f instanceof Expression ? (Expression)f : new Constant(f);
        Expression eg = g instanceof Expression ? (Expression)g : new Constant(g);
        return (Expression)ef.divide(eg);
    }

    public static Expression power(Field.Member f, int g) {
        Expression ef = f instanceof Expression ? (Expression)f : new Constant(f);
        return new Power(ef, g);
    }

    public static void main(String[] args) throws ParseException {
        for (int j = 0; j < args.length; ++j) {
            Hashtable<String, Variable> vars = new Hashtable<String, Variable>();
            vars.put("y", new Variable("y", RealField.getInstance()));
            Expression e = ExpressionParser.parse(args[j], vars);
            System.out.println("F = " + e);
            System.out.println("F = " + e.evaluate());
            System.out.println("dF/dx = " + e.differentiate((Variable)vars.get("x")).evaluate());
            System.out.println("dF/dy = " + e.differentiate((Variable)vars.get("y")).evaluate());
            System.out.println(" ");
        }
    }
}

