/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.polynomials;

import jsci.maths.Complex;
import jsci.maths.MathDouble;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.polynomials.ComplexPolynomial;

public class ComplexPolynomialRing
implements Ring {
    private static final ComplexPolynomial ZERO = new ComplexPolynomial(new Complex[]{Complex.ZERO});
    private static final ComplexPolynomial ONE = new ComplexPolynomial(new Complex[]{Complex.ONE});
    private static final ComplexPolynomialRing _instance = new ComplexPolynomialRing();

    protected ComplexPolynomialRing() {
    }

    public static final ComplexPolynomialRing getInstance() {
        return _instance;
    }

    @Override
    public boolean isNegative(AbelianGroup.Member a, AbelianGroup.Member b) {
        return a.add(b).equals(ZERO);
    }

    @Override
    public boolean isOne(Ring.Member r) {
        return r.equals(ONE);
    }

    @Override
    public boolean isZero(AbelianGroup.Member g) {
        return g.equals(ZERO);
    }

    @Override
    public Ring.Member one() {
        return ONE;
    }

    @Override
    public AbelianGroup.Member zero() {
        return ZERO;
    }

    protected static Complex[] toComplex(Field.Member[] f) {
        Complex[] _c = null;
        if (f == null) {
            _c = new Complex[]{Complex.ZERO};
        }
        if (f.length == 0) {
            _c = new Complex[]{Complex.ZERO};
        } else {
            _c = new Complex[f.length];
            for (int k = 0; k < _c.length; ++k) {
                if (f[k] instanceof Complex) {
                    _c[k] = (Complex)f[k];
                    continue;
                }
                if (f[k] instanceof MathDouble) {
                    _c[k] = new Complex(((MathDouble)f[k]).value(), 0.0);
                    continue;
                }
                throw new IllegalArgumentException("Different fields. Argument was " + f[k]);
            }
        }
        return _c;
    }
}

