/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.maths.DimensionException;
import jsci.maths.ExtraMath;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.AbstractIntegerMatrix;
import jsci.maths.matrices.ComplexMatrix;
import jsci.maths.matrices.DoubleMatrix;
import jsci.maths.matrices.IntegerSquareMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.IntegerVector;

public class IntegerMatrix
extends AbstractIntegerMatrix {
    protected final int[][] matrix;

    public IntegerMatrix(int[][] array) {
        super(array.length, array[0].length);
        this.matrix = array;
    }

    public IntegerMatrix(int rows, int cols) {
        this(new int[rows][cols]);
    }

    public IntegerMatrix(AbstractIntegerVector[] array) {
        this(array[0].dimension(), array.length);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.matrix[i][j] = array[j].getComponent(i);
            }
        }
    }

    @Override
    public boolean equals(AbstractIntegerMatrix m, double tol) {
        if (m != null && this.numRows == m.rows() && this.numCols == m.columns()) {
            int sumSqr = 0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    int delta = this.matrix[i][j] - m.getElement(i, j);
                    sumSqr += delta * delta;
                }
            }
            return (double)sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.matrix[i][j]);
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public AbstractDoubleMatrix toDoubleMatrix() {
        double[][] ans = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                ans[i][j] = this.matrix[i][j];
            }
        }
        return new DoubleMatrix(ans);
    }

    @Override
    public AbstractComplexMatrix toComplexMatrix() {
        ComplexMatrix cm = new ComplexMatrix(this.numRows, this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                cm.setElement(i, j, this.matrix[i][j], 0.0);
            }
        }
        return cm;
    }

    @Override
    public int getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            return this.matrix[i][j];
        }
        throw new MatrixDimensionException(IntegerMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public void setElement(int i, int j, int x) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols) {
            throw new MatrixDimensionException(IntegerMatrix.getInvalidElementMsg(i, j));
        }
        this.matrix[i][j] = x;
    }

    @Override
    public int infNorm() {
        int result = 0;
        for (int i = 0; i < this.numRows; ++i) {
            int tmpResult = 0;
            for (int j = 0; j < this.numCols; ++j) {
                tmpResult += Math.abs(this.matrix[i][j]);
            }
            if (tmpResult <= result) continue;
            result = tmpResult;
        }
        return result;
    }

    @Override
    public double frobeniusNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                result = ExtraMath.hypot(result, this.matrix[i][j]);
            }
        }
        return result;
    }

    @Override
    public AbelianGroup.Member negate() {
        int[][] array = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = -this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = -this.matrix[i][j];
            }
        }
        return new IntegerMatrix(array);
    }

    @Override
    public AbstractIntegerMatrix add(AbstractIntegerMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.matrix[i][0] + m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.matrix[i][j] + m.getElement(i, j);
                }
            }
            return new IntegerMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerMatrix subtract(AbstractIntegerMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.matrix[i][0] - m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.matrix[i][j] - m.getElement(i, j);
                }
            }
            return new IntegerMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerMatrix scalarMultiply(int x) {
        int[][] array = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = x * this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = x * this.matrix[i][j];
            }
        }
        return new IntegerMatrix(array);
    }

    @Override
    public int scalarProduct(AbstractIntegerMatrix m) {
        if (m instanceof IntegerMatrix) {
            return this.scalarProduct((IntegerMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int ans = 0;
            for (int i = 0; i < this.numRows; ++i) {
                ans += this.matrix[i][0] * m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    ans += this.matrix[i][j] * m.getElement(i, j);
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int ans = 0;
            for (int i = 0; i < this.numRows; ++i) {
                ans += this.matrix[i][0] * m.matrix[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    ans += this.matrix[i][j] * m.matrix[i][j];
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerVector multiply(AbstractIntegerVector v) {
        if (this.numCols == v.dimension()) {
            int[] array = new int[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                array[i] = this.matrix[i][0] * v.getComponent(0);
                for (int j = 1; j < this.numCols; ++j) {
                    int n = i;
                    array[n] = array[n] + this.matrix[i][j] * v.getComponent(j);
                }
            }
            return new IntegerVector(array);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractIntegerMatrix multiply(AbstractIntegerMatrix m) {
        if (m instanceof IntegerMatrix) {
            return this.multiply((IntegerMatrix)m);
        }
        if (this.numCols == m.rows()) {
            int mColumns = m.columns();
            int[][] array = new int[this.numRows][mColumns];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < mColumns; ++k) {
                    array[j][k] = this.matrix[j][0] * m.getElement(0, k);
                    for (int n = 1; n < this.numCols; ++n) {
                        int[] nArray = array[j];
                        int n2 = k;
                        nArray[n2] = nArray[n2] + this.matrix[j][n] * m.getElement(n, k);
                    }
                }
            }
            if (this.numRows == mColumns) {
                return new IntegerSquareMatrix(array);
            }
            return new IntegerMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractIntegerMatrix multiply(IntegerMatrix m) {
        if (this.numCols == m.numRows) {
            int[][] array = new int[this.numRows][m.numCols];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.numCols; ++k) {
                    array[j][k] = this.matrix[j][0] * m.matrix[0][k];
                    for (int n = 1; n < this.numCols; ++n) {
                        int[] nArray = array[j];
                        int n2 = k;
                        nArray[n2] = nArray[n2] + this.matrix[j][n] * m.matrix[n][k];
                    }
                }
            }
            if (this.numRows == m.numCols) {
                return new IntegerSquareMatrix(array);
            }
            return new IntegerMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    @Override
    public AbstractIntegerMatrix directSum(AbstractIntegerMatrix m) {
        int j;
        int i;
        int[][] array = new int[this.numRows + m.numRows][this.numCols + m.numCols];
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numCols; ++j) {
                array[i][j] = this.matrix[i][j];
            }
        }
        for (i = 0; i < m.numRows; ++i) {
            for (j = 0; j < m.numCols; ++j) {
                array[i + this.numRows][j + this.numCols] = m.getElement(i, j);
            }
        }
        return new IntegerMatrix(array);
    }

    @Override
    public AbstractIntegerMatrix tensor(AbstractIntegerMatrix m) {
        int[][] array = new int[this.numRows * m.numRows][this.numCols * m.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int k = 0;
                while (k < m.numRows) {
                    for (int l = 0; l < m.numCols; ++l) {
                        array[i * m.numRows + k][j * m.numCols + l] = this.matrix[i][j] * m.getElement(k, l);
                    }
                    ++j;
                }
            }
        }
        return new IntegerMatrix(array);
    }

    @Override
    public Matrix transpose() {
        int[][] array = new int[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            array[0][i] = this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                array[j][i] = this.matrix[i][j];
            }
        }
        return new IntegerMatrix(array);
    }
}

