/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.GlobalSettings;
import jsci.maths.DimensionException;
import jsci.maths.Mapping;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.AbstractDoubleSquareMatrix;
import jsci.maths.matrices.AbstractIntegerMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.IntegerSquareMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;

public final class DoubleSparseSquareMatrix
extends AbstractDoubleSquareMatrix {
    private double[] elements;
    private int[] colPos;
    private int[] rows;

    public DoubleSparseSquareMatrix(int size) {
        super(size);
        this.elements = new double[0];
        this.colPos = new int[0];
        this.rows = new int[this.numRows + 1];
    }

    public DoubleSparseSquareMatrix(double[][] array) {
        super(array.length);
        int j;
        int i;
        this.rows = new int[this.numRows + 1];
        int n = 0;
        for (i = 0; i < this.numRows; ++i) {
            if (array[i].length != array.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            for (j = 0; j < this.numCols; ++j) {
                if (!(Math.abs(array[i][j]) > GlobalSettings.ZERO_TOL)) continue;
                ++n;
            }
        }
        this.elements = new double[n];
        this.colPos = new int[n];
        n = 0;
        for (i = 0; i < this.numRows; ++i) {
            this.rows[i] = n;
            for (j = 0; j < this.numCols; ++j) {
                if (!(Math.abs(array[i][j]) > GlobalSettings.ZERO_TOL)) continue;
                this.elements[n] = array[i][j];
                this.colPos[n] = j;
                ++n;
            }
        }
        this.rows[this.numRows] = n;
    }

    public boolean equals(AbstractDoubleSquareMatrix m, double tol) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            if (m instanceof DoubleSparseSquareMatrix) {
                return this.equals((DoubleSparseSquareMatrix)m);
            }
            double sumSqr = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double delta = this.getElement(i, j) - m.getElement(i, j);
                    sumSqr += delta * delta;
                }
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    public final boolean equals(DoubleSparseSquareMatrix m) {
        return this.equals(m, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(DoubleSparseSquareMatrix m, double tol) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            if (this.colPos.length != m.colPos.length) {
                return false;
            }
            for (int i = 1; i < this.rows.length; ++i) {
                if (this.rows[i] == m.rows[i]) continue;
                return false;
            }
            double sumSqr = 0.0;
            for (int i = 1; i < this.colPos.length; ++i) {
                if (this.colPos[i] != m.colPos[i]) {
                    return false;
                }
                double delta = this.elements[i] - m.elements[i];
                sumSqr += delta * delta;
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.getElement(i, j));
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] ans = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                ans[i][j] = Math.round((float)this.getElement(i, j));
            }
        }
        return new IntegerSquareMatrix(ans);
    }

    @Override
    public AbstractComplexMatrix toComplexMatrix() {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                arrayRe[i][j] = this.getElement(i, j);
            }
        }
        return new ComplexSquareMatrix(arrayRe, new double[this.numRows][this.numCols]);
    }

    @Override
    public double getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            for (int k = this.rows[i]; k < this.rows[i + 1]; ++k) {
                if (this.colPos[k] != j) continue;
                return this.elements[k];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(DoubleSparseSquareMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public void setElement(int i, int j, double x) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            int k;
            if (Math.abs(x) <= GlobalSettings.ZERO_TOL) {
                return;
            }
            for (int k2 = this.rows[i]; k2 < this.rows[i + 1]; ++k2) {
                if (this.colPos[k2] != j) continue;
                this.elements[k2] = x;
                return;
            }
            double[] oldMatrix = this.elements;
            int[] oldColPos = this.colPos;
            this.elements = new double[oldMatrix.length + 1];
            this.colPos = new int[oldColPos.length + 1];
            System.arraycopy(oldMatrix, 0, this.elements, 0, this.rows[i]);
            System.arraycopy(oldColPos, 0, this.colPos, 0, this.rows[i]);
            for (k = this.rows[i]; k < this.rows[i + 1] && oldColPos[k] < j; ++k) {
                this.elements[k] = oldMatrix[k];
                this.colPos[k] = oldColPos[k];
            }
            this.elements[k] = x;
            this.colPos[k] = j;
            System.arraycopy(oldMatrix, k, this.elements, k + 1, oldMatrix.length - k);
            System.arraycopy(oldColPos, k, this.colPos, k + 1, oldColPos.length - k);
            k = i + 1;
            while (k < this.rows.length) {
                int n = k++;
                this.rows[n] = this.rows[n] + 1;
            }
        } else {
            throw new MatrixDimensionException(DoubleSparseSquareMatrix.getInvalidElementMsg(i, j));
        }
    }

    @Override
    public double det() {
        AbstractDoubleSquareMatrix[] lu = this.luDecompose(null);
        double det = lu[1].getElement(0, 0);
        for (int i = 1; i < this.numRows; ++i) {
            det *= lu[1].getElement(i, i);
        }
        return det * (double)this.LUpivot[this.numRows];
    }

    @Override
    public double trace() {
        double result = this.getElement(0, 0);
        for (int i = 1; i < this.numRows; ++i) {
            result += this.getElement(i, i);
        }
        return result;
    }

    @Override
    public double infNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double tmpResult = 0.0;
            for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                tmpResult += Math.abs(this.elements[j]);
            }
            if (!(tmpResult > result)) continue;
            result = tmpResult;
        }
        return result;
    }

    @Override
    public double frobeniusNorm() {
        double result = 0.0;
        for (int i = 0; i < this.colPos.length; ++i) {
            result += this.elements[i] * this.elements[i];
        }
        return Math.sqrt(result);
    }

    @Override
    public AbstractDoubleSquareMatrix add(AbstractDoubleSquareMatrix m) {
        if (m instanceof DoubleSparseSquareMatrix) {
            return this.add((DoubleSparseSquareMatrix)m);
        }
        if (m instanceof DoubleSquareMatrix) {
            return this.add((DoubleSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int j;
                for (j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    array[i][this.colPos[j]] = this.elements[j];
                }
                double[] dArray = array[i];
                dArray[0] = dArray[0] + m.getElement(i, 0);
                for (j = 1; j < this.numCols; ++j) {
                    double[] dArray2 = array[i];
                    int n = j;
                    dArray2[n] = dArray2[n] + m.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int j;
                for (j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    array[i][this.colPos[j]] = this.elements[j];
                }
                double[] dArray = array[i];
                dArray[0] = dArray[0] + m.matrix[i][0];
                for (j = 1; j < this.numCols; ++j) {
                    double[] dArray2 = array[i];
                    int n = j;
                    dArray2[n] = dArray2[n] + m.matrix[i][j];
                }
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseSquareMatrix add(DoubleSparseSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            DoubleSparseSquareMatrix ans = new DoubleSparseSquareMatrix(this.numRows);
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    ans.setElement(i, j, this.getElement(i, j) + m.getElement(i, j));
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleSquareMatrix subtract(AbstractDoubleSquareMatrix m) {
        if (m instanceof DoubleSparseSquareMatrix) {
            return this.subtract((DoubleSparseSquareMatrix)m);
        }
        if (m instanceof DoubleSquareMatrix) {
            return this.subtract((DoubleSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int j;
                for (j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    array[i][this.colPos[j]] = this.elements[j];
                }
                double[] dArray = array[i];
                dArray[0] = dArray[0] - m.getElement(i, 0);
                for (j = 1; j < this.numCols; ++j) {
                    double[] dArray2 = array[i];
                    int n = j;
                    dArray2[n] = dArray2[n] - m.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int j;
                for (j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    array[i][this.colPos[j]] = this.elements[j];
                }
                double[] dArray = array[i];
                dArray[0] = dArray[0] - m.matrix[i][0];
                for (j = 1; j < this.numCols; ++j) {
                    double[] dArray2 = array[i];
                    int n = j;
                    dArray2[n] = dArray2[n] - m.matrix[i][j];
                }
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseSquareMatrix subtract(DoubleSparseSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            DoubleSparseSquareMatrix ans = new DoubleSparseSquareMatrix(this.numRows);
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    ans.setElement(i, j, this.getElement(i, j) - m.getElement(i, j));
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleMatrix scalarMultiply(double x) {
        DoubleSparseSquareMatrix ans = new DoubleSparseSquareMatrix(this.numRows);
        ans.elements = new double[this.elements.length];
        ans.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, ans.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, ans.rows, 0, this.rows.length);
        for (int i = 0; i < this.colPos.length; ++i) {
            ans.elements[i] = x * this.elements[i];
        }
        return ans;
    }

    @Override
    public AbstractDoubleMatrix scalarDivide(double x) {
        DoubleSparseSquareMatrix ans = new DoubleSparseSquareMatrix(this.numRows);
        ans.elements = new double[this.elements.length];
        ans.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, ans.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, ans.rows, 0, this.rows.length);
        for (int i = 0; i < this.colPos.length; ++i) {
            ans.elements[i] = this.elements[i] / x;
        }
        return ans;
    }

    @Override
    public double scalarProduct(AbstractDoubleSquareMatrix m) {
        if (m instanceof DoubleSquareMatrix) {
            return this.scalarProduct((DoubleSquareMatrix)m);
        }
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double ans = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    ans += this.elements[j] * m.getElement(i, this.colPos[j]);
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double ans = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    ans += this.elements[j] * m.matrix[i][this.colPos[j]];
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleVector multiply(AbstractDoubleVector v) {
        if (this.numCols == v.dimension()) {
            double[] array = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    int n = i;
                    array[n] = array[n] + this.elements[j] * v.getComponent(this.colPos[j]);
                }
            }
            return new DoubleVector(array);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractDoubleSquareMatrix multiply(AbstractDoubleSquareMatrix m) {
        if (m instanceof DoubleSparseSquareMatrix) {
            return this.multiply((DoubleSparseSquareMatrix)m);
        }
        if (m instanceof DoubleSquareMatrix) {
            return this.multiply((DoubleSquareMatrix)m);
        }
        if (this.numCols == m.numRows) {
            double[][] array = new double[this.numRows][m.numCols];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.numCols; ++k) {
                    for (int n = this.rows[j]; n < this.rows[j + 1]; ++n) {
                        double[] dArray = array[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + this.elements[n] * m.getElement(this.colPos[n], k);
                    }
                }
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix m) {
        if (this.numCols == m.numRows) {
            double[][] array = new double[this.numRows][m.numCols];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.numCols; ++k) {
                    for (int n = this.rows[j]; n < this.rows[j + 1]; ++n) {
                        double[] dArray = array[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + this.elements[n] * m.matrix[this.colPos[n]][k];
                    }
                }
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSparseSquareMatrix multiply(DoubleSparseSquareMatrix m) {
        if (this.numCols == m.numRows) {
            DoubleSparseSquareMatrix ans = new DoubleSparseSquareMatrix(this.numRows);
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < this.numCols; ++k) {
                    double tmp = 0.0;
                    for (int n = this.rows[j]; n < this.rows[j + 1]; ++n) {
                        tmp += this.elements[n] * m.getElement(this.colPos[n], k);
                    }
                    ans.setElement(j, k, tmp);
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    @Override
    public Matrix transpose() {
        DoubleSparseSquareMatrix ans = new DoubleSparseSquareMatrix(this.numRows);
        for (int i = 0; i < this.numRows; ++i) {
            ans.setElement(0, i, this.getElement(i, 0));
            for (int j = 1; j < this.numCols; ++j) {
                ans.setElement(j, i, this.getElement(i, j));
            }
        }
        return ans;
    }

    @Override
    public AbstractDoubleSquareMatrix[] luDecompose(int[] pivot) {
        int j;
        if (this.LU != null) {
            if (pivot != null) {
                System.arraycopy(this.LUpivot, 0, pivot, 0, pivot.length);
            }
            return this.LU;
        }
        double[][] arrayL = new double[this.numRows][this.numCols];
        double[][] arrayU = new double[this.numRows][this.numCols];
        if (pivot == null) {
            pivot = new int[this.numRows + 1];
        }
        for (int i = 0; i < this.numRows; ++i) {
            pivot[i] = i;
        }
        pivot[this.numRows] = 1;
        for (j = 0; j < this.numCols; ++j) {
            int i;
            for (int i2 = 0; i2 < j; ++i2) {
                double tmp = this.getElement(pivot[i2], j);
                for (int k = 0; k < i2; ++k) {
                    tmp -= arrayU[i2][k] * arrayU[k][j];
                }
                arrayU[i2][j] = tmp;
            }
            double max = 0.0;
            int pivotrow = j;
            for (i = j; i < this.numRows; ++i) {
                double tmp = this.getElement(pivot[i], j);
                for (int k = 0; k < j; ++k) {
                    tmp -= arrayU[i][k] * arrayU[k][j];
                }
                arrayU[i][j] = tmp;
                if (!((tmp = Math.abs(tmp)) > max)) continue;
                max = tmp;
                pivotrow = i;
            }
            if (pivotrow != j) {
                double[] tmprow = arrayU[j];
                arrayU[j] = arrayU[pivotrow];
                arrayU[pivotrow] = tmprow;
                int k = pivot[j];
                pivot[j] = pivot[pivotrow];
                pivot[pivotrow] = k;
                pivot[this.numRows] = -pivot[this.numRows];
            }
            for (i = j + 1; i < this.numRows; ++i) {
                double[] dArray = arrayU[i];
                int n = j;
                dArray[n] = dArray[n] / arrayU[j][j];
            }
        }
        for (j = 0; j < this.numCols; ++j) {
            arrayL[j][j] = 1.0;
            for (int i = j + 1; i < this.numRows; ++i) {
                arrayL[i][j] = arrayU[i][j];
                arrayU[i][j] = 0.0;
            }
        }
        this.LU = new AbstractDoubleSquareMatrix[2];
        this.LU[0] = new DoubleSquareMatrix(arrayL);
        this.LU[1] = new DoubleSquareMatrix(arrayU);
        this.LUpivot = new int[pivot.length];
        System.arraycopy(pivot, 0, this.LUpivot, 0, pivot.length);
        return this.LU;
    }

    @Override
    public AbstractDoubleSquareMatrix[] luDecompose() {
        int i;
        int j;
        double[][] arrayL = new double[this.numRows][this.numCols];
        double[][] arrayU = new double[this.numRows][this.numCols];
        for (j = 0; j < this.numCols; ++j) {
            int k;
            double tmp;
            for (i = 0; i < j; ++i) {
                tmp = this.getElement(i, j);
                for (k = 0; k < i; ++k) {
                    tmp -= arrayU[i][k] * arrayU[k][j];
                }
                arrayU[i][j] = tmp;
            }
            for (i = j; i < this.numRows; ++i) {
                tmp = this.getElement(i, j);
                for (k = 0; k < j; ++k) {
                    tmp -= arrayU[i][k] * arrayU[k][j];
                }
                arrayU[i][j] = tmp;
            }
            for (i = j + 1; i < this.numRows; ++i) {
                double[] dArray = arrayU[i];
                int n = j;
                dArray[n] = dArray[n] / arrayU[j][j];
            }
        }
        for (j = 0; j < this.numCols; ++j) {
            arrayL[j][j] = 1.0;
            for (i = j + 1; i < this.numRows; ++i) {
                arrayL[i][j] = arrayU[i][j];
                arrayU[i][j] = 0.0;
            }
        }
        AbstractDoubleSquareMatrix[] lu = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(arrayL), new DoubleSquareMatrix(arrayU)};
        return lu;
    }

    @Override
    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        double[][] arrayL = new double[this.numRows][this.numCols];
        double[][] arrayU = new double[this.numRows][this.numCols];
        double d = Math.sqrt(this.getElement(0, 0));
        arrayU[0][0] = d;
        arrayL[0][0] = d;
        for (int i = 1; i < this.numRows; ++i) {
            double d2 = this.getElement(i, 0) / arrayL[0][0];
            arrayU[0][i] = d2;
            arrayL[i][0] = d2;
        }
        for (int j = 1; j < this.numCols; ++j) {
            int i;
            double tmp = this.getElement(j, j);
            for (i = 0; i < j; ++i) {
                tmp -= arrayL[j][i] * arrayL[j][i];
            }
            double d3 = Math.sqrt(tmp);
            arrayU[j][j] = d3;
            arrayL[j][j] = d3;
            for (i = j + 1; i < this.numRows; ++i) {
                tmp = this.getElement(i, j);
                for (int k = 0; k < i; ++k) {
                    tmp -= arrayL[j][k] * arrayU[k][i];
                }
                double d4 = tmp / arrayU[j][j];
                arrayU[j][i] = d4;
                arrayL[i][j] = d4;
            }
        }
        AbstractDoubleSquareMatrix[] lu = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(arrayL), new DoubleSquareMatrix(arrayU)};
        return lu;
    }

    @Override
    public AbstractDoubleMatrix mapElements(Mapping f) {
        DoubleSparseSquareMatrix ans = new DoubleSparseSquareMatrix(this.numRows);
        ans.elements = new double[this.elements.length];
        ans.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, ans.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, ans.rows, 0, this.rows.length);
        for (int i = 0; i < this.colPos.length; ++i) {
            ans.elements[i] = f.map(this.elements[i]);
        }
        return ans;
    }
}

