/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.maths.DimensionException;
import jsci.maths.ExtraMath;
import jsci.maths.Mapping;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.AbstractIntegerMatrix;
import jsci.maths.matrices.ComplexMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.IntegerMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;

public class DoubleMatrix
extends AbstractDoubleMatrix {
    protected final double[][] matrix;

    public DoubleMatrix(double[][] array) {
        super(array.length, array[0].length);
        this.matrix = array;
    }

    public DoubleMatrix(int rows, int cols) {
        this(new double[rows][cols]);
    }

    public DoubleMatrix(AbstractDoubleVector[] array) {
        this(array[0].dimension(), array.length);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.matrix[i][j] = array[j].getComponent(i);
            }
        }
    }

    @Override
    public boolean equals(AbstractDoubleMatrix m, double tol) {
        if (m != null && this.numRows == m.rows() && this.numCols == m.columns()) {
            double sumSqr = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double delta = this.matrix[i][j] - m.getElement(i, j);
                    sumSqr += delta * delta;
                }
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.matrix[i][j]);
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] ans = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                ans[i][j] = Math.round((float)this.matrix[i][j]);
            }
        }
        return new IntegerMatrix(ans);
    }

    @Override
    public AbstractComplexMatrix toComplexMatrix() {
        ComplexMatrix cm = new ComplexMatrix(this.numRows, this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                cm.setElement(i, j, this.matrix[i][j], 0.0);
            }
        }
        return cm;
    }

    @Override
    public double getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            return this.matrix[i][j];
        }
        throw new MatrixDimensionException(DoubleMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public void setElement(int i, int j, double x) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols) {
            throw new MatrixDimensionException(DoubleMatrix.getInvalidElementMsg(i, j));
        }
        this.matrix[i][j] = x;
    }

    @Override
    public double infNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double tmpResult = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                tmpResult += Math.abs(this.matrix[i][j]);
            }
            if (!(tmpResult > result)) continue;
            result = tmpResult;
        }
        return result;
    }

    @Override
    public double frobeniusNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                result = ExtraMath.hypot(result, this.matrix[i][j]);
            }
        }
        return result;
    }

    @Override
    public AbelianGroup.Member negate() {
        double[][] array = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = -this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = -this.matrix[i][j];
            }
        }
        return new DoubleMatrix(array);
    }

    @Override
    public AbstractDoubleMatrix add(AbstractDoubleMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.matrix[i][0] + m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.matrix[i][j] + m.getElement(i, j);
                }
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleMatrix subtract(AbstractDoubleMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.matrix[i][0] - m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.matrix[i][j] - m.getElement(i, j);
                }
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleMatrix scalarMultiply(double x) {
        double[][] array = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = x * this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = x * this.matrix[i][j];
            }
        }
        return new DoubleMatrix(array);
    }

    @Override
    public AbstractDoubleMatrix scalarDivide(double x) {
        double[][] array = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = this.matrix[i][0] / x;
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = this.matrix[i][j] / x;
            }
        }
        return new DoubleMatrix(array);
    }

    @Override
    public double scalarProduct(AbstractDoubleMatrix m) {
        if (m instanceof DoubleMatrix) {
            return this.scalarProduct((DoubleMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double ans = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                ans += this.matrix[i][0] * m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    ans += this.matrix[i][j] * m.getElement(i, j);
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double ans = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                ans += this.matrix[i][0] * m.matrix[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    ans += this.matrix[i][j] * m.matrix[i][j];
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleVector multiply(AbstractDoubleVector v) {
        if (this.numCols == v.dimension()) {
            double[] array = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                array[i] = this.matrix[i][0] * v.getComponent(0);
                for (int j = 1; j < this.numCols; ++j) {
                    int n = i;
                    array[n] = array[n] + this.matrix[i][j] * v.getComponent(j);
                }
            }
            return new DoubleVector(array);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractDoubleMatrix multiply(AbstractDoubleMatrix m) {
        if (m instanceof DoubleMatrix) {
            return this.multiply((DoubleMatrix)m);
        }
        if (this.numCols == m.rows()) {
            int mColumns = m.columns();
            double[][] array = new double[this.numRows][mColumns];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < mColumns; ++k) {
                    array[j][k] = this.matrix[j][0] * m.getElement(0, k);
                    for (int n = 1; n < this.numCols; ++n) {
                        double[] dArray = array[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + this.matrix[j][n] * m.getElement(n, k);
                    }
                }
            }
            if (this.numRows == mColumns) {
                return new DoubleSquareMatrix(array);
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix multiply(DoubleMatrix m) {
        if (this.numCols == m.numRows) {
            double[][] array = new double[this.numRows][m.numCols];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.numCols; ++k) {
                    array[j][k] = this.matrix[j][0] * m.matrix[0][k];
                    for (int n = 1; n < this.numCols; ++n) {
                        double[] dArray = array[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + this.matrix[j][n] * m.matrix[n][k];
                    }
                }
            }
            if (this.numRows == m.numCols) {
                return new DoubleSquareMatrix(array);
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    @Override
    public AbstractDoubleMatrix directSum(AbstractDoubleMatrix m) {
        int j;
        int i;
        double[][] array = new double[this.numRows + m.numRows][this.numCols + m.numCols];
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numCols; ++j) {
                array[i][j] = this.matrix[i][j];
            }
        }
        for (i = 0; i < m.numRows; ++i) {
            for (j = 0; j < m.numCols; ++j) {
                array[i + this.numRows][j + this.numCols] = m.getElement(i, j);
            }
        }
        return new DoubleMatrix(array);
    }

    @Override
    public AbstractDoubleMatrix tensor(AbstractDoubleMatrix m) {
        double[][] array = new double[this.numRows * m.numRows][this.numCols * m.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int k = 0;
                while (k < m.numRows) {
                    for (int l = 0; l < m.numCols; ++l) {
                        array[i * m.numRows + k][j * m.numCols + l] = this.matrix[i][j] * m.getElement(k, l);
                    }
                    ++j;
                }
            }
        }
        return new DoubleMatrix(array);
    }

    @Override
    public Matrix transpose() {
        double[][] array = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            array[0][i] = this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                array[j][i] = this.matrix[i][j];
            }
        }
        return new DoubleMatrix(array);
    }

    @Override
    public AbstractDoubleMatrix mapElements(Mapping f) {
        double[][] array = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = f.map(this.matrix[i][0]);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = f.map(this.matrix[i][j]);
            }
        }
        return new DoubleMatrix(array);
    }
}

