/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.GlobalSettings;
import jsci.maths.DimensionException;
import jsci.maths.ExtraMath;
import jsci.maths.Mapping;
import jsci.maths.MaximumIterationsExceededException;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.AbstractDoubleSquareMatrix;
import jsci.maths.matrices.AbstractIntegerMatrix;
import jsci.maths.matrices.ComplexDiagonalMatrix;
import jsci.maths.matrices.DiagonalMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.DoubleTridiagonalMatrix;
import jsci.maths.matrices.IntegerDiagonalMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.matrices.TridiagonalMatrix;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;

public class DoubleDiagonalMatrix
extends AbstractDoubleSquareMatrix
implements DiagonalMatrix {
    protected final double[] diag;

    public DoubleDiagonalMatrix(int size) {
        this(new double[size]);
    }

    public DoubleDiagonalMatrix(double[][] array) {
        this(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i].length != array.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            this.diag[i] = array[i][i];
        }
    }

    public DoubleDiagonalMatrix(double[] array) {
        super(array.length);
        this.diag = array;
    }

    public static DoubleDiagonalMatrix identity(int size) {
        double[] array = new double[size];
        for (int i = 0; i < size; ++i) {
            array[i] = 1.0;
        }
        return new DoubleDiagonalMatrix(array);
    }

    @Override
    public boolean equals(AbstractDoubleMatrix m, double tol) {
        if (m instanceof DiagonalMatrix) {
            if (this.numRows != m.rows() || this.numCols != m.columns()) {
                return false;
            }
            double sumSqr = 0.0;
            double delta = this.diag[0] - m.getElement(0, 0);
            sumSqr += delta * delta;
            for (int i = 1; i < this.numRows; ++i) {
                delta = this.diag[i] - m.getElement(i, i);
                sumSqr += delta * delta;
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.getElement(i, j));
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public AbstractIntegerMatrix toIntegerMatrix() {
        int[] array = new int[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            array[i] = Math.round((float)this.diag[i]);
        }
        return new IntegerDiagonalMatrix(array);
    }

    @Override
    public AbstractComplexMatrix toComplexMatrix() {
        double[] array = new double[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            array[i] = this.diag[i];
        }
        return new ComplexDiagonalMatrix(array, new double[this.numRows]);
    }

    @Override
    public double getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            if (i == j) {
                return this.diag[i];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(DoubleDiagonalMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public void setElement(int i, int j, double x) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            if (i != j) {
                throw new MatrixDimensionException(DoubleDiagonalMatrix.getInvalidElementMsg(i, j));
            }
        } else {
            throw new MatrixDimensionException(DoubleDiagonalMatrix.getInvalidElementMsg(i, j));
        }
        this.diag[i] = x;
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public double det() {
        double det = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            det *= this.diag[i];
        }
        return det;
    }

    @Override
    public double trace() {
        double tr = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            tr += this.diag[i];
        }
        return tr;
    }

    @Override
    public double infNorm() {
        double result = Math.abs(this.diag[0]);
        for (int i = 1; i < this.numRows; ++i) {
            double tmpResult = Math.abs(this.diag[i]);
            if (!(tmpResult > result)) continue;
            result = tmpResult;
        }
        return result;
    }

    @Override
    public double frobeniusNorm() {
        double result = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            result = ExtraMath.hypot(result, this.diag[i]);
        }
        return result;
    }

    @Override
    public double operatorNorm() throws MaximumIterationsExceededException {
        return this.infNorm();
    }

    @Override
    public AbstractDoubleSquareMatrix add(AbstractDoubleSquareMatrix m) {
        if (m instanceof DoubleDiagonalMatrix) {
            return this.add((DoubleDiagonalMatrix)m);
        }
        if (m instanceof DiagonalMatrix) {
            return this.addDiagonal(m);
        }
        if (m instanceof DoubleTridiagonalMatrix) {
            return this.add((DoubleTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.addTridiagonal(m);
        }
        if (m instanceof DoubleSquareMatrix) {
            return this.add((DoubleSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int i;
            double[][] array = new double[this.numRows][this.numCols];
            for (i = 0; i < this.numRows; ++i) {
                array[i][0] = m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = m.getElement(i, j);
                }
            }
            for (i = 0; i < this.numRows; ++i) {
                double[] dArray = array[i];
                int n = i;
                dArray[n] = dArray[n] + this.diag[i];
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int i;
            double[][] array = new double[this.numRows][this.numCols];
            for (i = 0; i < this.numRows; ++i) {
                System.arraycopy(m.matrix[i], 0, array[i], 0, this.numRows);
            }
            for (i = 0; i < this.numRows; ++i) {
                double[] dArray = array[i];
                int n = i;
                dArray[n] = dArray[n] + this.diag[i];
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix add(DoubleTridiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            DoubleTridiagonalMatrix ans = new DoubleTridiagonalMatrix(this.numRows);
            System.arraycopy(m.ldiag, 0, ans.ldiag, 0, m.ldiag.length);
            System.arraycopy(m.udiag, 0, ans.udiag, 0, m.udiag.length);
            ans.diag[0] = this.diag[0] + m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                ans.diag[i] = this.diag[i] + m.diag[i];
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix addTridiagonal(AbstractDoubleSquareMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.rows()) {
            DoubleTridiagonalMatrix ans = new DoubleTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] + m.getElement(0, 0);
            ans.udiag[0] = m.getElement(0, 1);
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = m.getElement(i, i - 1);
                ans.diag[i] = this.diag[i] + m.getElement(i, i);
                ans.udiag[i] = m.getElement(i, i + 1);
            }
            ans.ldiag[mRow] = m.getElement(mRow, mRow - 1);
            ans.diag[mRow] = this.diag[mRow] + m.getElement(mRow, mRow);
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix add(DoubleDiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            double[] array = new double[this.numRows];
            array[0] = this.diag[0] + m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] + m.diag[i];
            }
            return new DoubleDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleDiagonalMatrix addDiagonal(AbstractDoubleSquareMatrix m) {
        if (this.numRows == m.numRows) {
            double[] array = new double[this.numRows];
            array[0] = this.diag[0] + m.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] + m.getElement(i, i);
            }
            return new DoubleDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleSquareMatrix subtract(AbstractDoubleSquareMatrix m) {
        if (m instanceof DoubleDiagonalMatrix) {
            return this.subtract((DoubleDiagonalMatrix)m);
        }
        if (m instanceof DiagonalMatrix) {
            return this.subtractDiagonal(m);
        }
        if (m instanceof DoubleTridiagonalMatrix) {
            return this.subtract((DoubleTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(m);
        }
        if (m instanceof DoubleSquareMatrix) {
            return this.subtract((DoubleSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int i;
            double[][] array = new double[this.numRows][this.numCols];
            for (i = 0; i < this.numRows; ++i) {
                array[i][0] = -m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = -m.getElement(i, j);
                }
            }
            for (i = 0; i < this.numRows; ++i) {
                double[] dArray = array[i];
                int n = i;
                dArray[n] = dArray[n] + this.diag[i];
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int i;
            double[][] array = new double[this.numRows][this.numCols];
            for (i = 0; i < this.numRows; ++i) {
                array[i][0] = -m.matrix[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = -m.matrix[i][j];
                }
            }
            for (i = 0; i < this.numRows; ++i) {
                double[] dArray = array[i];
                int n = i;
                dArray[n] = dArray[n] + this.diag[i];
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix subtract(DoubleTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.numRows) {
            DoubleTridiagonalMatrix ans = new DoubleTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] - m.diag[0];
            ans.udiag[0] = -m.udiag[0];
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = -m.ldiag[i];
                ans.diag[i] = this.diag[i] - m.diag[i];
                ans.udiag[i] = -m.udiag[i];
            }
            ans.ldiag[mRow] = -m.ldiag[mRow];
            ans.diag[mRow] = this.diag[mRow] - m.diag[mRow];
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix subtractTridiagonal(AbstractDoubleSquareMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.rows()) {
            DoubleTridiagonalMatrix ans = new DoubleTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] - m.getElement(0, 0);
            ans.udiag[0] = -m.getElement(0, 1);
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = -m.getElement(i, i - 1);
                ans.diag[i] = this.diag[i] - m.getElement(i, i);
                ans.udiag[i] = -m.getElement(i, i + 1);
            }
            ans.ldiag[mRow] = -m.getElement(mRow, mRow - 1);
            ans.diag[mRow] = this.diag[mRow] - m.getElement(mRow, mRow);
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix subtract(DoubleDiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            double[] array = new double[this.numRows];
            array[0] = this.diag[0] - m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] - m.diag[i];
            }
            return new DoubleDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleDiagonalMatrix subtractDiagonal(AbstractDoubleSquareMatrix m) {
        if (this.numRows == m.numRows) {
            double[] array = new double[this.numRows];
            array[0] = this.diag[0] - m.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] - m.getElement(i, i);
            }
            return new DoubleDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleMatrix scalarMultiply(double x) {
        double[] array = new double[this.numRows];
        array[0] = x * this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            array[i] = x * this.diag[i];
        }
        return new DoubleDiagonalMatrix(array);
    }

    @Override
    public AbstractDoubleMatrix scalarDivide(double x) {
        double[] array = new double[this.numRows];
        array[0] = this.diag[0] / x;
        for (int i = 1; i < this.numRows; ++i) {
            array[i] = this.diag[i] / x;
        }
        return new DoubleDiagonalMatrix(array);
    }

    @Override
    public double scalarProduct(AbstractDoubleSquareMatrix m) {
        if (m instanceof DoubleDiagonalMatrix) {
            return this.scalarProduct((DoubleDiagonalMatrix)m);
        }
        if (m instanceof DoubleTridiagonalMatrix) {
            return this.scalarProduct((DoubleTridiagonalMatrix)m);
        }
        if (m instanceof DoubleSquareMatrix) {
            return this.scalarProduct((DoubleSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double ans = this.diag[0] * m.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                ans += this.diag[i] * m.getElement(i, i);
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double ans = this.diag[0] * m.matrix[0][0];
            for (int i = 1; i < this.numRows; ++i) {
                ans += this.diag[i] * m.matrix[i][i];
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleTridiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            double ans = this.diag[0] * m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                ans += this.diag[i] * m.diag[i];
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleDiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            double ans = this.diag[0] * m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                ans += this.diag[i] * m.diag[i];
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleVector multiply(AbstractDoubleVector v) {
        if (this.numCols == v.dimension()) {
            double[] array = new double[this.numRows];
            array[0] = this.diag[0] * v.getComponent(0);
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] * v.getComponent(i);
            }
            return new DoubleVector(array);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractDoubleSquareMatrix multiply(AbstractDoubleSquareMatrix m) {
        if (m instanceof DoubleDiagonalMatrix) {
            return this.multiply((DoubleDiagonalMatrix)m);
        }
        if (m instanceof DiagonalMatrix) {
            return this.multiplyDiagonal(m);
        }
        if (m instanceof DoubleTridiagonalMatrix) {
            return this.multiply((DoubleTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(m);
        }
        if (m instanceof DoubleSquareMatrix) {
            return this.multiply((DoubleSquareMatrix)m);
        }
        if (this.numCols == m.rows()) {
            int mColumns = m.columns();
            double[][] array = new double[this.numRows][mColumns];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.diag[0] * m.getElement(i, 0);
                for (int j = 1; j < mColumns; ++j) {
                    array[i][j] = this.diag[i] * m.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix m) {
        if (this.numCols == m.numRows) {
            double[][] array = new double[this.numRows][m.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.diag[0] * m.matrix[i][0];
                for (int j = 1; j < m.numCols; ++j) {
                    array[i][j] = this.diag[i] * m.matrix[i][j];
                }
            }
            return new DoubleSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleTridiagonalMatrix multiply(DoubleTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (this.numCols == m.numRows) {
            DoubleTridiagonalMatrix ans = new DoubleTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] * m.diag[0];
            ans.udiag[0] = this.diag[0] * m.udiag[0];
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = this.diag[i] * m.ldiag[i];
                ans.diag[i] = this.diag[i] * m.diag[i];
                ans.udiag[i] = this.diag[i] * m.udiag[i];
            }
            ans.ldiag[mRow] = this.diag[mRow] * m.ldiag[mRow];
            ans.diag[mRow] = this.diag[mRow] * m.diag[mRow];
            return ans;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleTridiagonalMatrix multiplyTridiagonal(AbstractDoubleSquareMatrix m) {
        int mRow = this.numRows;
        if (this.numCols == m.rows()) {
            DoubleTridiagonalMatrix ans = new DoubleTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] * m.getElement(0, 0);
            ans.udiag[0] = this.diag[0] * m.getElement(0, 1);
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = this.diag[i] * m.getElement(i, i - 1);
                ans.diag[i] = this.diag[i] * m.getElement(i, i);
                ans.udiag[i] = this.diag[i] * m.getElement(i, i + 1);
            }
            ans.ldiag[mRow] = this.diag[mRow] * m.getElement(mRow, mRow - 1);
            ans.diag[mRow] = this.diag[mRow] * m.getElement(mRow, mRow);
            return ans;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleDiagonalMatrix multiply(DoubleDiagonalMatrix m) {
        if (this.numCols == m.numRows) {
            double[] array = new double[this.numRows];
            array[0] = this.diag[0] * m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] * m.diag[i];
            }
            return new DoubleDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleDiagonalMatrix multiplyDiagonal(AbstractDoubleSquareMatrix m) {
        if (this.numCols == m.rows()) {
            double[] array = new double[this.numRows];
            array[0] = this.diag[0] * m.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] * m.getElement(i, i);
            }
            return new DoubleDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    @Override
    public Matrix transpose() {
        return this;
    }

    @Override
    public AbstractDoubleSquareMatrix inverse() {
        double[] array = new double[this.numRows];
        array[0] = 1.0 / this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            array[i] = 1.0 / this.diag[i];
        }
        return new DoubleDiagonalMatrix(array);
    }

    @Override
    public AbstractDoubleSquareMatrix[] luDecompose(int[] pivot) {
        if (this.LU != null) {
            if (pivot != null) {
                System.arraycopy(this.LUpivot, 0, pivot, 0, pivot.length);
            }
            return this.LU;
        }
        if (pivot == null) {
            pivot = new int[this.numRows + 1];
        }
        for (int i = 0; i < this.numRows; ++i) {
            pivot[i] = i;
        }
        pivot[this.numRows] = 1;
        this.LU = new AbstractDoubleSquareMatrix[2];
        this.LU[0] = DoubleDiagonalMatrix.identity(this.numRows);
        this.LU[1] = this;
        this.LUpivot = new int[pivot.length];
        System.arraycopy(pivot, 0, this.LUpivot, 0, pivot.length);
        return this.LU;
    }

    @Override
    public AbstractDoubleSquareMatrix[] luDecompose() {
        return this.luDecompose(null);
    }

    @Override
    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        AbstractDoubleSquareMatrix[] lu = new AbstractDoubleSquareMatrix[2];
        double[] array = new double[this.numRows];
        array[0] = Math.sqrt(this.diag[0]);
        for (int i = 1; i < this.numRows; ++i) {
            array[i] = Math.sqrt(this.diag[i]);
        }
        lu[0] = new DoubleDiagonalMatrix(array);
        lu[1] = lu[0];
        return lu;
    }

    @Override
    public AbstractDoubleSquareMatrix[] qrDecompose() {
        AbstractDoubleSquareMatrix[] qr = new AbstractDoubleSquareMatrix[]{DoubleDiagonalMatrix.identity(this.numRows), this};
        return qr;
    }

    @Override
    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int N = this.numRows;
        int Nm1 = N - 1;
        double[] arrayU = new double[N];
        double[] arrayS = new double[N];
        double[] arrayV = new double[N];
        for (int i = 0; i < Nm1; ++i) {
            arrayU[i] = -1.0;
            arrayS[i] = Math.abs(this.diag[i]);
            arrayV[i] = this.diag[i] < 0.0 ? 1.0 : -1.0;
        }
        arrayU[Nm1] = 1.0;
        arrayS[Nm1] = Math.abs(this.diag[Nm1]);
        arrayV[Nm1] = this.diag[Nm1] < 0.0 ? -1.0 : 1.0;
        AbstractDoubleSquareMatrix[] svd = new AbstractDoubleSquareMatrix[]{new DoubleDiagonalMatrix(arrayU), new DoubleDiagonalMatrix(arrayS), new DoubleDiagonalMatrix(arrayV)};
        return svd;
    }

    @Override
    public AbstractDoubleMatrix mapElements(Mapping f) {
        double zeroValue = f.map(0.0);
        if (Math.abs(zeroValue) <= GlobalSettings.ZERO_TOL) {
            return this.diagonalMap(f);
        }
        return this.generalMap(f, zeroValue);
    }

    private AbstractDoubleMatrix diagonalMap(Mapping f) {
        double[] array = new double[this.numRows];
        array[0] = f.map(this.diag[0]);
        for (int i = 1; i < this.numRows; ++i) {
            array[i] = f.map(this.diag[i]);
        }
        return new DoubleDiagonalMatrix(array);
    }

    private AbstractDoubleMatrix generalMap(Mapping f, double zeroValue) {
        int i;
        double[][] array = new double[this.numRows][this.numRows];
        for (i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                array[i][j] = zeroValue;
            }
        }
        array[0][0] = f.map(this.diag[0]);
        for (i = 1; i < this.numRows; ++i) {
            array[i][i] = f.map(this.diag[i]);
        }
        return new DoubleSquareMatrix(array);
    }
}

