/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.maths.ArrayMath;
import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.DimensionException;
import jsci.maths.LinearMath;
import jsci.maths.MaximumIterationsExceededException;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.ComplexVector;

public class ComplexSquareMatrix
extends AbstractComplexSquareMatrix {
    protected final double[][] matrixRe;
    protected final double[][] matrixIm;

    public ComplexSquareMatrix(double[][] arrayRe, double[][] arrayIm) {
        super(arrayRe.length);
        if (!ArrayMath.isSquare(arrayRe)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        if (!ArrayMath.isSquare(arrayIm)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.matrixRe = arrayRe;
        this.matrixIm = arrayIm;
    }

    public ComplexSquareMatrix(int size) {
        this(new double[size][size], new double[size][size]);
    }

    public ComplexSquareMatrix(Complex[][] array) {
        this(array.length);
        for (int i = 0; i < this.numRows; ++i) {
            if (array[i].length != array.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            for (int j = 0; j < this.numCols; ++j) {
                this.matrixRe[i][j] = array[i][j].real();
                this.matrixIm[i][j] = array[i][j].imag();
            }
        }
    }

    public ComplexSquareMatrix(AbstractComplexVector[] array) {
        this(array.length);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.matrixRe[i][j] = array[j].getComponent(i).real();
                this.matrixIm[i][j] = array[j].getComponent(i).imag();
            }
        }
    }

    @Override
    public boolean equals(AbstractComplexMatrix m, double tol) {
        if (m != null && this.numRows == m.rows() && this.numCols == m.columns()) {
            double sumSqr = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double deltaRe = this.matrixRe[i][j] - m.getRealElement(i, j);
                    double deltaIm = this.matrixIm[i][j] - m.getImagElement(i, j);
                    sumSqr += deltaRe * deltaRe + deltaIm * deltaIm;
                }
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(Complex.toString(this.matrixRe[i][j], this.matrixIm[i][j]));
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public AbstractDoubleMatrix real() {
        return new DoubleSquareMatrix(this.matrixRe);
    }

    @Override
    public AbstractDoubleMatrix imag() {
        return new DoubleSquareMatrix(this.matrixIm);
    }

    @Override
    public Complex getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            return new Complex(this.matrixRe[i][j], this.matrixIm[i][j]);
        }
        throw new MatrixDimensionException(ComplexSquareMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public double getRealElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            return this.matrixRe[i][j];
        }
        throw new MatrixDimensionException(ComplexSquareMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public double getImagElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            return this.matrixIm[i][j];
        }
        throw new MatrixDimensionException(ComplexSquareMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public void setElement(int i, int j, Complex z) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols) {
            throw new MatrixDimensionException(ComplexSquareMatrix.getInvalidElementMsg(i, j));
        }
        this.matrixRe[i][j] = z.real();
        this.matrixIm[i][j] = z.imag();
    }

    @Override
    public void setElement(int i, int j, double x, double y) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols) {
            throw new MatrixDimensionException(ComplexSquareMatrix.getInvalidElementMsg(i, j));
        }
        this.matrixRe[i][j] = x;
        this.matrixIm[i][j] = y;
    }

    @Override
    public double infNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double tmpResult = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                tmpResult += Math.sqrt(this.matrixRe[i][j] * this.matrixRe[i][j] + this.matrixIm[i][j] * this.matrixIm[i][j]);
            }
            if (!(tmpResult > result)) continue;
            result = tmpResult;
        }
        return result;
    }

    @Override
    public double frobeniusNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                result += this.matrixRe[i][j] * this.matrixRe[i][j] + this.matrixIm[i][j] * this.matrixIm[i][j];
            }
        }
        return Math.sqrt(result);
    }

    @Override
    public Complex det() {
        if (this.numRows == 2) {
            return new Complex(this.matrixRe[0][0] * this.matrixRe[1][1] - this.matrixIm[0][0] * this.matrixIm[1][1] - this.matrixRe[0][1] * this.matrixRe[1][0] + this.matrixIm[0][1] * this.matrixIm[1][0], this.matrixRe[0][0] * this.matrixIm[1][1] + this.matrixIm[0][0] * this.matrixRe[1][1] - this.matrixRe[0][1] * this.matrixIm[1][0] - this.matrixIm[0][1] * this.matrixRe[1][0]);
        }
        ComplexSquareMatrix[] lu = (ComplexSquareMatrix[])this.luDecompose(null);
        double detRe = lu[1].matrixRe[0][0];
        double detIm = lu[1].matrixIm[0][0];
        for (int i = 1; i < this.numRows; ++i) {
            double tmp = detRe * lu[1].matrixRe[i][i] - detIm * lu[1].matrixIm[i][i];
            detIm = detRe * lu[1].matrixIm[i][i] + detIm * lu[1].matrixRe[i][i];
            detRe = tmp;
        }
        return new Complex(detRe * (double)this.LUpivot[this.numRows], detIm * (double)this.LUpivot[this.numRows]);
    }

    @Override
    public Complex trace() {
        double trRe = this.matrixRe[0][0];
        double trIm = this.matrixIm[0][0];
        for (int i = 1; i < this.numRows; ++i) {
            trRe += this.matrixRe[i][i];
            trIm += this.matrixIm[i][i];
        }
        return new Complex(trRe, trIm);
    }

    @Override
    public AbelianGroup.Member negate() {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = -this.matrixRe[i][0];
            arrayIm[i][0] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = -this.matrixRe[i][j];
                arrayIm[i][j] = -this.matrixIm[i][j];
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexSquareMatrix add(AbstractComplexSquareMatrix m) {
        if (m instanceof ComplexSquareMatrix) {
            return this.add((ComplexSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.matrixRe[i][0] + m.getElement(i, 0).real();
                arrayIm[i][0] = this.matrixIm[i][0] + m.getElement(i, 0).imag();
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.matrixRe[i][j] + m.getElement(i, j).real();
                    arrayIm[i][j] = this.matrixIm[i][j] + m.getElement(i, j).imag();
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.matrixRe[i][0] + m.matrixRe[i][0];
                arrayIm[i][0] = this.matrixIm[i][0] + m.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.matrixRe[i][j] + m.matrixRe[i][j];
                    arrayIm[i][j] = this.matrixIm[i][j] + m.matrixIm[i][j];
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractComplexSquareMatrix subtract(AbstractComplexSquareMatrix m) {
        if (m instanceof ComplexSquareMatrix) {
            return this.subtract((ComplexSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.matrixRe[i][0] - m.getElement(i, 0).real();
                arrayIm[i][0] = this.matrixIm[i][0] - m.getElement(i, 0).imag();
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.matrixRe[i][j] - m.getElement(i, j).real();
                    arrayIm[i][j] = this.matrixIm[i][j] - m.getElement(i, j).imag();
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.matrixRe[i][0] - m.matrixRe[i][0];
                arrayIm[i][0] = this.matrixIm[i][0] - m.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.matrixRe[i][j] - m.matrixRe[i][j];
                    arrayIm[i][j] = this.matrixIm[i][j] - m.matrixIm[i][j];
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractComplexMatrix scalarMultiply(Complex z) {
        double real = z.real();
        double imag = z.imag();
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = this.matrixRe[i][0] * real - this.matrixIm[i][0] * imag;
            arrayIm[i][0] = this.matrixRe[i][0] * imag + this.matrixIm[i][0] * real;
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = this.matrixRe[i][j] * real - this.matrixIm[i][j] * imag;
                arrayIm[i][j] = this.matrixRe[i][j] * imag + this.matrixIm[i][j] * real;
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix scalarMultiply(double x) {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = x * this.matrixRe[i][0];
            arrayIm[i][0] = x * this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = x * this.matrixRe[i][j];
                arrayIm[i][j] = x * this.matrixIm[i][j];
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexVector multiply(AbstractComplexVector v) {
        if (this.numCols == v.dimension()) {
            double[] arrayRe = new double[this.numRows];
            double[] arrayIm = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                Complex comp = v.getComponent(0);
                arrayRe[i] = this.matrixRe[i][0] * comp.real() - this.matrixIm[i][0] * comp.imag();
                arrayIm[i] = this.matrixIm[i][0] * comp.real() + this.matrixRe[i][0] * comp.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    comp = v.getComponent(j);
                    int n = i;
                    arrayRe[n] = arrayRe[n] + (this.matrixRe[i][j] * comp.real() - this.matrixIm[i][j] * comp.imag());
                    int n2 = i;
                    arrayIm[n2] = arrayIm[n2] + (this.matrixIm[i][j] * comp.real() + this.matrixRe[i][j] * comp.imag());
                }
            }
            return new ComplexVector(arrayRe, arrayIm);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractComplexSquareMatrix multiply(AbstractComplexSquareMatrix m) {
        if (m instanceof ComplexSquareMatrix) {
            return this.multiply((ComplexSquareMatrix)m);
        }
        if (this.numCols == m.rows()) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < this.numCols; ++k) {
                    Complex elem = m.getElement(0, k);
                    arrayRe[j][k] = this.matrixRe[j][0] * elem.real() - this.matrixIm[j][0] * elem.imag();
                    arrayIm[j][k] = this.matrixIm[j][0] * elem.real() + this.matrixRe[j][0] * elem.imag();
                    for (int n = 1; n < this.numCols; ++n) {
                        elem = m.getElement(n, k);
                        double[] dArray = arrayRe[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + (this.matrixRe[j][n] * elem.real() - this.matrixIm[j][n] * elem.imag());
                        double[] dArray2 = arrayIm[j];
                        int n3 = k;
                        dArray2[n3] = dArray2[n3] + (this.matrixIm[j][n] * elem.real() + this.matrixRe[j][n] * elem.imag());
                    }
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix m) {
        if (this.numCols == m.numRows) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < this.numCols; ++k) {
                    arrayRe[j][k] = this.matrixRe[j][0] * m.matrixRe[0][k] - this.matrixIm[j][0] * m.matrixIm[0][k];
                    arrayIm[j][k] = this.matrixIm[j][0] * m.matrixRe[0][k] + this.matrixRe[j][0] * m.matrixIm[0][k];
                    for (int n = 1; n < this.numCols; ++n) {
                        double[] dArray = arrayRe[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + (this.matrixRe[j][n] * m.matrixRe[n][k] - this.matrixIm[j][n] * m.matrixIm[n][k]);
                        double[] dArray2 = arrayIm[j];
                        int n3 = k;
                        dArray2[n3] = dArray2[n3] + (this.matrixIm[j][n] * m.matrixRe[n][k] + this.matrixRe[j][n] * m.matrixIm[n][k]);
                    }
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    @Override
    public AbstractComplexSquareMatrix directSum(AbstractComplexSquareMatrix m) {
        int j;
        int i;
        double[][] arrayRe = new double[this.numRows + m.numRows][this.numCols + m.numCols];
        double[][] arrayIm = new double[this.numRows + m.numRows][this.numCols + m.numCols];
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numCols; ++j) {
                arrayRe[i][j] = this.matrixRe[i][j];
                arrayIm[i][j] = this.matrixIm[i][j];
            }
        }
        for (i = 0; i < m.numRows; ++i) {
            for (j = 0; j < m.numCols; ++j) {
                Complex elem = m.getElement(i, j);
                arrayRe[i + this.numRows][j + this.numCols] = elem.real();
                arrayIm[i + this.numRows][j + this.numCols] = elem.imag();
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexSquareMatrix tensor(AbstractComplexSquareMatrix m) {
        double[][] arrayRe = new double[this.numRows * m.numRows][this.numCols * m.numCols];
        double[][] arrayIm = new double[this.numRows * m.numRows][this.numCols * m.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int k = 0;
                while (k < m.numRows) {
                    for (int l = 0; l < m.numCols; ++l) {
                        Complex elem = m.getElement(k, l);
                        arrayRe[i * m.numRows + k][j * m.numCols + l] = this.matrixRe[i][j] * elem.real() - this.matrixIm[i][j] * elem.imag();
                        arrayIm[i * m.numRows + k][j * m.numCols + l] = this.matrixIm[i][j] * elem.real() + this.matrixRe[i][j] * elem.imag();
                    }
                    ++j;
                }
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix hermitianAdjoint() {
        double[][] arrayRe = new double[this.numCols][this.numRows];
        double[][] arrayIm = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[0][i] = this.matrixRe[i][0];
            arrayIm[0][i] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[j][i] = this.matrixRe[i][j];
                arrayIm[j][i] = -this.matrixIm[i][j];
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix conjugate() {
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayIm[i][0] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                arrayIm[i][j] = -this.matrixIm[i][j];
            }
        }
        return new ComplexSquareMatrix(this.matrixRe, arrayIm);
    }

    @Override
    public Matrix transpose() {
        double[][] arrayRe = new double[this.numCols][this.numRows];
        double[][] arrayIm = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[0][i] = this.matrixRe[i][0];
            arrayIm[0][i] = this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[j][i] = this.matrixRe[i][j];
                arrayIm[j][i] = this.matrixIm[i][j];
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexSquareMatrix inverse() {
        int i;
        int N = this.numRows;
        double[][] arrayLRe = new double[N][N];
        double[][] arrayLIm = new double[N][N];
        double[][] arrayURe = new double[N][N];
        double[][] arrayUIm = new double[N][N];
        ComplexSquareMatrix[] lu = (ComplexSquareMatrix[])this.luDecompose(null);
        double denom = lu[0].matrixRe[0][0] * lu[0].matrixRe[0][0] + lu[0].matrixIm[0][0] * lu[0].matrixIm[0][0];
        arrayLRe[0][0] = lu[0].matrixRe[0][0] / denom;
        arrayLIm[0][0] = -lu[0].matrixIm[0][0] / denom;
        denom = lu[1].matrixRe[0][0] * lu[1].matrixRe[0][0] + lu[1].matrixIm[0][0] * lu[1].matrixIm[0][0];
        arrayURe[0][0] = lu[1].matrixRe[0][0] / denom;
        arrayUIm[0][0] = -lu[1].matrixIm[0][0] / denom;
        for (i = 1; i < N; ++i) {
            denom = lu[0].matrixRe[i][i] * lu[0].matrixRe[i][i] + lu[0].matrixIm[i][i] * lu[0].matrixIm[i][i];
            arrayLRe[i][i] = lu[0].matrixRe[i][i] / denom;
            arrayLIm[i][i] = -lu[0].matrixIm[i][i] / denom;
            denom = lu[1].matrixRe[i][i] * lu[1].matrixRe[i][i] + lu[1].matrixIm[i][i] * lu[1].matrixIm[i][i];
            arrayURe[i][i] = lu[1].matrixRe[i][i] / denom;
            arrayUIm[i][i] = -lu[1].matrixIm[i][i] / denom;
        }
        for (i = 0; i < N - 1; ++i) {
            for (int j = i + 1; j < N; ++j) {
                double tmpLRe = 0.0;
                double tmpLIm = 0.0;
                double tmpURe = 0.0;
                double tmpUIm = 0.0;
                for (int k = i; k < j; ++k) {
                    tmpLRe -= lu[0].matrixRe[j][k] * arrayLRe[k][i] - lu[0].matrixIm[j][k] * arrayLIm[k][i];
                    tmpLIm -= lu[0].matrixIm[j][k] * arrayLRe[k][i] + lu[0].matrixRe[j][k] * arrayLIm[k][i];
                    tmpURe -= arrayURe[i][k] * lu[1].matrixRe[k][j] - arrayUIm[i][k] * lu[1].matrixIm[k][j];
                    tmpUIm -= arrayUIm[i][k] * lu[1].matrixRe[k][j] + arrayURe[i][k] * lu[1].matrixIm[k][j];
                }
                denom = lu[0].matrixRe[j][j] * lu[0].matrixRe[j][j] + lu[0].matrixIm[j][j] * lu[0].matrixIm[j][j];
                arrayLRe[j][i] = (tmpLRe * lu[0].matrixRe[j][j] + tmpLIm * lu[0].matrixIm[j][j]) / denom;
                arrayLIm[j][i] = (tmpLIm * lu[0].matrixRe[j][j] - tmpLRe * lu[0].matrixIm[j][j]) / denom;
                denom = lu[1].matrixRe[j][j] * lu[1].matrixRe[j][j] + lu[1].matrixIm[j][j] * lu[1].matrixIm[j][j];
                arrayURe[i][j] = (tmpURe * lu[1].matrixRe[j][j] + tmpUIm * lu[1].matrixIm[j][j]) / denom;
                arrayUIm[i][j] = (tmpUIm * lu[1].matrixRe[j][j] - tmpURe * lu[1].matrixIm[j][j]) / denom;
            }
        }
        double[][] invRe = new double[N][N];
        double[][] invIm = new double[N][N];
        for (int i2 = 0; i2 < N; ++i2) {
            int k;
            int j;
            for (j = 0; j < i2; ++j) {
                for (k = i2; k < N; ++k) {
                    double[] dArray = invRe[i2];
                    int n = this.LUpivot[j];
                    dArray[n] = dArray[n] + (arrayURe[i2][k] * arrayLRe[k][j] - arrayUIm[i2][k] * arrayLIm[k][j]);
                    double[] dArray2 = invIm[i2];
                    int n2 = this.LUpivot[j];
                    dArray2[n2] = dArray2[n2] + (arrayUIm[i2][k] * arrayLRe[k][j] + arrayURe[i2][k] * arrayLIm[k][j]);
                }
            }
            for (j = i2; j < N; ++j) {
                for (k = j; k < N; ++k) {
                    double[] dArray = invRe[i2];
                    int n = this.LUpivot[j];
                    dArray[n] = dArray[n] + (arrayURe[i2][k] * arrayLRe[k][j] - arrayUIm[i2][k] * arrayLIm[k][j]);
                    double[] dArray3 = invIm[i2];
                    int n3 = this.LUpivot[j];
                    dArray3[n3] = dArray3[n3] + (arrayUIm[i2][k] * arrayLRe[k][j] + arrayURe[i2][k] * arrayLIm[k][j]);
                }
            }
        }
        return new ComplexSquareMatrix(invRe, invIm);
    }

    @Override
    public final AbstractComplexSquareMatrix[] luDecompose(int[] pivot) {
        int j;
        if (this.LU != null) {
            if (pivot != null) {
                System.arraycopy(this.LUpivot, 0, pivot, 0, pivot.length);
            }
            return this.LU;
        }
        int N = this.numRows;
        double[][] arrayLRe = new double[N][N];
        double[][] arrayLIm = new double[N][N];
        double[][] arrayURe = new double[N][N];
        double[][] arrayUIm = new double[N][N];
        if (pivot == null) {
            pivot = new int[N + 1];
        }
        for (int i = 0; i < N; ++i) {
            pivot[i] = i;
        }
        pivot[N] = 1;
        for (j = 0; j < N; ++j) {
            double tmp;
            int i;
            double denom;
            double a;
            for (int i2 = 0; i2 < j; ++i2) {
                double tmpRe = this.matrixRe[pivot[i2]][j];
                double tmpIm = this.matrixIm[pivot[i2]][j];
                for (int k = 0; k < i2; ++k) {
                    tmpRe -= arrayURe[i2][k] * arrayURe[k][j] - arrayUIm[i2][k] * arrayUIm[k][j];
                    tmpIm -= arrayUIm[i2][k] * arrayURe[k][j] + arrayURe[i2][k] * arrayUIm[k][j];
                }
                arrayURe[i2][j] = tmpRe;
                arrayUIm[i2][j] = tmpIm;
            }
            double max = 0.0;
            int pivotrow = j;
            for (int i3 = j; i3 < N; ++i3) {
                double tmpRe = this.matrixRe[pivot[i3]][j];
                double tmpIm = this.matrixIm[pivot[i3]][j];
                for (int k = 0; k < j; ++k) {
                    tmpRe -= arrayURe[i3][k] * arrayURe[k][j] - arrayUIm[i3][k] * arrayUIm[k][j];
                    tmpIm -= arrayUIm[i3][k] * arrayURe[k][j] + arrayURe[i3][k] * arrayUIm[k][j];
                }
                arrayURe[i3][j] = tmpRe;
                arrayUIm[i3][j] = tmpIm;
                double tmp2 = tmpRe * tmpRe + tmpIm * tmpIm;
                if (!(tmp2 > max)) continue;
                max = tmp2;
                pivotrow = i3;
            }
            if (pivotrow != j) {
                double[] tmprow = arrayURe[j];
                arrayURe[j] = arrayURe[pivotrow];
                arrayURe[pivotrow] = tmprow;
                tmprow = arrayUIm[j];
                arrayUIm[j] = arrayUIm[pivotrow];
                arrayUIm[pivotrow] = tmprow;
                int k = pivot[j];
                pivot[j] = pivot[pivotrow];
                pivot[pivotrow] = k;
                pivot[N] = -pivot[N];
            }
            double tmpRe = arrayURe[j][j];
            double tmpIm = arrayUIm[j][j];
            if (Math.abs(tmpRe) < Math.abs(tmpIm)) {
                a = tmpRe / tmpIm;
                denom = tmpRe * a + tmpIm;
                for (i = j + 1; i < N; ++i) {
                    tmp = (arrayURe[i][j] * a + arrayUIm[i][j]) / denom;
                    arrayUIm[i][j] = (arrayUIm[i][j] * a - arrayURe[i][j]) / denom;
                    arrayURe[i][j] = tmp;
                }
                continue;
            }
            a = tmpIm / tmpRe;
            denom = tmpRe + tmpIm * a;
            for (i = j + 1; i < N; ++i) {
                tmp = (arrayURe[i][j] + arrayUIm[i][j] * a) / denom;
                arrayUIm[i][j] = (arrayUIm[i][j] - arrayURe[i][j] * a) / denom;
                arrayURe[i][j] = tmp;
            }
        }
        for (j = 0; j < N; ++j) {
            arrayLRe[j][j] = 1.0;
            for (int i = j + 1; i < N; ++i) {
                arrayLRe[i][j] = arrayURe[i][j];
                arrayLIm[i][j] = arrayUIm[i][j];
                arrayURe[i][j] = 0.0;
                arrayUIm[i][j] = 0.0;
            }
        }
        this.LU = new ComplexSquareMatrix[2];
        this.LU[0] = new ComplexSquareMatrix(arrayLRe, arrayLIm);
        this.LU[1] = new ComplexSquareMatrix(arrayURe, arrayUIm);
        this.LUpivot = new int[pivot.length];
        System.arraycopy(pivot, 0, this.LUpivot, 0, pivot.length);
        return this.LU;
    }

    @Override
    public AbstractComplexSquareMatrix[] luDecompose() {
        int j;
        int N = this.numRows;
        double[][] arrayLRe = new double[N][N];
        double[][] arrayLIm = new double[N][N];
        double[][] arrayURe = new double[N][N];
        double[][] arrayUIm = new double[N][N];
        for (j = 0; j < N; ++j) {
            double tmp;
            int i;
            double denom;
            double a;
            int k;
            double tmpIm;
            double tmpRe;
            int i2;
            for (i2 = 0; i2 < j; ++i2) {
                tmpRe = this.matrixRe[i2][j];
                tmpIm = this.matrixIm[i2][j];
                for (k = 0; k < i2; ++k) {
                    tmpRe -= arrayURe[i2][k] * arrayURe[k][j] - arrayUIm[i2][k] * arrayUIm[k][j];
                    tmpIm -= arrayUIm[i2][k] * arrayURe[k][j] + arrayURe[i2][k] * arrayUIm[k][j];
                }
                arrayURe[i2][j] = tmpRe;
                arrayUIm[i2][j] = tmpIm;
            }
            for (i2 = j; i2 < N; ++i2) {
                tmpRe = this.matrixRe[i2][j];
                tmpIm = this.matrixIm[i2][j];
                for (k = 0; k < j; ++k) {
                    tmpRe -= arrayURe[i2][k] * arrayURe[k][j] - arrayUIm[i2][k] * arrayUIm[k][j];
                    tmpIm -= arrayUIm[i2][k] * arrayURe[k][j] + arrayURe[i2][k] * arrayUIm[k][j];
                }
                arrayURe[i2][j] = tmpRe;
                arrayUIm[i2][j] = tmpIm;
            }
            double tmpRe2 = arrayURe[j][j];
            double tmpIm2 = arrayUIm[j][j];
            if (Math.abs(tmpRe2) < Math.abs(tmpIm2)) {
                a = tmpRe2 / tmpIm2;
                denom = tmpRe2 * a + tmpIm2;
                for (i = j + 1; i < N; ++i) {
                    tmp = (arrayURe[i][j] * a + arrayUIm[i][j]) / denom;
                    arrayUIm[i][j] = (arrayUIm[i][j] * a - arrayURe[i][j]) / denom;
                    arrayURe[i][j] = tmp;
                }
                continue;
            }
            a = tmpIm2 / tmpRe2;
            denom = tmpRe2 + tmpIm2 * a;
            for (i = j + 1; i < N; ++i) {
                tmp = (arrayURe[i][j] + arrayUIm[i][j] * a) / denom;
                arrayUIm[i][j] = (arrayUIm[i][j] - arrayURe[i][j] * a) / denom;
                arrayURe[i][j] = tmp;
            }
        }
        for (j = 0; j < N; ++j) {
            arrayLRe[j][j] = 1.0;
            for (int i = j + 1; i < N; ++i) {
                arrayLRe[i][j] = arrayURe[i][j];
                arrayLIm[i][j] = arrayUIm[i][j];
                arrayURe[i][j] = 0.0;
                arrayUIm[i][j] = 0.0;
            }
        }
        AbstractComplexSquareMatrix[] lu = new ComplexSquareMatrix[]{new ComplexSquareMatrix(arrayLRe, arrayLIm), new ComplexSquareMatrix(arrayURe, arrayUIm)};
        return lu;
    }

    @Override
    public AbstractComplexSquareMatrix[] polarDecompose() {
        Complex comp;
        double[] eval;
        int N = this.numRows;
        AbstractComplexVector[] evec = new AbstractComplexVector[N];
        try {
            eval = LinearMath.eigenSolveHermitian(this, evec);
        }
        catch (MaximumIterationsExceededException e) {
            return null;
        }
        double[][] tmpaRe = new double[N][N];
        double[][] tmpaIm = new double[N][N];
        double[][] tmpmRe = new double[N][N];
        double[][] tmpmIm = new double[N][N];
        for (int i = 0; i < N; ++i) {
            double abs = Math.abs(eval[i]);
            comp = evec[i].getComponent(0).conjugate();
            tmpaRe[i][0] = eval[i] * comp.real() / abs;
            tmpaIm[i][0] = eval[i] * comp.imag() / abs;
            tmpmRe[i][0] = abs * comp.real();
            tmpmIm[i][0] = abs * comp.imag();
            for (int j = 1; j < N; ++j) {
                comp = evec[i].getComponent(j).conjugate();
                tmpaRe[i][j] = eval[i] * comp.real() / abs;
                tmpaIm[i][j] = eval[i] * comp.imag() / abs;
                tmpmRe[i][j] = abs * comp.real();
                tmpmIm[i][j] = abs * comp.imag();
            }
        }
        double[][] argRe = new double[N][N];
        double[][] argIm = new double[N][N];
        double[][] modRe = new double[N][N];
        double[][] modIm = new double[N][N];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                comp = evec[0].getComponent(i);
                argRe[i][j] = tmpaRe[0][j] * comp.real() - tmpaIm[0][j] * comp.imag();
                argIm[i][j] = tmpaIm[0][j] * comp.real() + tmpaRe[0][j] * comp.imag();
                modRe[i][j] = tmpmRe[0][j] * comp.real() - tmpmIm[0][j] * comp.imag();
                modIm[i][j] = tmpmIm[0][j] * comp.real() + tmpmRe[0][j] * comp.imag();
                for (int k = 1; k < N; ++k) {
                    comp = evec[k].getComponent(i);
                    double[] dArray = argRe[i];
                    int n = j;
                    dArray[n] = dArray[n] + (tmpaRe[k][j] * comp.real() - tmpaIm[k][j] * comp.imag());
                    double[] dArray2 = argIm[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + (tmpaIm[k][j] * comp.real() + tmpaRe[k][j] * comp.imag());
                    double[] dArray3 = modRe[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] + (tmpmRe[k][j] * comp.real() - tmpmIm[k][j] * comp.imag());
                    double[] dArray4 = modIm[i];
                    int n4 = j;
                    dArray4[n4] = dArray4[n4] + (tmpmIm[k][j] * comp.real() + tmpmRe[k][j] * comp.imag());
                }
            }
        }
        AbstractComplexSquareMatrix[] us = new ComplexSquareMatrix[]{new ComplexSquareMatrix(argRe, argIm), new ComplexSquareMatrix(modRe, modIm)};
        return us;
    }

    @Override
    public AbstractComplexMatrix mapElements(ComplexMapping f) {
        Complex[][] array = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = f.map(this.matrixRe[i][0], this.matrixIm[i][0]);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = f.map(this.matrixRe[i][j], this.matrixIm[i][j]);
            }
        }
        return new ComplexSquareMatrix(array);
    }
}

