/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.DimensionException;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.matrices.DoubleMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.ComplexVector;

public class ComplexMatrix
extends AbstractComplexMatrix {
    protected double[][] matrixRe;
    protected double[][] matrixIm;

    public ComplexMatrix(int rows, int cols) {
        super(rows, cols);
        this.matrixRe = new double[rows][cols];
        this.matrixIm = new double[rows][cols];
    }

    public ComplexMatrix(double[][] arrayRe, double[][] arrayIm) {
        this(arrayRe.length, arrayRe[0].length);
        this.matrixRe = arrayRe;
        this.matrixIm = arrayIm;
    }

    public ComplexMatrix(Complex[][] array) {
        this(array.length, array[0].length);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.matrixRe[i][j] = array[i][j].real();
                this.matrixIm[i][j] = array[i][j].imag();
            }
        }
    }

    public ComplexMatrix(ComplexVector[] array) {
        this(array[0].dimension(), array.length);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.matrixRe[i][j] = array[j].getComponent(i).real();
                this.matrixIm[i][j] = array[j].getComponent(i).imag();
            }
        }
    }

    @Override
    public boolean equals(AbstractComplexMatrix m, double tol) {
        if (m != null && this.numRows == m.rows() && this.numCols == m.columns()) {
            double sumSqr = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double deltaRe = this.matrixRe[i][j] - m.getRealElement(i, j);
                    double deltaIm = this.matrixIm[i][j] - m.getImagElement(i, j);
                    sumSqr += deltaRe * deltaRe + deltaIm * deltaIm;
                }
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(Complex.toString(this.matrixRe[i][j], this.matrixIm[i][j]));
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    @Override
    public AbstractDoubleMatrix real() {
        return new DoubleMatrix(this.matrixRe);
    }

    @Override
    public AbstractDoubleMatrix imag() {
        return new DoubleMatrix(this.matrixIm);
    }

    @Override
    public Complex getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            return new Complex(this.matrixRe[i][j], this.matrixIm[i][j]);
        }
        throw new MatrixDimensionException(ComplexMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public double getRealElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            return this.matrixRe[i][j];
        }
        throw new MatrixDimensionException(ComplexMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public double getImagElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            return this.matrixIm[i][j];
        }
        throw new MatrixDimensionException(ComplexMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public void setElement(int i, int j, Complex z) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols) {
            throw new MatrixDimensionException(ComplexMatrix.getInvalidElementMsg(i, j));
        }
        this.matrixRe[i][j] = z.real();
        this.matrixIm[i][j] = z.imag();
    }

    @Override
    public void setElement(int i, int j, double x, double y) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols) {
            throw new MatrixDimensionException(ComplexMatrix.getInvalidElementMsg(i, j));
        }
        this.matrixRe[i][j] = x;
        this.matrixIm[i][j] = y;
    }

    @Override
    public double infNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double tmpResult = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                tmpResult += Math.sqrt(this.matrixRe[i][j] * this.matrixRe[i][j] + this.matrixIm[i][j] * this.matrixIm[i][j]);
            }
            if (!(tmpResult > result)) continue;
            result = tmpResult;
        }
        return result;
    }

    @Override
    public double frobeniusNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                result += this.matrixRe[i][j] * this.matrixRe[i][j] + this.matrixIm[i][j] * this.matrixIm[i][j];
            }
        }
        return Math.sqrt(result);
    }

    @Override
    public AbelianGroup.Member negate() {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = -this.matrixRe[i][0];
            arrayIm[i][0] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = -this.matrixRe[i][j];
                arrayIm[i][j] = -this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix add(AbstractComplexMatrix m) {
        if (m instanceof ComplexMatrix) {
            return this.add((ComplexMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.matrixRe[i][0] + m.getElement(i, 0).real();
                arrayIm[i][0] = this.matrixIm[i][0] + m.getElement(i, 0).imag();
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.matrixRe[i][j] + m.getElement(i, j).real();
                    arrayIm[i][j] = this.matrixIm[i][j] + m.getElement(i, j).imag();
                }
            }
            return new ComplexMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix add(ComplexMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.matrixRe[i][0] + m.matrixRe[i][0];
                arrayIm[i][0] = this.matrixIm[i][0] + m.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.matrixRe[i][j] + m.matrixRe[i][j];
                    arrayIm[i][j] = this.matrixIm[i][j] + m.matrixIm[i][j];
                }
            }
            return new ComplexMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractComplexMatrix subtract(AbstractComplexMatrix m) {
        if (m instanceof ComplexMatrix) {
            return this.subtract((ComplexMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.matrixRe[i][0] - m.getElement(i, 0).real();
                arrayIm[i][0] = this.matrixIm[i][0] - m.getElement(i, 0).imag();
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.matrixRe[i][j] - m.getElement(i, j).real();
                    arrayIm[i][j] = this.matrixIm[i][j] - m.getElement(i, j).imag();
                }
            }
            return new ComplexMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix subtract(ComplexMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.matrixRe[i][0] - m.matrixRe[i][0];
                arrayIm[i][0] = this.matrixIm[i][0] - m.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.matrixRe[i][j] - m.matrixRe[i][j];
                    arrayIm[i][j] = this.matrixIm[i][j] - m.matrixIm[i][j];
                }
            }
            return new ComplexMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractComplexMatrix scalarMultiply(Complex z) {
        double real = z.real();
        double imag = z.imag();
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = real * this.matrixRe[i][0] - imag * this.matrixIm[i][0];
            arrayIm[i][0] = imag * this.matrixRe[i][0] + real * this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = real * this.matrixRe[i][j] - imag * this.matrixIm[i][j];
                arrayIm[i][j] = imag * this.matrixRe[i][j] + real * this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix scalarMultiply(double x) {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = x * this.matrixRe[i][0];
            arrayIm[i][0] = x * this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = x * this.matrixRe[i][j];
                arrayIm[i][j] = x * this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix scalarDivide(Complex z) {
        Complex[][] array = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = new Complex(this.matrixRe[i][0], this.matrixIm[i][0]).divide(z);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = new Complex(this.matrixRe[i][j], this.matrixIm[i][j]).divide(z);
            }
        }
        return new ComplexMatrix(array);
    }

    @Override
    public AbstractComplexMatrix scalarDivide(double x) {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = this.matrixRe[i][0] / x;
            arrayIm[i][0] = this.matrixIm[i][0] / x;
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = this.matrixRe[i][j] / x;
                arrayIm[i][j] = this.matrixIm[i][j] / x;
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexVector multiply(AbstractComplexVector v) {
        if (this.numCols == v.dimension()) {
            double[] arrayRe = new double[this.numRows];
            double[] arrayIm = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                Complex comp = v.getComponent(0);
                arrayRe[i] = this.matrixRe[i][0] * comp.real() - this.matrixIm[i][0] * comp.imag();
                arrayIm[i] = this.matrixIm[i][0] * comp.real() + this.matrixRe[i][0] * comp.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    comp = v.getComponent(j);
                    int n = i;
                    arrayRe[n] = arrayRe[n] + (this.matrixRe[i][j] * comp.real() - this.matrixIm[i][j] * comp.imag());
                    int n2 = i;
                    arrayIm[n2] = arrayIm[n2] + (this.matrixIm[i][j] * comp.real() + this.matrixRe[i][j] * comp.imag());
                }
            }
            return new ComplexVector(arrayRe, arrayIm);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractComplexMatrix multiply(AbstractComplexMatrix m) {
        if (m instanceof ComplexMatrix) {
            return this.multiply((ComplexMatrix)m);
        }
        if (this.numCols == m.rows()) {
            double[][] arrayRe = new double[this.numRows][m.columns()];
            double[][] arrayIm = new double[this.numRows][m.columns()];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.columns(); ++k) {
                    Complex elem = m.getElement(0, k);
                    arrayRe[j][k] = this.matrixRe[j][0] * elem.real() - this.matrixIm[j][0] * elem.imag();
                    arrayIm[j][k] = this.matrixIm[j][0] * elem.real() + this.matrixRe[j][0] * elem.imag();
                    for (int n = 1; n < this.numCols; ++n) {
                        elem = m.getElement(n, k);
                        double[] dArray = arrayRe[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + (this.matrixRe[j][n] * elem.real() - this.matrixIm[j][n] * elem.imag());
                        double[] dArray2 = arrayIm[j];
                        int n3 = k;
                        dArray2[n3] = dArray2[n3] + (this.matrixIm[j][n] * elem.real() + this.matrixRe[j][n] * elem.imag());
                    }
                }
            }
            if (this.numRows == m.columns()) {
                return new ComplexSquareMatrix(arrayRe, arrayIm);
            }
            return new ComplexMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexMatrix multiply(ComplexMatrix m) {
        if (this.numCols == m.numRows) {
            double[][] arrayRe = new double[this.numRows][m.numCols];
            double[][] arrayIm = new double[this.numRows][m.numCols];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.numCols; ++k) {
                    arrayRe[j][k] = this.matrixRe[j][0] * m.matrixRe[0][k] - this.matrixIm[j][0] * m.matrixIm[0][k];
                    arrayIm[j][k] = this.matrixIm[j][0] * m.matrixRe[0][k] + this.matrixRe[j][0] * m.matrixIm[0][k];
                    for (int n = 1; n < this.numCols; ++n) {
                        double[] dArray = arrayRe[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + (this.matrixRe[j][n] * m.matrixRe[n][k] - this.matrixIm[j][n] * m.matrixIm[n][k]);
                        double[] dArray2 = arrayIm[j];
                        int n3 = k;
                        dArray2[n3] = dArray2[n3] + (this.matrixIm[j][n] * m.matrixRe[n][k] + this.matrixRe[j][n] * m.matrixIm[n][k]);
                    }
                }
            }
            if (this.numRows == m.numCols) {
                return new ComplexSquareMatrix(arrayRe, arrayIm);
            }
            return new ComplexMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    @Override
    public AbstractComplexMatrix directSum(AbstractComplexMatrix m) {
        int j;
        int i;
        double[][] arrayRe = new double[this.numRows + m.numRows][this.numCols + m.numCols];
        double[][] arrayIm = new double[this.numRows + m.numRows][this.numCols + m.numCols];
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numCols; ++j) {
                arrayRe[i][j] = this.matrixRe[i][j];
                arrayIm[i][j] = this.matrixIm[i][j];
            }
        }
        for (i = 0; i < m.numRows; ++i) {
            for (j = 0; j < m.numCols; ++j) {
                Complex elem = m.getElement(i, j);
                arrayRe[i + this.numRows][j + this.numCols] = elem.real();
                arrayIm[i + this.numRows][j + this.numCols] = elem.imag();
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix tensor(AbstractComplexMatrix m) {
        double[][] arrayRe = new double[this.numRows * m.numRows][this.numCols * m.numCols];
        double[][] arrayIm = new double[this.numRows * m.numRows][this.numCols * m.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int k = 0;
                while (k < m.numRows) {
                    for (int l = 0; l < m.numCols; ++l) {
                        Complex elem = m.getElement(k, l);
                        arrayRe[i * m.numRows + k][j * m.numCols + l] = this.matrixRe[i][j] * elem.real() - this.matrixIm[i][j] * elem.imag();
                        arrayIm[i * m.numRows + k][j * m.numCols + l] = this.matrixIm[i][j] * elem.real() + this.matrixRe[i][j] * elem.imag();
                    }
                    ++j;
                }
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix hermitianAdjoint() {
        double[][] arrayRe = new double[this.numCols][this.numRows];
        double[][] arrayIm = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[0][i] = this.matrixRe[i][0];
            arrayIm[0][i] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[j][i] = this.matrixRe[i][j];
                arrayIm[j][i] = -this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix conjugate() {
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayIm[i][0] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                arrayIm[i][j] = -this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(this.matrixRe, arrayIm);
    }

    @Override
    public Matrix transpose() {
        double[][] arrayRe = new double[this.numCols][this.numRows];
        double[][] arrayIm = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[0][i] = this.matrixRe[i][0];
            arrayIm[0][i] = this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[j][i] = this.matrixRe[i][j];
                arrayIm[j][i] = this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix mapElements(ComplexMapping f) {
        Complex[][] array = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = f.map(this.matrixRe[i][0], this.matrixIm[i][0]);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = f.map(this.matrixRe[i][j], this.matrixIm[i][j]);
            }
        }
        return new ComplexMatrix(array);
    }
}

