/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.GlobalSettings;
import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.DimensionException;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.matrices.ComplexTridiagonalMatrix;
import jsci.maths.matrices.DiagonalMatrix;
import jsci.maths.matrices.DoubleDiagonalMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.matrices.TridiagonalMatrix;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.ComplexVector;

public class ComplexDiagonalMatrix
extends AbstractComplexSquareMatrix
implements DiagonalMatrix {
    protected final double[] diagRe;
    protected final double[] diagIm;

    public ComplexDiagonalMatrix(double[] arrayRe, double[] arrayIm) {
        super(arrayRe.length);
        this.diagRe = arrayRe;
        this.diagIm = arrayIm;
    }

    public ComplexDiagonalMatrix(int size) {
        this(new double[size], new double[size]);
    }

    public ComplexDiagonalMatrix(Complex[][] array) {
        this(array.length);
        for (int i = 0; i < this.numRows; ++i) {
            if (array[i].length != array.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            this.diagRe[i] = array[i][i].real();
            this.diagIm[i] = array[i][i].imag();
        }
    }

    public ComplexDiagonalMatrix(Complex[] array) {
        this(array.length);
        this.diagRe[0] = array[0].real();
        this.diagIm[0] = array[0].imag();
        for (int i = 1; i < array.length; ++i) {
            this.diagRe[i] = array[i].real();
            this.diagIm[i] = array[i].imag();
        }
    }

    public static ComplexDiagonalMatrix identity(int size) {
        double[] arrayRe = new double[size];
        double[] arrayIm = new double[size];
        for (int i = 0; i < size; ++i) {
            arrayRe[i] = 1.0;
        }
        return new ComplexDiagonalMatrix(arrayRe, arrayIm);
    }

    @Override
    public boolean equals(AbstractComplexMatrix m, double tol) {
        if (m instanceof DiagonalMatrix) {
            if (this.numRows != m.rows() || this.numCols != m.columns()) {
                return false;
            }
            double sumSqr = 0.0;
            double deltaRe = this.diagRe[0] - m.getRealElement(0, 0);
            double deltaIm = this.diagIm[0] - m.getImagElement(0, 0);
            sumSqr += deltaRe * deltaRe + deltaIm * deltaIm;
            for (int i = 1; i < this.numRows; ++i) {
                deltaRe = this.diagRe[i] - m.getRealElement(i, i);
                deltaIm = this.diagIm[i] - m.getImagElement(i, i);
                sumSqr += deltaRe * deltaRe + deltaIm * deltaIm;
            }
            return sumSqr <= tol * tol;
        }
        return super.equals(m);
    }

    @Override
    public AbstractDoubleMatrix real() {
        return new DoubleDiagonalMatrix(this.diagRe);
    }

    @Override
    public AbstractDoubleMatrix imag() {
        return new DoubleDiagonalMatrix(this.diagIm);
    }

    @Override
    public Complex getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            if (i == j) {
                return new Complex(this.diagRe[i], this.diagIm[i]);
            }
            return Complex.ZERO;
        }
        throw new MatrixDimensionException(ComplexDiagonalMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public double getRealElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            if (i == j) {
                return this.diagRe[i];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(ComplexDiagonalMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public double getImagElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            if (i == j) {
                return this.diagIm[i];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(ComplexDiagonalMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public void setElement(int i, int j, Complex z) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols || i != j) {
            throw new MatrixDimensionException(ComplexDiagonalMatrix.getInvalidElementMsg(i, j));
        }
        this.diagRe[i] = z.real();
        this.diagIm[i] = z.imag();
    }

    @Override
    public void setElement(int i, int j, double x, double y) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols || i != j) {
            throw new MatrixDimensionException(ComplexDiagonalMatrix.getInvalidElementMsg(i, j));
        }
        this.diagRe[i] = x;
        this.diagIm[i] = y;
    }

    @Override
    public Complex det() {
        double detRe = this.diagRe[0];
        double detIm = this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            double tmp = detRe * this.diagRe[i] - detIm * this.diagIm[i];
            detIm = detIm * this.diagRe[i] + detRe * this.diagIm[i];
            detRe = tmp;
        }
        return new Complex(detRe, detIm);
    }

    @Override
    public Complex trace() {
        double trRe = this.diagRe[0];
        double trIm = this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            trRe += this.diagRe[i];
            trIm += this.diagIm[i];
        }
        return new Complex(trRe, trIm);
    }

    @Override
    public double infNorm() {
        double result = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            double tmpResult = this.diagRe[i] * this.diagRe[i] + this.diagIm[i] * this.diagIm[i];
            if (!(tmpResult > result)) continue;
            result = tmpResult;
        }
        return Math.sqrt(result);
    }

    @Override
    public double frobeniusNorm() {
        double result = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            result += this.diagRe[i] * this.diagRe[i] + this.diagIm[i] * this.diagIm[i];
        }
        return Math.sqrt(result);
    }

    @Override
    public double operatorNorm() {
        return this.infNorm();
    }

    @Override
    public AbstractComplexSquareMatrix add(AbstractComplexSquareMatrix m) {
        if (m instanceof ComplexDiagonalMatrix) {
            return this.add((ComplexDiagonalMatrix)m);
        }
        if (m instanceof ComplexTridiagonalMatrix) {
            return this.add((ComplexTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.addTridiagonal(m);
        }
        if (m instanceof ComplexSquareMatrix) {
            return this.add((ComplexSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int i;
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (i = 0; i < this.numRows; ++i) {
                Complex elem = m.getElement(i, 0);
                arrayRe[i][0] = elem.real();
                arrayIm[i][0] = elem.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    elem = m.getElement(i, j);
                    arrayRe[i][j] = elem.real();
                    arrayIm[i][j] = elem.imag();
                }
            }
            for (i = 0; i < this.numRows; ++i) {
                double[] dArray = arrayRe[i];
                int n = i;
                dArray[n] = dArray[n] + this.diagRe[i];
                double[] dArray2 = arrayIm[i];
                int n2 = i;
                dArray2[n2] = dArray2[n2] + this.diagIm[i];
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int i;
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (i = 0; i < this.numRows; ++i) {
                System.arraycopy(m.matrixRe[i], 0, arrayRe[i], 0, this.numCols);
                System.arraycopy(m.matrixIm[i], 0, arrayIm[i], 0, this.numCols);
            }
            for (i = 0; i < this.numRows; ++i) {
                double[] dArray = arrayRe[i];
                int n = i;
                dArray[n] = dArray[n] + this.diagRe[i];
                double[] dArray2 = arrayIm[i];
                int n2 = i;
                dArray2[n2] = dArray2[n2] + this.diagIm[i];
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(this.numRows);
            System.arraycopy(m.ldiagRe, 0, ans.ldiagRe, 0, m.ldiagRe.length);
            System.arraycopy(m.ldiagIm, 0, ans.ldiagIm, 0, m.ldiagIm.length);
            System.arraycopy(m.udiagRe, 0, ans.udiagRe, 0, m.udiagRe.length);
            System.arraycopy(m.udiagIm, 0, ans.udiagIm, 0, m.udiagIm.length);
            ans.diagRe[0] = this.diagRe[0] + m.diagRe[0];
            ans.diagIm[0] = this.diagIm[0] + m.diagIm[0];
            for (int i = 1; i < this.numRows; ++i) {
                ans.diagRe[i] = this.diagRe[i] + m.diagRe[i];
                ans.diagIm[i] = this.diagIm[i] + m.diagIm[i];
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix addTridiagonal(AbstractComplexSquareMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.rows()) {
            ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
            Complex elem = m.getElement(0, 0);
            ans.diagRe[0] = this.diagRe[0] + elem.real();
            ans.diagIm[0] = this.diagIm[0] + elem.imag();
            elem = m.getElement(0, 1);
            ans.udiagRe[0] = elem.real();
            ans.udiagIm[0] = elem.imag();
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                elem = m.getElement(i, i - 1);
                ans.ldiagRe[i] = elem.real();
                ans.ldiagIm[i] = elem.imag();
                elem = m.getElement(i, i);
                ans.diagRe[i] = this.diagRe[i] + elem.real();
                ans.diagIm[i] = this.diagIm[i] + elem.imag();
                elem = m.getElement(i, i + 1);
                ans.udiagRe[i] = elem.real();
                ans.udiagIm[i] = elem.imag();
            }
            elem = m.getElement(mRow, mRow - 1);
            ans.ldiagRe[mRow] = elem.real();
            ans.ldiagIm[mRow] = elem.imag();
            elem = m.getElement(mRow, mRow);
            ans.diagRe[mRow] = this.diagRe[mRow] + elem.real();
            ans.diagIm[mRow] = this.diagIm[mRow] + elem.imag();
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix add(ComplexDiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            double[] arrayRe = new double[this.numRows];
            double[] arrayIm = new double[this.numRows];
            arrayRe[0] = this.diagRe[0] + m.diagRe[0];
            arrayIm[0] = this.diagIm[0] + m.diagIm[0];
            for (int i = 1; i < this.numRows; ++i) {
                arrayRe[i] = this.diagRe[i] + m.diagRe[i];
                arrayIm[i] = this.diagIm[i] + m.diagIm[i];
            }
            return new ComplexDiagonalMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractComplexSquareMatrix subtract(AbstractComplexSquareMatrix m) {
        if (m instanceof ComplexDiagonalMatrix) {
            return this.subtract((ComplexDiagonalMatrix)m);
        }
        if (m instanceof ComplexTridiagonalMatrix) {
            return this.subtract((ComplexTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(m);
        }
        if (m instanceof ComplexSquareMatrix) {
            return this.subtract((ComplexSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int i;
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (i = 0; i < this.numRows; ++i) {
                Complex elem = m.getElement(i, 0);
                arrayRe[i][0] = -elem.real();
                arrayIm[i][0] = -elem.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    elem = m.getElement(i, j);
                    arrayRe[i][j] = -elem.real();
                    arrayIm[i][j] = -elem.imag();
                }
            }
            for (i = 0; i < this.numRows; ++i) {
                double[] dArray = arrayRe[i];
                int n = i;
                dArray[n] = dArray[n] + this.diagRe[i];
                double[] dArray2 = arrayIm[i];
                int n2 = i;
                dArray2[n2] = dArray2[n2] + this.diagIm[i];
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = -m.matrixRe[i][0];
                arrayIm[i][0] = -m.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = -m.matrixRe[i][j];
                    arrayIm[i][j] = -m.matrixIm[i][j];
                }
            }
            for (int i = 0; i < this.numRows; ++i) {
                double[] dArray = arrayRe[i];
                int n = i;
                dArray[n] = dArray[n] + this.diagRe[i];
                double[] dArray2 = arrayIm[i];
                int n2 = i;
                dArray2[n2] = dArray2[n2] + this.diagIm[i];
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.numRows) {
            ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
            ans.diagRe[0] = this.diagRe[0] - m.diagRe[0];
            ans.diagIm[0] = this.diagIm[0] - m.diagIm[0];
            ans.udiagRe[0] = -m.udiagRe[0];
            ans.udiagIm[0] = -m.udiagIm[0];
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiagRe[i] = -m.ldiagRe[i];
                ans.ldiagIm[i] = -m.ldiagIm[i];
                ans.diagRe[i] = this.diagRe[i] - m.diagRe[i];
                ans.diagIm[i] = this.diagIm[i] - m.diagIm[i];
                ans.udiagRe[i] = -m.udiagRe[i];
                ans.udiagIm[i] = -m.udiagIm[i];
            }
            ans.ldiagRe[mRow] = -m.ldiagRe[mRow];
            ans.ldiagIm[mRow] = -m.ldiagIm[mRow];
            ans.diagRe[mRow] = this.diagRe[mRow] - m.diagRe[mRow];
            ans.diagIm[mRow] = this.diagIm[mRow] - m.diagIm[mRow];
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix subtractTridiagonal(AbstractComplexSquareMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.rows()) {
            ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
            Complex elem = m.getElement(0, 0);
            ans.diagRe[0] = this.diagRe[0] - elem.real();
            ans.diagIm[0] = this.diagIm[0] - elem.imag();
            elem = m.getElement(0, 1);
            ans.udiagRe[0] = -elem.real();
            ans.udiagIm[0] = -elem.imag();
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                elem = m.getElement(i, i - 1);
                ans.ldiagRe[i] = -elem.real();
                ans.ldiagIm[i] = -elem.imag();
                elem = m.getElement(i, i);
                ans.diagRe[i] = this.diagRe[i] - elem.real();
                ans.diagIm[i] = this.diagIm[i] - elem.imag();
                elem = m.getElement(i, i + 1);
                ans.udiagRe[i] = -elem.real();
                ans.udiagIm[i] = -elem.imag();
            }
            elem = m.getElement(mRow, mRow - 1);
            ans.ldiagRe[mRow] = -elem.real();
            ans.ldiagIm[mRow] = -elem.imag();
            elem = m.getElement(mRow, mRow);
            ans.diagRe[mRow] = this.diagRe[mRow] - elem.real();
            ans.diagIm[mRow] = this.diagIm[mRow] - elem.imag();
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix subtract(ComplexDiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            double[] arrayRe = new double[this.numRows];
            double[] arrayIm = new double[this.numRows];
            arrayRe[0] = this.diagRe[0] - m.diagRe[0];
            arrayIm[0] = this.diagIm[0] - m.diagIm[0];
            for (int i = 1; i < this.numRows; ++i) {
                arrayRe[i] = this.diagRe[i] - m.diagRe[i];
                arrayIm[i] = this.diagIm[i] - m.diagIm[i];
            }
            return new ComplexDiagonalMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractComplexMatrix scalarMultiply(Complex z) {
        double real = z.real();
        double imag = z.imag();
        double[] arrayRe = new double[this.numRows];
        double[] arrayIm = new double[this.numRows];
        arrayRe[0] = real * this.diagRe[0] - imag * this.diagIm[0];
        arrayIm[0] = imag * this.diagRe[0] + real * this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            arrayRe[i] = real * this.diagRe[i] - imag * this.diagIm[i];
            arrayIm[i] = imag * this.diagRe[i] + real * this.diagIm[i];
        }
        return new ComplexDiagonalMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix scalarMultiply(double x) {
        double[] arrayRe = new double[this.numRows];
        double[] arrayIm = new double[this.numRows];
        arrayRe[0] = x * this.diagRe[0];
        arrayIm[0] = x * this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            arrayRe[i] = x * this.diagRe[i];
            arrayIm[i] = x * this.diagIm[i];
        }
        return new ComplexDiagonalMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexVector multiply(AbstractComplexVector v) {
        if (this.numCols == v.dimension()) {
            double[] arrayRe = new double[this.numRows];
            double[] arrayIm = new double[this.numRows];
            Complex comp = v.getComponent(0);
            arrayRe[0] = this.diagRe[0] * comp.real() - this.diagIm[0] * comp.imag();
            arrayIm[0] = this.diagIm[0] * comp.real() + this.diagRe[0] * comp.imag();
            for (int i = 1; i < this.numRows; ++i) {
                comp = v.getComponent(i);
                arrayRe[i] = this.diagRe[i] * comp.real() - this.diagIm[i] * comp.imag();
                arrayIm[i] = this.diagIm[i] * comp.real() + this.diagRe[i] * comp.imag();
            }
            return new ComplexVector(arrayRe, arrayIm);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractComplexSquareMatrix multiply(AbstractComplexSquareMatrix m) {
        if (m instanceof ComplexDiagonalMatrix) {
            return this.multiply((ComplexDiagonalMatrix)m);
        }
        if (m instanceof ComplexTridiagonalMatrix) {
            return this.multiply((ComplexTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(m);
        }
        if (m instanceof ComplexSquareMatrix) {
            return this.multiply((ComplexSquareMatrix)m);
        }
        if (this.numCols == m.rows()) {
            double[][] arrayRe = new double[this.numRows][m.columns()];
            double[][] arrayIm = new double[this.numRows][m.columns()];
            for (int i = 0; i < this.numRows; ++i) {
                Complex elem = m.getElement(i, 0);
                arrayRe[i][0] = this.diagRe[i] * elem.real() - this.diagIm[i] * elem.imag();
                arrayIm[i][0] = this.diagIm[i] * elem.real() + this.diagRe[i] * elem.imag();
                for (int j = 1; j < m.columns(); ++j) {
                    elem = m.getElement(i, j);
                    arrayRe[i][j] = this.diagRe[i] * elem.real() - this.diagIm[i] * elem.imag();
                    arrayIm[i][j] = this.diagIm[i] * elem.real() + this.diagRe[i] * elem.imag();
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix m) {
        if (this.numCols == m.numRows) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.diagRe[i] * m.matrixRe[i][0] - this.diagIm[i] * m.matrixIm[i][0];
                arrayIm[i][0] = this.diagIm[i] * m.matrixRe[i][0] + this.diagRe[i] * m.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.diagRe[i] * m.matrixRe[i][j] - this.diagIm[i] * m.matrixIm[i][j];
                    arrayIm[i][j] = this.diagIm[i] * m.matrixRe[i][j] + this.diagRe[i] * m.matrixIm[i][j];
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix multiply(ComplexTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (this.numCols == m.numRows) {
            ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
            ans.diagRe[0] = this.diagRe[0] * m.diagRe[0] - this.diagIm[0] * m.diagIm[0];
            ans.diagIm[0] = this.diagIm[0] * m.diagRe[0] + this.diagRe[0] * m.diagIm[0];
            ans.udiagRe[0] = this.diagRe[0] * m.udiagRe[0] - this.diagIm[0] * m.udiagIm[0];
            ans.udiagIm[0] = this.diagIm[0] * m.udiagRe[0] + this.diagRe[0] * m.udiagIm[0];
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiagRe[i] = this.diagRe[i] * m.ldiagRe[i] - this.diagIm[i] * m.ldiagIm[i];
                ans.ldiagIm[i] = this.diagIm[i] * m.ldiagRe[i] + this.diagRe[i] * m.ldiagIm[i];
                ans.diagRe[i] = this.diagRe[i] * m.diagRe[i] - this.diagIm[i] * m.diagIm[i];
                ans.diagIm[i] = this.diagIm[i] * m.diagRe[i] + this.diagRe[i] * m.diagIm[i];
                ans.udiagRe[i] = this.diagRe[i] * m.udiagRe[i] - this.diagIm[i] * m.udiagIm[i];
                ans.udiagIm[i] = this.diagIm[i] * m.udiagRe[i] + this.diagRe[i] * m.udiagIm[i];
            }
            ans.ldiagRe[mRow] = this.diagRe[mRow] * m.ldiagRe[mRow] - this.diagIm[mRow] * m.ldiagIm[mRow];
            ans.ldiagIm[mRow] = this.diagIm[mRow] * m.ldiagRe[mRow] + this.diagRe[mRow] * m.ldiagIm[mRow];
            ans.diagRe[mRow] = this.diagRe[mRow] * m.diagRe[mRow] - this.diagIm[mRow] * m.diagIm[mRow];
            ans.diagIm[mRow] = this.diagIm[mRow] * m.diagRe[mRow] + this.diagRe[mRow] * m.diagIm[mRow];
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix multiplyTridiagonal(AbstractComplexSquareMatrix m) {
        int mRow = this.numRows;
        if (this.numCols == m.rows()) {
            ComplexTridiagonalMatrix ans = new ComplexTridiagonalMatrix(mRow);
            Complex elem = m.getElement(0, 0);
            ans.diagRe[0] = this.diagRe[0] * elem.real() - this.diagIm[0] * elem.imag();
            ans.diagIm[0] = this.diagIm[0] * elem.real() + this.diagRe[0] * elem.imag();
            elem = m.getElement(0, 1);
            ans.udiagRe[0] = this.diagRe[0] * elem.real() - this.diagIm[0] * elem.imag();
            ans.udiagIm[0] = this.diagIm[0] * elem.real() + this.diagRe[0] * elem.imag();
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                elem = m.getElement(i, i - 1);
                ans.ldiagRe[i] = this.diagRe[i] * elem.real() - this.diagIm[i] * elem.imag();
                ans.ldiagIm[i] = this.diagIm[i] * elem.real() + this.diagRe[i] * elem.imag();
                elem = m.getElement(i, i);
                ans.diagRe[i] = this.diagRe[i] * elem.real() - this.diagIm[i] * elem.imag();
                ans.diagIm[i] = this.diagIm[i] * elem.real() + this.diagRe[i] * elem.imag();
                elem = m.getElement(i, i + 1);
                ans.udiagRe[i] = this.diagRe[i] * elem.real() - this.diagIm[i] * elem.imag();
                ans.udiagIm[i] = this.diagIm[i] * elem.real() + this.diagRe[i] * elem.imag();
            }
            elem = m.getElement(mRow, mRow - 1);
            ans.ldiagRe[mRow] = this.diagRe[mRow] * elem.real() - this.diagIm[mRow] * elem.imag();
            ans.ldiagIm[mRow] = this.diagIm[mRow] * elem.real() + this.diagRe[mRow] * elem.imag();
            elem = m.getElement(mRow, mRow);
            ans.diagRe[mRow] = this.diagRe[mRow] * elem.real() - this.diagIm[mRow] * elem.imag();
            ans.diagIm[mRow] = this.diagIm[mRow] * elem.real() + this.diagRe[mRow] * elem.imag();
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix multiply(ComplexDiagonalMatrix m) {
        if (this.numCols == m.numRows) {
            double[] arrayRe = new double[this.numRows];
            double[] arrayIm = new double[this.numRows];
            arrayRe[0] = this.diagRe[0] * m.diagRe[0] - this.diagIm[0] * m.diagIm[0];
            arrayIm[0] = this.diagIm[0] * m.diagRe[0] + this.diagRe[0] * m.diagIm[0];
            for (int i = 1; i < this.numRows; ++i) {
                arrayRe[i] = this.diagRe[i] * m.diagRe[i] - this.diagIm[i] * m.diagIm[i];
                arrayIm[i] = this.diagIm[i] * m.diagRe[i] + this.diagRe[i] * m.diagIm[i];
            }
            return new ComplexDiagonalMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractComplexSquareMatrix inverse() {
        double[] arrayRe = new double[this.numRows];
        double[] arrayIm = new double[this.numRows];
        double denom = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        arrayRe[0] = this.diagRe[0] / denom;
        arrayIm[0] = -this.diagIm[0] / denom;
        for (int i = 1; i < this.numRows; ++i) {
            denom = this.diagRe[i] * this.diagRe[i] + this.diagIm[i] * this.diagIm[i];
            arrayRe[i] = this.diagRe[i] / denom;
            arrayIm[i] = -this.diagIm[i] / denom;
        }
        return new ComplexDiagonalMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix hermitianAdjoint() {
        return this.conjugate();
    }

    @Override
    public AbstractComplexMatrix conjugate() {
        double[] arrayIm = new double[this.numRows];
        arrayIm[0] = -this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            arrayIm[i] = -this.diagIm[i];
        }
        return new ComplexDiagonalMatrix(this.diagRe, arrayIm);
    }

    @Override
    public Matrix transpose() {
        return this;
    }

    @Override
    public AbstractComplexSquareMatrix[] luDecompose(int[] pivot) {
        if (this.LU != null) {
            if (pivot != null) {
                System.arraycopy(this.LUpivot, 0, pivot, 0, pivot.length);
            }
            return this.LU;
        }
        if (pivot == null) {
            pivot = new int[this.numRows + 1];
        }
        for (int i = 0; i < this.numRows; ++i) {
            pivot[i] = i;
        }
        pivot[this.numRows] = 1;
        this.LU = new AbstractComplexSquareMatrix[2];
        this.LU[0] = ComplexDiagonalMatrix.identity(this.numRows);
        this.LU[1] = this;
        this.LUpivot = new int[pivot.length];
        System.arraycopy(pivot, 0, this.LUpivot, 0, pivot.length);
        return this.LU;
    }

    @Override
    public AbstractComplexSquareMatrix[] luDecompose() {
        return this.luDecompose(null);
    }

    @Override
    public AbstractComplexMatrix mapElements(ComplexMapping f) {
        Complex zeroValue = f.map(Complex.ZERO);
        if (zeroValue.mod() <= GlobalSettings.ZERO_TOL) {
            return this.diagonalMap(f);
        }
        return this.generalMap(f, zeroValue);
    }

    private AbstractComplexMatrix diagonalMap(ComplexMapping f) {
        Complex[] array = new Complex[this.numRows];
        array[0] = f.map(this.diagRe[0], this.diagIm[0]);
        for (int i = 1; i < this.numRows; ++i) {
            array[i] = f.map(this.diagRe[i], this.diagIm[i]);
        }
        return new ComplexDiagonalMatrix(array);
    }

    private AbstractComplexMatrix generalMap(ComplexMapping f, Complex zeroValue) {
        double[][] arrayRe = new double[this.numRows][this.numRows];
        double[][] arrayIm = new double[this.numRows][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                arrayRe[i][j] = zeroValue.real();
                arrayIm[i][j] = zeroValue.imag();
            }
        }
        Complex z = f.map(this.diagRe[0], this.diagIm[0]);
        arrayRe[0][0] = z.real();
        arrayIm[0][0] = z.imag();
        for (int i = 1; i < this.numRows; ++i) {
            z = f.map(this.diagRe[i], this.diagIm[i]);
            arrayRe[i][i] = z.real();
            arrayIm[i][i] = z.imag();
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }
}

