/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.GlobalSettings;
import jsci.maths.DimensionException;
import jsci.maths.ExtraMath;
import jsci.maths.Mapping;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractIntegerMatrix;
import jsci.maths.matrices.ComplexMatrix;
import jsci.maths.matrices.DoubleMatrix;
import jsci.maths.matrices.DoubleMatrixAlgebra;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.IntegerMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;

public abstract class AbstractDoubleMatrix
extends Matrix {
    protected AbstractDoubleMatrix(int rows, int cols) {
        super(rows, cols);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof AbstractDoubleMatrix) {
            return this.equals((AbstractDoubleMatrix)obj);
        }
        return false;
    }

    public final boolean equals(AbstractDoubleMatrix m) {
        return this.equals(m, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(AbstractDoubleMatrix m, double tol) {
        if (m != null && this.numRows == m.rows() && this.numCols == m.columns()) {
            double sumSqr = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double delta = this.getElement(i, j) - m.getElement(i, j);
                    sumSqr += delta * delta;
                }
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.getElement(i, j));
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] ans = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                ans[i][j] = Math.round((float)this.getElement(i, j));
            }
        }
        return new IntegerMatrix(ans);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        ComplexMatrix cm = new ComplexMatrix(this.numRows, this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                cm.setElement(i, j, this.getElement(i, j), 0.0);
            }
        }
        return cm;
    }

    public abstract double getElement(int var1, int var2);

    public abstract void setElement(int var1, int var2, double var3);

    @Override
    public final Object getSet() {
        return DoubleMatrixAlgebra.get(this.numRows, this.numCols);
    }

    public double infNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double tmpResult = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                tmpResult += Math.abs(this.getElement(i, j));
            }
            if (!(tmpResult > result)) continue;
            result = tmpResult;
        }
        return result;
    }

    public double frobeniusNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                result = ExtraMath.hypot(result, this.getElement(i, j));
            }
        }
        return result;
    }

    @Override
    public AbelianGroup.Member negate() {
        double[][] array = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = -this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = -this.getElement(i, j);
            }
        }
        return new DoubleMatrix(array);
    }

    @Override
    public final AbelianGroup.Member add(AbelianGroup.Member m) {
        if (m instanceof AbstractDoubleMatrix) {
            return this.add((AbstractDoubleMatrix)m);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix add(AbstractDoubleMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.getElement(i, 0) + m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.getElement(i, j) + m.getElement(i, j);
                }
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public final AbelianGroup.Member subtract(AbelianGroup.Member m) {
        if (m instanceof AbstractDoubleMatrix) {
            return this.subtract((AbstractDoubleMatrix)m);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix subtract(AbstractDoubleMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.getElement(i, 0) - m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.getElement(i, j) - m.getElement(i, j);
                }
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public final Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof Number) {
            return this.scalarMultiply(((Number)((Object)x)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix scalarMultiply(double x) {
        double[][] array = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = x * this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = x * this.getElement(i, j);
            }
        }
        return new DoubleMatrix(array);
    }

    @Override
    public final VectorSpace.Member scalarDivide(Field.Member x) {
        if (x instanceof Number) {
            return this.scalarDivide(((Number)((Object)x)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix scalarDivide(double x) {
        double[][] array = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = this.getElement(i, 0) / x;
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = this.getElement(i, j) / x;
            }
        }
        return new DoubleMatrix(array);
    }

    public double scalarProduct(AbstractDoubleMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double ans = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                ans += this.getElement(i, 0) * m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    ans += this.getElement(i, j) * m.getElement(i, j);
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector v) {
        if (this.numCols == v.dimension()) {
            double[] array = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                array[i] = this.getElement(i, 0) * v.getComponent(0);
                for (int j = 1; j < this.numCols; ++j) {
                    int n = i;
                    array[n] = array[n] + this.getElement(i, j) * v.getComponent(j);
                }
            }
            return new DoubleVector(array);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public final Ring.Member multiply(Ring.Member m) {
        if (m instanceof AbstractDoubleMatrix) {
            return this.multiply((AbstractDoubleMatrix)m);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix multiply(AbstractDoubleMatrix m) {
        if (this.numCols == m.rows()) {
            int mColumns = m.columns();
            double[][] array = new double[this.numRows][mColumns];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < mColumns; ++k) {
                    array[j][k] = this.getElement(j, 0) * m.getElement(0, k);
                    for (int n = 1; n < this.numCols; ++n) {
                        double[] dArray = array[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + this.getElement(j, n) * m.getElement(n, k);
                    }
                }
            }
            if (this.numRows == mColumns) {
                return new DoubleSquareMatrix(array);
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix directSum(AbstractDoubleMatrix m) {
        int j;
        int i;
        double[][] array = new double[this.numRows + m.numRows][this.numCols + m.numCols];
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numCols; ++j) {
                array[i][j] = this.getElement(i, j);
            }
        }
        for (i = 0; i < m.numRows; ++i) {
            for (j = 0; j < m.numCols; ++j) {
                array[i + this.numRows][j + this.numCols] = m.getElement(i, j);
            }
        }
        return new DoubleMatrix(array);
    }

    public AbstractDoubleMatrix tensor(AbstractDoubleMatrix m) {
        double[][] array = new double[this.numRows * m.numRows][this.numCols * m.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int k = 0;
                while (k < m.numRows) {
                    for (int l = 0; l < m.numCols; ++l) {
                        array[i * m.numRows + k][j * m.numCols + l] = this.getElement(i, j) * m.getElement(k, l);
                    }
                    ++j;
                }
            }
        }
        return new DoubleMatrix(array);
    }

    @Override
    public Matrix transpose() {
        double[][] array = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            array[0][i] = this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                array[j][i] = this.getElement(i, j);
            }
        }
        return new DoubleMatrix(array);
    }

    public AbstractDoubleMatrix mapElements(Mapping f) {
        double[][] array = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = f.map(this.getElement(i, 0));
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = f.map(this.getElement(i, j));
            }
        }
        return new DoubleMatrix(array);
    }
}

