/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.GlobalSettings;
import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.DimensionException;
import jsci.maths.MathDouble;
import jsci.maths.MathInteger;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.ComplexMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.matrices.DoubleMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.ComplexVector;

public abstract class AbstractComplexMatrix
extends Matrix {
    protected AbstractComplexMatrix(int rows, int cols) {
        super(rows, cols);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof AbstractComplexMatrix) {
            return this.equals((AbstractComplexMatrix)obj);
        }
        return false;
    }

    public final boolean equals(AbstractComplexMatrix m) {
        return this.equals(m, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(AbstractComplexMatrix m, double tol) {
        if (m != null && this.numRows == m.rows() && this.numCols == m.columns()) {
            double sumSqr = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double deltaRe = this.getRealElement(i, j) - m.getRealElement(i, j);
                    double deltaIm = this.getImagElement(i, j) - m.getImagElement(i, j);
                    sumSqr += deltaRe * deltaRe + deltaIm * deltaIm;
                }
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.getElement(i, j));
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public AbstractDoubleMatrix real() {
        double[][] ans = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                ans[i][j] = this.getElement(i, j).real();
            }
        }
        return new DoubleMatrix(ans);
    }

    public AbstractDoubleMatrix imag() {
        double[][] ans = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                ans[i][j] = this.getElement(i, j).imag();
            }
        }
        return new DoubleMatrix(ans);
    }

    public abstract Complex getElement(int var1, int var2);

    public abstract double getRealElement(int var1, int var2);

    public abstract double getImagElement(int var1, int var2);

    public abstract void setElement(int var1, int var2, Complex var3);

    public abstract void setElement(int var1, int var2, double var3, double var5);

    @Override
    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    public double infNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double tmpResult = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                tmpResult += this.getElement(i, j).norm();
            }
            if (!(tmpResult > result)) continue;
            result = tmpResult;
        }
        return result;
    }

    public double frobeniusNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                result += this.getRealElement(i, j) * this.getRealElement(i, j) + this.getImagElement(i, j) * this.getImagElement(i, j);
            }
        }
        return Math.sqrt(result);
    }

    @Override
    public AbelianGroup.Member negate() {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = -this.getRealElement(i, 0);
            arrayIm[i][0] = -this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = -this.getRealElement(i, j);
                arrayIm[i][j] = -this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    @Override
    public final AbelianGroup.Member add(AbelianGroup.Member m) {
        if (m instanceof AbstractComplexMatrix) {
            return this.add((AbstractComplexMatrix)m);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix add(AbstractComplexMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.getRealElement(i, 0) + m.getRealElement(i, 0);
                arrayIm[i][0] = this.getImagElement(i, 0) + m.getImagElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.getRealElement(i, j) + m.getRealElement(i, j);
                    arrayIm[i][j] = this.getImagElement(i, j) + m.getImagElement(i, j);
                }
            }
            return new ComplexMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public final AbelianGroup.Member subtract(AbelianGroup.Member m) {
        if (m instanceof AbstractComplexMatrix) {
            return this.subtract((AbstractComplexMatrix)m);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix subtract(AbstractComplexMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.getRealElement(i, 0) - m.getRealElement(i, 0);
                arrayIm[i][0] = this.getImagElement(i, 0) - m.getImagElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.getRealElement(i, j) - m.getRealElement(i, j);
                    arrayIm[i][j] = this.getImagElement(i, j) - m.getImagElement(i, j);
                }
            }
            return new ComplexMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public final Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof Complex) {
            return this.scalarMultiply((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix scalarMultiply(Complex z) {
        double real = z.real();
        double imag = z.imag();
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = real * this.getRealElement(i, 0) - imag * this.getImagElement(i, 0);
            arrayIm[i][0] = imag * this.getRealElement(i, 0) + real * this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = real * this.getRealElement(i, j) - imag * this.getImagElement(i, j);
                arrayIm[i][j] = imag * this.getRealElement(i, j) + real * this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    public AbstractComplexMatrix scalarMultiply(double x) {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = x * this.getRealElement(i, 0);
            arrayIm[i][0] = x * this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = x * this.getRealElement(i, j);
                arrayIm[i][j] = x * this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    @Override
    public final VectorSpace.Member scalarDivide(Field.Member x) {
        if (x instanceof Complex) {
            return this.scalarDivide((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix scalarDivide(Complex z) {
        Complex[][] array = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = this.getElement(i, 0).divide(z);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = this.getElement(i, j).divide(z);
            }
        }
        return new ComplexMatrix(array);
    }

    public AbstractComplexMatrix scalarDivide(double x) {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = this.getRealElement(i, 0) / x;
            arrayIm[i][0] = this.getImagElement(i, 0) / x;
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = this.getRealElement(i, j) / x;
                arrayIm[i][j] = this.getImagElement(i, j) / x;
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    public Complex scalarProduct(AbstractComplexMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double real = 0.0;
            double imag = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                real += this.getRealElement(i, 0) * m.getRealElement(i, 0) + this.getImagElement(i, 0) * m.getImagElement(i, 0);
                imag += this.getImagElement(i, 0) * m.getRealElement(i, 0) - this.getRealElement(i, 0) * m.getImagElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    real += this.getRealElement(i, j) * m.getRealElement(i, j) + this.getImagElement(i, j) * m.getImagElement(i, j);
                    imag += this.getImagElement(i, j) * m.getRealElement(i, j) - this.getRealElement(i, j) * m.getImagElement(i, j);
                }
            }
            return new Complex(real, imag);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexVector multiply(AbstractComplexVector v) {
        if (this.numCols == v.dimension()) {
            double[] arrayRe = new double[this.numRows];
            double[] arrayIm = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                Complex tmp = this.getElement(i, 0).multiply(v.getComponent(0));
                arrayRe[i] = tmp.real();
                arrayIm[i] = tmp.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    tmp = this.getElement(i, j).multiply(v.getComponent(j));
                    int n = i;
                    arrayRe[n] = arrayRe[n] + tmp.real();
                    int n2 = i;
                    arrayIm[n2] = arrayIm[n2] + tmp.imag();
                }
            }
            return new ComplexVector(arrayRe, arrayIm);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public final Ring.Member multiply(Ring.Member m) {
        if (m instanceof AbstractComplexMatrix) {
            return this.multiply((AbstractComplexMatrix)m);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public AbstractComplexMatrix multiply(AbstractComplexMatrix m) {
        if (this.numCols == m.rows()) {
            double[][] arrayRe = new double[this.numRows][m.columns()];
            double[][] arrayIm = new double[this.numRows][m.columns()];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.columns(); ++k) {
                    Complex tmp = this.getElement(j, 0).multiply(m.getElement(0, k));
                    arrayRe[j][k] = tmp.real();
                    arrayIm[j][k] = tmp.imag();
                    for (int n = 1; n < this.numCols; ++n) {
                        tmp = this.getElement(j, n).multiply(m.getElement(n, k));
                        double[] dArray = arrayRe[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + tmp.real();
                        double[] dArray2 = arrayIm[j];
                        int n3 = k;
                        dArray2[n3] = dArray2[n3] + tmp.imag();
                    }
                }
            }
            if (this.numRows == m.columns()) {
                return new ComplexSquareMatrix(arrayRe, arrayIm);
            }
            return new ComplexMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexMatrix directSum(AbstractComplexMatrix m) {
        int j;
        int i;
        double[][] arrayRe = new double[this.numRows + m.numRows][this.numCols + m.numCols];
        double[][] arrayIm = new double[this.numRows + m.numRows][this.numCols + m.numCols];
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numCols; ++j) {
                arrayRe[i][j] = this.getRealElement(i, j);
                arrayIm[i][j] = this.getImagElement(i, j);
            }
        }
        for (i = 0; i < m.numRows; ++i) {
            for (j = 0; j < m.numCols; ++j) {
                arrayRe[i + this.numRows][j + this.numCols] = m.getRealElement(i, j);
                arrayIm[i + this.numRows][j + this.numCols] = m.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    public AbstractComplexMatrix tensor(AbstractComplexMatrix m) {
        double[][] arrayRe = new double[this.numRows * m.numRows][this.numCols * m.numCols];
        double[][] arrayIm = new double[this.numRows * m.numRows][this.numCols * m.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int k = 0;
                while (k < m.numRows) {
                    for (int l = 0; l < m.numCols; ++l) {
                        Complex tmp = this.getElement(i, j).multiply(m.getElement(k, l));
                        arrayRe[i * m.numRows + k][j * m.numCols + l] = tmp.real();
                        arrayIm[i * m.numRows + k][j * m.numCols + l] = tmp.imag();
                    }
                    ++j;
                }
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    public AbstractComplexMatrix hermitianAdjoint() {
        double[][] arrayRe = new double[this.numCols][this.numRows];
        double[][] arrayIm = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[0][i] = this.getRealElement(i, 0);
            arrayIm[0][i] = -this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[j][i] = this.getRealElement(i, j);
                arrayIm[j][i] = -this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    public AbstractComplexMatrix conjugate() {
        double[][] arrayRe = new double[this.numCols][this.numRows];
        double[][] arrayIm = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = this.getRealElement(i, 0);
            arrayIm[i][0] = -this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = this.getRealElement(i, j);
                arrayIm[i][j] = -this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    @Override
    public Matrix transpose() {
        double[][] arrayRe = new double[this.numCols][this.numRows];
        double[][] arrayIm = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[0][i] = this.getRealElement(i, 0);
            arrayIm[0][i] = this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[j][i] = this.getRealElement(i, j);
                arrayIm[j][i] = this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(arrayRe, arrayIm);
    }

    public AbstractComplexMatrix mapElements(ComplexMapping f) {
        Complex[][] array = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = f.map(this.getElement(i, 0));
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = f.map(this.getElement(i, j));
            }
        }
        return new ComplexMatrix(array);
    }
}

