/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.groups;

import jsci.maths.groups.FiniteGroup;
import jsci.maths.groups.Group;
import jsci.maths.groups.Monoid;
import jsci.maths.groups.Semigroup;

public final class DihedralGroup
extends FiniteGroup {
    private final int n;
    private final Member ONE;

    public DihedralGroup(int n) {
        super(2 * n);
        this.n = n;
        this.ONE = new Member(0, false);
    }

    public boolean equals(Object o) {
        return o instanceof DihedralGroup && ((DihedralGroup)o).order == this.order;
    }

    public int hashCode() {
        return this.order;
    }

    public String toString() {
        return "D_" + this.n;
    }

    @Override
    public Group.Member[] getElements() {
        Group.Member[] elements = new Group.Member[this.order];
        for (int i = 0; i < this.n; ++i) {
            elements[i] = new Member(i, false);
            elements[i + this.n] = new Member(i, true);
        }
        return elements;
    }

    @Override
    public Monoid.Member identity() {
        return this.ONE;
    }

    @Override
    public boolean isIdentity(Monoid.Member a) {
        return a.equals(this.ONE);
    }

    @Override
    public boolean isInverse(Group.Member a, Group.Member b) {
        return a instanceof Member && b instanceof Member && a.compose(b).equals(this.ONE);
    }

    class Member
    implements Group.Member {
        private final int rotate;
        private final boolean reflect;

        public Member(int theta, boolean flip) {
            this.rotate = theta < 0 ? theta % DihedralGroup.this.n + DihedralGroup.this.n : theta % DihedralGroup.this.n;
            this.reflect = flip;
        }

        public boolean equals(Object o) {
            return o instanceof Member && this.rotate == ((Member)o).rotate && this.reflect == ((Member)o).reflect;
        }

        public int hashCode() {
            return 2 * this.rotate + (this.reflect ? 1 : 0);
        }

        @Override
        public Object getSet() {
            return DihedralGroup.this;
        }

        @Override
        public Semigroup.Member compose(Semigroup.Member g) {
            if (this.reflect) {
                return new Member(this.rotate - ((Member)g).rotate, !((Member)g).reflect);
            }
            return new Member(this.rotate + ((Member)g).rotate, ((Member)g).reflect);
        }

        @Override
        public Group.Member inverse() {
            return new Member(-this.rotate, !this.reflect);
        }
    }
}

