/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.groups;

import jsci.maths.groups.AbelianGroup;
import jsci.maths.groups.FiniteGroup;
import jsci.maths.groups.Group;
import jsci.maths.groups.Monoid;
import jsci.maths.groups.Semigroup;

public final class CyclicGroup
extends FiniteGroup
implements AbelianGroup {
    private final Member ZERO = new Member(0);

    public CyclicGroup(int n) {
        super(n);
    }

    public boolean equals(Object o) {
        return o instanceof CyclicGroup && ((CyclicGroup)o).order == this.order;
    }

    public int hashCode() {
        return this.order;
    }

    public String toString() {
        return "Z_" + this.order;
    }

    public Member getElement(int i) {
        return new Member(i);
    }

    @Override
    public Group.Member[] getElements() {
        Group.Member[] elements = new Group.Member[this.order];
        for (int i = 0; i < this.order; ++i) {
            elements[i] = this.getElement(i);
        }
        return elements;
    }

    @Override
    public AbelianGroup.Member zero() {
        return this.ZERO;
    }

    @Override
    public boolean isZero(AbelianGroup.Member g) {
        return g.equals(this.ZERO);
    }

    @Override
    public boolean isNegative(AbelianGroup.Member a, AbelianGroup.Member b) {
        return a instanceof Member && b instanceof Member && a.add(b).equals(this.ZERO);
    }

    @Override
    public Monoid.Member identity() {
        return this.ZERO;
    }

    @Override
    public boolean isIdentity(Monoid.Member g) {
        return g.equals(this.ZERO);
    }

    @Override
    public boolean isInverse(Group.Member a, Group.Member b) {
        return a instanceof Member && b instanceof Member && a.compose(b).equals(this.ZERO);
    }

    class Member
    implements AbelianGroup.Member,
    Group.Member {
        private final int i;

        public Member(int x) {
            this.i = x < 0 ? x % CyclicGroup.this.order + CyclicGroup.this.order : x % CyclicGroup.this.order;
        }

        public boolean equals(Object o) {
            return o instanceof Member && this.i == ((Member)o).i;
        }

        public int hashCode() {
            return this.i;
        }

        @Override
        public Object getSet() {
            return CyclicGroup.this;
        }

        @Override
        public AbelianGroup.Member add(AbelianGroup.Member g) {
            return new Member(this.i + ((Member)g).i);
        }

        @Override
        public AbelianGroup.Member negate() {
            return new Member(-this.i);
        }

        @Override
        public AbelianGroup.Member subtract(AbelianGroup.Member g) {
            return new Member(this.i - ((Member)g).i);
        }

        @Override
        public Semigroup.Member compose(Semigroup.Member g) {
            return new Member(this.i + ((Member)g).i);
        }

        @Override
        public Group.Member inverse() {
            return new Member(-this.i);
        }
    }
}

