/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.chaos;

import jsci.maths.Complex;
import jsci.maths.chaos.MandelbrotMap;

public final class MandelbrotSet {
    private final MandelbrotMap mbrot = new MandelbrotMap(Complex.ZERO);

    public int isMember(Complex z, int maxIter) {
        this.mbrot.setConstant(z);
        Complex w = Complex.ZERO;
        for (int i = 0; i < maxIter; ++i) {
            if (!((w = this.mbrot.map(w)).mod() > 2.0)) continue;
            return i + 1;
        }
        return 0;
    }

    public int isMember(double zRe, double zIm, int maxIter) {
        double re = 0.0;
        double im = 0.0;
        for (int i = 0; i < maxIter; ++i) {
            double tmp = 2.0 * re * im + zIm;
            if (!((re = re * re - im * im + zRe) * re + (im = tmp) * im > 4.0)) continue;
            return i + 1;
        }
        return 0;
    }
}

