/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.categories;

import jsci.maths.categories.Bifunctor;
import jsci.maths.categories.Category;

public class HomFunctor
implements Bifunctor {
    private Category cat;

    public HomFunctor(Category c) {
        this.cat = c;
    }

    @Override
    public Object map(Object a, Object b) {
        return this.cat.hom(a, b);
    }

    @Override
    public Category.Morphism map(Category.Morphism m, Category.Morphism n) {
        return new HomMorphism(m, n);
    }

    private class HomMorphism
    implements Category.Morphism {
        private Category.Morphism in;
        private Category.Morphism out;

        public HomMorphism(Category.Morphism m, Category.Morphism n) {
            this.in = m;
            this.out = n;
        }

        @Override
        public Object domain() {
            return HomFunctor.this.cat.hom(this.in.codomain(), this.out.domain());
        }

        @Override
        public Object codomain() {
            return HomFunctor.this.cat.hom(this.in.domain(), this.out.codomain());
        }

        @Override
        public Object map(Object o) {
            return this.in.compose((Category.Morphism)o).compose(this.out);
        }

        @Override
        public Category.Morphism compose(Category.Morphism m) {
            HomMorphism hm = (HomMorphism)m;
            return new HomMorphism(hm.in.compose(this.in), this.out.compose(hm.out));
        }
    }
}

