/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.analysis;

import jsci.maths.analysis.Cosine;
import jsci.maths.analysis.RealFunction;

public class Tangent
extends RealFunction {
    private final double A;
    private final double w;
    private final double k;

    public Tangent() {
        this(1.0, 1.0, 0.0);
    }

    public Tangent(double A, double w, double k) {
        this.A = A;
        this.w = w;
        this.k = k;
    }

    @Override
    public double map(double x) {
        return this.A * Math.tan(this.w * x + this.k);
    }

    @Override
    public RealFunction differentiate() {
        Cosine cos = new Cosine(1.0, this.w, this.k);
        return RealFunction.constant(this.A * this.w).divide(cos.multiply(cos));
    }
}

