/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.analysis;

import jsci.maths.Mapping;
import jsci.maths.analysis.RealFunction2D;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.polynomials.RealPolynomial;

public abstract class RealFunction
implements Mapping,
Ring.Member {
    private static final RealFunction ZERO = RealFunction.constant(0.0);

    public final int dimension() {
        return 1;
    }

    @Override
    public Object getSet() {
        throw new RuntimeException("Not implemented: please file bug report");
    }

    public RealFunction compose(RealFunction f) {
        return new Composition(this, f);
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Negation(this);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member f) {
        if (f instanceof RealFunction) {
            return this.add((RealFunction)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction add(RealFunction f) {
        return new Sum(this, f);
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member f) {
        if (f instanceof RealFunction) {
            return this.subtract((RealFunction)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction subtract(RealFunction f) {
        return new Difference(this, f);
    }

    @Override
    public Ring.Member multiply(Ring.Member f) {
        if (f instanceof RealFunction) {
            return this.multiply((RealFunction)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction multiply(RealFunction f) {
        return new Product(this, f);
    }

    public Ring.Member inverse() {
        return new Reciprocal(this);
    }

    public Ring.Member divide(Ring.Member f) {
        if (f instanceof RealFunction) {
            return this.divide((RealFunction)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction divide(RealFunction f) {
        return new Quotient(this, f);
    }

    public RealFunction2D tensor(RealFunction f) {
        return new TensorProduct2D(this, f);
    }

    public RealPolynomial taylorExpand(double a, int n) {
        double[] coeff = new double[n];
        coeff[0] = this.map(a);
        RealFunction diff = this;
        int factorial = 1;
        for (int i = 1; i < n; ++i) {
            diff = diff.differentiate();
            coeff[i] = diff.map(a) / (double)(factorial *= i);
        }
        return new RealPolynomial(coeff);
    }

    public abstract RealFunction differentiate();

    public static RealFunction constant(double k) {
        return new Constant(k);
    }

    private static class Constant
    extends RealFunction {
        private final double A;

        public Constant(double A) {
            this.A = A;
        }

        @Override
        public double map(double x) {
            return this.A;
        }

        @Override
        public RealFunction differentiate() {
            return ZERO;
        }
    }

    private static class TensorProduct2D
    extends RealFunction2D {
        private final RealFunction f1;
        private final RealFunction f2;

        public TensorProduct2D(RealFunction f1, RealFunction f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double x, double y) {
            return this.f1.map(x) * this.f2.map(y);
        }
    }

    private static class Quotient
    extends RealFunction {
        private final RealFunction f1;
        private final RealFunction f2;

        public Quotient(RealFunction f1, RealFunction f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double x) {
            return this.f1.map(x) / this.f2.map(x);
        }

        @Override
        public RealFunction differentiate() {
            return new Quotient(new Difference(new Product(this.f1.differentiate(), this.f2), new Product(this.f1, this.f2.differentiate())), new Product(this.f2, this.f2));
        }
    }

    private static class Reciprocal
    extends RealFunction {
        private final RealFunction f;

        public Reciprocal(RealFunction f) {
            this.f = f;
        }

        @Override
        public double map(double x) {
            return 1.0 / this.f.map(x);
        }

        @Override
        public RealFunction differentiate() {
            return new Quotient(new Negation(this.f.differentiate()), new Product(this.f, this.f));
        }
    }

    private static class Product
    extends RealFunction {
        private final RealFunction f1;
        private final RealFunction f2;

        public Product(RealFunction f1, RealFunction f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double x) {
            return this.f1.map(x) * this.f2.map(x);
        }

        @Override
        public RealFunction differentiate() {
            return new Sum(new Product(this.f1.differentiate(), this.f2), new Product(this.f1, this.f2.differentiate()));
        }
    }

    private static class Difference
    extends RealFunction {
        private final RealFunction f1;
        private final RealFunction f2;

        public Difference(RealFunction f1, RealFunction f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double x) {
            return this.f1.map(x) - this.f2.map(x);
        }

        @Override
        public RealFunction differentiate() {
            return new Difference(this.f1.differentiate(), this.f2.differentiate());
        }
    }

    private static class Sum
    extends RealFunction {
        private final RealFunction f1;
        private final RealFunction f2;

        public Sum(RealFunction f1, RealFunction f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double x) {
            return this.f1.map(x) + this.f2.map(x);
        }

        @Override
        public RealFunction differentiate() {
            return new Sum(this.f1.differentiate(), this.f2.differentiate());
        }
    }

    private static class Negation
    extends RealFunction {
        private final RealFunction f;

        public Negation(RealFunction f) {
            this.f = f;
        }

        @Override
        public double map(double x) {
            return -this.f.map(x);
        }

        @Override
        public RealFunction differentiate() {
            return new Negation(this.f.differentiate());
        }
    }

    private static class Composition
    extends RealFunction {
        private final RealFunction f1;
        private final RealFunction f2;

        public Composition(RealFunction f1, RealFunction f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double x) {
            return this.f1.map(this.f2.map(x));
        }

        @Override
        public RealFunction differentiate() {
            return new Product(new Composition(this.f1.differentiate(), this.f2), this.f2.differentiate());
        }
    }
}

