/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.analysis;

import jsci.maths.analysis.Power;
import jsci.maths.analysis.RealFunction;

public class Exponential
extends RealFunction {
    private final double A;
    private final double w;
    private final double n;
    private final double k;

    public Exponential() {
        this(1.0, 1.0, 0.0, 1.0);
    }

    public Exponential(double A, double w, double k) {
        this(A, w, k, 1.0);
    }

    public Exponential(double A, double w, double k, double n) {
        this.A = A;
        this.w = w;
        this.k = k;
        this.n = n;
    }

    @Override
    public double map(double x) {
        x += this.k;
        if (this.n != 1.0) {
            x = this.n == 2.0 ? (x *= x) : Math.pow(x, this.n);
        }
        return this.A * Math.exp(this.w * x);
    }

    @Override
    public RealFunction differentiate() {
        RealFunction diff = new Exponential(this.A * this.w, this.w, this.k, this.n);
        if (this.n != 1.0) {
            diff = new Power(this.n, this.k, this.n - 1.0).multiply(diff);
        }
        return diff;
    }
}

