/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.algebras;

import jsci.maths.Complex;
import jsci.maths.algebras.LieAlgebra;
import jsci.maths.fields.ComplexField;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;

public final class su3Dim3
extends LieAlgebra {
    private static final Complex T8_1 = new Complex(0.5 / Math.sqrt(3.0), 0.0);
    private static final Complex T8_2 = new Complex(-1.0 / Math.sqrt(3.0), 0.0);
    private static final Complex[][] t1 = new Complex[][]{{Complex.ZERO, ComplexField.HALF, Complex.ZERO}, {ComplexField.HALF, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t2 = new Complex[][]{{Complex.ZERO, ComplexField.MINUS_HALF_I, Complex.ZERO}, {ComplexField.HALF_I, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t3 = new Complex[][]{{ComplexField.HALF, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, ComplexField.MINUS_HALF, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t4 = new Complex[][]{{Complex.ZERO, Complex.ZERO, ComplexField.HALF}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}, {ComplexField.HALF, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t5 = new Complex[][]{{Complex.ZERO, Complex.ZERO, ComplexField.MINUS_HALF_I}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}, {ComplexField.HALF_I, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t6 = new Complex[][]{{Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, ComplexField.HALF}, {Complex.ZERO, ComplexField.HALF, Complex.ZERO}};
    private static final Complex[][] t7 = new Complex[][]{{Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, ComplexField.MINUS_HALF_I}, {Complex.ZERO, ComplexField.HALF_I, Complex.ZERO}};
    private static final Complex[][] t8 = new Complex[][]{{T8_1, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, T8_1, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, T8_2}};
    private static final AbstractComplexSquareMatrix[] basisMatrices = new AbstractComplexSquareMatrix[]{new ComplexSquareMatrix(t1), new ComplexSquareMatrix(t2), new ComplexSquareMatrix(t3), new ComplexSquareMatrix(t4), new ComplexSquareMatrix(t5), new ComplexSquareMatrix(t6), new ComplexSquareMatrix(t7), new ComplexSquareMatrix(t8)};
    private static final su3Dim3 _instance = new su3Dim3();

    private su3Dim3() {
        super("su(3) [3]");
    }

    public static final su3Dim3 getInstance() {
        return _instance;
    }

    @Override
    public AbstractComplexSquareMatrix getElement(AbstractDoubleVector v) {
        AbstractComplexMatrix m = basisMatrices[0].scalarMultiply(v.getComponent(0));
        m = m.add(basisMatrices[1].scalarMultiply(v.getComponent(1)));
        m = m.add(basisMatrices[2].scalarMultiply(v.getComponent(2)));
        m = m.add(basisMatrices[3].scalarMultiply(v.getComponent(3)));
        m = m.add(basisMatrices[4].scalarMultiply(v.getComponent(4)));
        m = m.add(basisMatrices[5].scalarMultiply(v.getComponent(5)));
        m = m.add(basisMatrices[6].scalarMultiply(v.getComponent(6)));
        m = m.add(basisMatrices[7].scalarMultiply(v.getComponent(7)));
        return (AbstractComplexSquareMatrix)m.scalarMultiply(Complex.I);
    }

    @Override
    public AbstractDoubleVector multiply(AbstractDoubleVector a, AbstractDoubleVector b) {
        double[] array = new double[]{b.getComponent(1) * a.getComponent(2) - b.getComponent(2) * a.getComponent(1) + 0.5 * (b.getComponent(3) * a.getComponent(6) - b.getComponent(6) * a.getComponent(3) + b.getComponent(5) * a.getComponent(4) - b.getComponent(4) * a.getComponent(5)), b.getComponent(2) * a.getComponent(0) - b.getComponent(0) * a.getComponent(2) + 0.5 * (b.getComponent(3) * a.getComponent(5) - b.getComponent(5) * a.getComponent(3) + b.getComponent(4) * a.getComponent(6) - b.getComponent(6) * a.getComponent(4)), b.getComponent(0) * a.getComponent(1) - b.getComponent(1) * a.getComponent(0) + 0.5 * (b.getComponent(3) * a.getComponent(4) - b.getComponent(4) * a.getComponent(3) + b.getComponent(6) * a.getComponent(5) - b.getComponent(5) * a.getComponent(6)), Math.sqrt(0.75) * (b.getComponent(4) * a.getComponent(7) - b.getComponent(7) * a.getComponent(4)) + 0.5 * (b.getComponent(6) * a.getComponent(0) - b.getComponent(0) * a.getComponent(6) + b.getComponent(5) * a.getComponent(1) - b.getComponent(1) * a.getComponent(5) + b.getComponent(4) * a.getComponent(2) - b.getComponent(2) * a.getComponent(4)), Math.sqrt(0.75) * (b.getComponent(7) * a.getComponent(3) - b.getComponent(3) * a.getComponent(7)) + 0.5 * (b.getComponent(0) * a.getComponent(5) - b.getComponent(5) * a.getComponent(0) + b.getComponent(6) * a.getComponent(1) - b.getComponent(1) * a.getComponent(6) + b.getComponent(2) * a.getComponent(3) - b.getComponent(3) * a.getComponent(2)), Math.sqrt(0.75) * (b.getComponent(6) * a.getComponent(7) - b.getComponent(7) * a.getComponent(6)) + 0.5 * (b.getComponent(4) * a.getComponent(0) - b.getComponent(0) * a.getComponent(4) + b.getComponent(1) * a.getComponent(3) - b.getComponent(3) * a.getComponent(1) + b.getComponent(2) * a.getComponent(6) - b.getComponent(6) * a.getComponent(2)), Math.sqrt(0.75) * (b.getComponent(7) * a.getComponent(5) - b.getComponent(5) * a.getComponent(7)) + 0.5 * (b.getComponent(0) * a.getComponent(3) - b.getComponent(3) * a.getComponent(0) + b.getComponent(1) * a.getComponent(4) - b.getComponent(4) * a.getComponent(1) + b.getComponent(5) * a.getComponent(2) - b.getComponent(2) * a.getComponent(5)), Math.sqrt(0.75) * (b.getComponent(3) * a.getComponent(4) - b.getComponent(4) * a.getComponent(3) + b.getComponent(5) * a.getComponent(6) - b.getComponent(6) * a.getComponent(5))};
        return new DoubleVector(array);
    }

    @Override
    public AbstractComplexSquareMatrix[] basis() {
        return basisMatrices;
    }
}

