/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.algebras;

import jsci.maths.Complex;
import jsci.maths.algebras.LieAlgebra;
import jsci.maths.fields.ComplexField;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.maths.matrices.AbstractDoubleSquareMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.Double3Vector;
import jsci.maths.vectors.VectorDimensionException;

public final class su2Dim3
extends LieAlgebra {
    private static final Complex[][] t1 = new Complex[][]{{Complex.ZERO, ComplexField.SQRT_HALF, Complex.ZERO}, {ComplexField.SQRT_HALF, Complex.ZERO, ComplexField.SQRT_HALF}, {Complex.ZERO, ComplexField.SQRT_HALF, Complex.ZERO}};
    private static final Complex[][] t2 = new Complex[][]{{Complex.ZERO, ComplexField.MINUS_SQRT_HALF_I, Complex.ZERO}, {ComplexField.SQRT_HALF_I, Complex.ZERO, ComplexField.MINUS_SQRT_HALF_I}, {Complex.ZERO, ComplexField.SQRT_HALF_I, Complex.ZERO}};
    private static final Complex[][] t3 = new Complex[][]{{Complex.ONE, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, ComplexField.MINUS_ONE}};
    private static final AbstractComplexSquareMatrix[] basisMatrices = new AbstractComplexSquareMatrix[]{new ComplexSquareMatrix(t1), new ComplexSquareMatrix(t2), new ComplexSquareMatrix(t3)};
    private static final double[][] g = new double[][]{{-2.0, 0.0, 0.0}, {0.0, -2.0, 0.0}, {0.0, 0.0, -2.0}};
    private static final AbstractDoubleSquareMatrix metricMatrix = new DoubleSquareMatrix(g);
    private static final su2Dim3 _instance = new su2Dim3();

    private su2Dim3() {
        super("su(2) [3]");
    }

    public static final su2Dim3 getInstance() {
        return _instance;
    }

    @Override
    public AbstractComplexSquareMatrix getElement(AbstractDoubleVector v) {
        AbstractComplexMatrix m = basisMatrices[0].scalarMultiply(v.getComponent(0));
        m = m.add(basisMatrices[1].scalarMultiply(v.getComponent(1)));
        m = m.add(basisMatrices[2].scalarMultiply(v.getComponent(2)));
        return (AbstractComplexSquareMatrix)m.scalarMultiply(Complex.I);
    }

    @Override
    public AbstractDoubleVector multiply(AbstractDoubleVector a, AbstractDoubleVector b) {
        if (!(a instanceof Double3Vector) || !(b instanceof Double3Vector)) {
            throw new VectorDimensionException("Vectors must be 3-vectors.");
        }
        return ((Double3Vector)b).multiply((Double3Vector)a);
    }

    public double killingForm(AbstractDoubleVector a, AbstractDoubleVector b) {
        return a.scalarProduct(metricMatrix.multiply(b));
    }

    @Override
    public AbstractComplexSquareMatrix[] basis() {
        return basisMatrices;
    }

    public AbstractDoubleSquareMatrix cartanMetric() {
        return metricMatrix;
    }
}

