/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.maths.AbstractMath;
import jsci.maths.MaximumIterationsExceededException;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.AbstractDoubleSquareMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.DoubleTridiagonalMatrix;
import jsci.maths.polynomials.RealPolynomial;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.ComplexVector;
import jsci.maths.vectors.DoubleVector;

public final class LinearMath
extends AbstractMath {
    private static final int EIGEN_MAX_ITERATIONS = 250;

    private LinearMath() {
    }

    public static AbstractDoubleVector solve(AbstractDoubleSquareMatrix M, AbstractDoubleVector v) {
        int j;
        double sum;
        int i;
        int n = v.dimension();
        double[] array = new double[n];
        int[] pivot = new int[n + 1];
        AbstractDoubleSquareMatrix[] lu = M.luDecompose(pivot);
        for (i = 0; i < n; ++i) {
            sum = v.getComponent(pivot[i]);
            for (j = 0; j < i; ++j) {
                sum -= lu[0].getElement(i, j) * array[j];
            }
            array[i] = sum / lu[0].getElement(i, i);
        }
        for (i = n - 1; i >= 0; --i) {
            sum = array[i];
            for (j = i + 1; j < n; ++j) {
                sum -= lu[1].getElement(i, j) * array[j];
            }
            array[i] = sum / lu[1].getElement(i, i);
        }
        return new DoubleVector(array);
    }

    private static double[] solveCholesky(double[][] m, double[] v) {
        int j;
        double sum;
        int i;
        int n = v.length;
        double[] array = new double[n];
        AbstractDoubleSquareMatrix[] lu = new DoubleSquareMatrix(m).choleskyDecompose();
        for (i = 0; i < n; ++i) {
            sum = v[i];
            for (j = 0; j < i; ++j) {
                sum -= lu[0].getElement(i, j) * array[j];
            }
            array[i] = sum / lu[0].getElement(i, i);
        }
        for (i = n - 1; i >= 0; --i) {
            sum = array[i];
            for (j = i + 1; j < n; ++j) {
                sum -= lu[1].getElement(i, j) * array[j];
            }
            array[i] = sum / lu[1].getElement(i, i);
        }
        return array;
    }

    private static double[] solveQR(double[][] m, double[] v) {
        int j;
        double sum;
        int i;
        int n = v.length;
        double[] array = new double[n];
        AbstractDoubleSquareMatrix[] lu = new DoubleSquareMatrix(m).qrDecompose();
        for (i = 0; i < n; ++i) {
            sum = 0.0;
            for (j = 0; j < n; ++j) {
                sum += lu[0].getElement(j, i) * v[j];
            }
            array[i] = sum;
        }
        for (i = n - 1; i >= 0; --i) {
            sum = array[i];
            for (j = i + 1; j < n; ++j) {
                sum -= lu[1].getElement(i, j) * array[j];
            }
            array[i] = sum / lu[1].getElement(i, i);
        }
        return array;
    }

    public static AbstractDoubleVector solveGMRes(AbstractDoubleMatrix A, AbstractDoubleVector b, int max_iter, double tol) throws MaximumIterationsExceededException {
        double d;
        if (max_iter <= 0) {
            throw new IllegalArgumentException("Number of allowed iterations must be a positive integer: " + max_iter + " <= 0.");
        }
        if (tol < 0.0) {
            throw new IllegalArgumentException("Tolerance must be positive or zero: " + tol + " < 0.");
        }
        int m = A.rows();
        int j = 1;
        double[] s = new double[m + 1];
        double[][] cs = new double[m + 1][2];
        double[] rotmp = new double[2];
        AbstractDoubleVector x = new DoubleVector(A.rows());
        double normb = b.norm();
        AbstractDoubleVector r = b.subtract(A.multiply(x));
        double beta = r.norm();
        if (normb == 0.0) {
            normb = 1.0;
        }
        double resid = r.norm() / normb;
        if (d <= tol) {
            tol = resid;
            max_iter = 0;
            throw new IllegalArgumentException("There is a bug.");
        }
        AbstractDoubleVector[] v = new DoubleVector[m + 1];
        double[][] H = new double[m + 1][m];
        while (j <= max_iter) {
            double d2;
            int i;
            v[0] = r.scalarMultiply(1.0 / beta);
            for (i = 0; i < m + 1; ++i) {
                s[i] = 0.0;
            }
            s[0] = beta;
            for (i = 0; i < m && j <= max_iter; ++i, ++j) {
                double d3;
                int k;
                AbstractDoubleVector w = A.multiply(v[i]);
                for (k = 0; k <= i; ++k) {
                    H[k][i] = w.scalarProduct(v[k]);
                    w = w.subtract(v[k].scalarMultiply(H[k][i]));
                }
                H[i + 1][i] = w.norm();
                v[i + 1] = w.scalarMultiply(1.0 / H[i + 1][i]);
                for (k = 0; k < i; ++k) {
                    rotmp = LinearMath.applyPlaneRotation(H[k][i], H[k + 1][i], cs[k][0], cs[k][1]);
                    H[k][i] = rotmp[0];
                    H[k + 1][i] = rotmp[1];
                }
                cs[i] = LinearMath.generatePlaneRotation(H[i][i], H[i + 1][i]);
                rotmp = LinearMath.applyPlaneRotation(H[i][i], H[i + 1][i], cs[i][0], cs[i][1]);
                H[i][i] = rotmp[0];
                H[i + 1][i] = rotmp[1];
                rotmp = LinearMath.applyPlaneRotation(s[i], s[i + 1], cs[i][0], cs[i][1]);
                s[i] = rotmp[0];
                s[i + 1] = rotmp[1];
                resid = Math.abs(s[i + 1]) / normb;
                if (!(d3 < tol)) continue;
                x = LinearMath.update(x, i, H, s, v);
                tol = resid;
                max_iter = j;
                return x;
            }
            x = LinearMath.update(x, m - 1, H, s, v);
            r = b.subtract(A.multiply(x));
            beta = r.norm();
            resid = beta / normb;
            if (!(d2 < tol)) continue;
            tol = resid;
            max_iter = j;
            return x;
        }
        tol = resid;
        throw new MaximumIterationsExceededException("(tol) " + tol + ". It doesn't converge in " + max_iter + "iterations. Try raising the number of allowed iterations or raising the tolerance.");
    }

    private static double[] generatePlaneRotation(double dx, double dy) {
        double[] cs = new double[2];
        if (dy == 0.0) {
            cs[0] = 1.0;
            cs[1] = 0.0;
        } else if (Math.abs(dy) > Math.abs(dx)) {
            double temp = dx / dy;
            cs[1] = 1.0 / Math.sqrt(1.0 + temp * temp);
            cs[0] = temp * cs[1];
        } else {
            double temp = dy / dx;
            cs[0] = 1.0 / Math.sqrt(1.0 + temp * temp);
            cs[1] = temp * cs[0];
        }
        return cs;
    }

    private static double[] applyPlaneRotation(double dx, double dy, double cs, double sn) {
        double[] dxy = new double[]{cs * dx + sn * dy, -sn * dx + cs * dy};
        return dxy;
    }

    private static AbstractDoubleVector update(AbstractDoubleVector x, int k, double[][] H, double[] s, AbstractDoubleVector[] v) {
        for (int i = k; i >= 0; --i) {
            s[i] = s[i] / H[i][i];
            for (int j = i - 1; j >= 0; --j) {
                s[j] = s[j] - H[j][i] * s[i];
            }
        }
        for (int j = 0; j <= k; ++j) {
            x = x.add(v[j].scalarMultiply(s[j]));
        }
        return x;
    }

    public static RealPolynomial leastSquaresFit(int n, double[][] data) {
        int j;
        double xsum;
        int i;
        int nm1 = n++;
        double[][] mArray = new double[n][n];
        double[] vArray = new double[n];
        for (i = 0; i < n; ++i) {
            double xysum = 0.0;
            xsum = 0.0;
            for (j = 0; j < data[0].length; ++j) {
                double tmp = Math.pow(data[0][j], i);
                xsum += tmp;
                xysum += tmp * data[1][j];
            }
            mArray[0][i] = xsum;
            vArray[i] = xysum;
        }
        for (i = 1; i < n; ++i) {
            System.arraycopy(mArray[i - 1], 1, mArray[i], 0, nm1);
            xsum = 0.0;
            for (j = 0; j < data[0].length; ++j) {
                xsum += Math.pow(data[0][j], nm1 + i);
            }
            mArray[i][nm1] = xsum;
        }
        return new RealPolynomial(LinearMath.solveCholesky(mArray, vArray));
    }

    public static AbstractDoubleVector linearRegression(double[][] data) {
        int k;
        double xsum;
        int j;
        int y = data.length - 1;
        double[][] mArray = new double[data.length][data.length];
        double[] vArray = new double[data.length];
        mArray[0][0] = data[0].length;
        for (j = 1; j < data.length; ++j) {
            xsum = 0.0;
            for (k = 0; k < data[0].length; ++k) {
                xsum += data[j - 1][k];
            }
            double d = xsum;
            mArray[j][0] = d;
            mArray[0][j] = d;
        }
        double xysum = 0.0;
        for (k = 0; k < data[0].length; ++k) {
            xysum += data[y][k];
        }
        vArray[0] = xysum;
        for (int i = 1; i < data.length; ++i) {
            for (j = i; j < data.length; ++j) {
                xsum = 0.0;
                for (k = 0; k < data[0].length; ++k) {
                    xsum += data[i - 1][k] * data[j - 1][k];
                }
                double d = xsum;
                mArray[j][i] = d;
                mArray[i][j] = d;
            }
            xysum = 0.0;
            for (k = 0; k < data[0].length; ++k) {
                xysum += data[i - 1][k] * data[y][k];
            }
            vArray[i] = xysum;
        }
        return new DoubleVector(LinearMath.solveCholesky(mArray, vArray));
    }

    public static AbstractDoubleVector[] orthonormalize(AbstractDoubleVector[] vecs) {
        int N = vecs.length;
        AbstractDoubleVector[] orthovecs = new DoubleVector[N];
        for (int i = 0; i < N; ++i) {
            orthovecs[i] = vecs[i];
            for (int j = 0; j < i; ++j) {
                orthovecs[i] = orthovecs[i].subtract(orthovecs[j].scalarMultiply(orthovecs[j].scalarProduct(vecs[i])));
            }
            orthovecs[i].normalize();
        }
        return orthovecs;
    }

    public static double[] eigenvalueSolveHermitian(AbstractComplexSquareMatrix matrix) throws MaximumIterationsExceededException {
        int n = matrix.rows();
        double[][] matrix2 = new double[2 * n][2 * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double real = matrix.getRealElement(i, j);
                double imag = matrix.getImagElement(i, j);
                matrix2[i][j] = real;
                matrix2[n + i][n + j] = real;
                matrix2[n + i][j] = imag;
                matrix2[i][n + j] = -imag;
            }
        }
        double[] eigenvalue2 = new double[2 * n];
        double[] offdiag = new double[2 * n];
        LinearMath.reduceSymmetric1_SquareToTridiagonal(matrix2, eigenvalue2, offdiag);
        System.arraycopy(offdiag, 1, offdiag, 0, n - 1);
        offdiag[n - 1] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(eigenvalue2, offdiag);
        double[] eigenvalue = new double[n];
        System.arraycopy(eigenvalue2, 0, eigenvalue, 0, n);
        return eigenvalue;
    }

    public static double[] eigenSolveHermitian(AbstractComplexSquareMatrix matrix, AbstractComplexVector[] eigenvector) throws MaximumIterationsExceededException {
        int j;
        int i;
        int n = matrix.rows();
        double[][] matrix2 = new double[2 * n][2 * n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                double real = matrix.getRealElement(i, j);
                double imag = matrix.getImagElement(i, j);
                matrix2[i][j] = real;
                matrix2[n + i][n + j] = real;
                matrix2[n + i][j] = imag;
                matrix2[i][n + j] = -imag;
            }
        }
        double[] eigenvalue2 = new double[2 * n];
        double[] offdiag = new double[2 * n];
        LinearMath.reduceSymmetric2_SquareToTridiagonal(matrix2, eigenvalue2, offdiag);
        System.arraycopy(offdiag, 1, offdiag, 0, n - 1);
        offdiag[n - 1] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(eigenvalue2, offdiag, matrix2);
        double[] eigenvalue = new double[n];
        for (i = 0; i < n; ++i) {
            eigenvalue[i] = eigenvalue2[i];
            double[] arrayRe = new double[n];
            double[] arrayIm = new double[n];
            for (j = 0; j < n; ++j) {
                arrayRe[j] = matrix2[j][i];
                arrayIm[j] = matrix2[j + n][i];
            }
            eigenvector[i] = new ComplexVector(arrayRe, arrayIm);
        }
        return eigenvalue;
    }

    public static double[] eigenvalueSolveSymmetric(DoubleTridiagonalMatrix matrix) throws MaximumIterationsExceededException {
        int n = matrix.rows();
        int nm1 = n - 1;
        double[] eigenvalue = new double[n];
        double[] offdiag = new double[n];
        for (int i = 0; i < nm1; ++i) {
            eigenvalue[i] = matrix.getElement(i, i);
            offdiag[i] = matrix.getElement(i, i + 1);
        }
        eigenvalue[nm1] = matrix.getElement(nm1, nm1);
        offdiag[nm1] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(eigenvalue, offdiag);
        return eigenvalue;
    }

    public static double[] eigenSolveSymmetric(DoubleTridiagonalMatrix matrix, AbstractDoubleVector[] eigenvector) throws MaximumIterationsExceededException {
        int i;
        int n = matrix.rows();
        int nm1 = n - 1;
        double[] eigenvalue = new double[n];
        double[] offdiag = new double[n];
        double[][] id = new double[n][n];
        for (i = 0; i < nm1; ++i) {
            id[i][i] = 1.0;
            eigenvalue[i] = matrix.getElement(i, i);
            offdiag[i] = matrix.getElement(i, i + 1);
        }
        id[nm1][nm1] = 1.0;
        eigenvalue[nm1] = matrix.getElement(nm1, nm1);
        offdiag[nm1] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(eigenvalue, offdiag, id);
        for (i = 0; i < n; ++i) {
            DoubleVector evec = new DoubleVector(n);
            for (int j = 0; j < n; ++j) {
                evec.setComponent(j, id[j][i]);
            }
            eigenvector[i] = evec;
        }
        return eigenvalue;
    }

    public static double[] eigenvalueSolveSymmetric(AbstractDoubleSquareMatrix matrix) throws MaximumIterationsExceededException {
        int n = matrix.rows();
        double[] eigenvalue = new double[n];
        double[] offdiag = new double[n];
        double[][] array = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                array[i][j] = matrix.getElement(i, j);
            }
        }
        LinearMath.reduceSymmetric1_SquareToTridiagonal(array, eigenvalue, offdiag);
        System.arraycopy(offdiag, 1, offdiag, 0, n - 1);
        offdiag[n - 1] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(eigenvalue, offdiag);
        return eigenvalue;
    }

    public static double[] eigenSolveSymmetric(AbstractDoubleSquareMatrix matrix, AbstractDoubleVector[] eigenvector) throws MaximumIterationsExceededException {
        int j;
        int i;
        int n = matrix.rows();
        double[] eigenvalue = new double[n];
        double[] offdiag = new double[n];
        double[][] transf = new double[n][n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                transf[i][j] = matrix.getElement(i, j);
            }
        }
        LinearMath.reduceSymmetric2_SquareToTridiagonal(transf, eigenvalue, offdiag);
        System.arraycopy(offdiag, 1, offdiag, 0, n - 1);
        offdiag[n - 1] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(eigenvalue, offdiag, transf);
        for (i = 0; i < n; ++i) {
            DoubleVector evec = new DoubleVector(n);
            for (j = 0; j < n; ++j) {
                evec.setComponent(j, transf[j][i]);
            }
            eigenvector[i] = evec;
        }
        return eigenvalue;
    }

    private static void eigenvalueSolveSymmetricTridiagonalMatrix(double[] diag, double[] offdiag) throws MaximumIterationsExceededException {
        int n = diag.length;
        int nm1 = n - 1;
        for (int l = 0; l < n; ++l) {
            int m;
            int iteration = 0;
            do {
                for (m = l; m < nm1; ++m) {
                    double dd = Math.abs(diag[m]) + Math.abs(diag[m + 1]);
                    if (Math.abs(offdiag[m]) + dd == dd) break;
                }
                if (m == l) continue;
                if (iteration++ == 250) {
                    throw new MaximumIterationsExceededException("No convergence after 250 iterations.");
                }
                double g = (diag[l + 1] - diag[l]) / (2.0 * offdiag[l]);
                double r = Math.sqrt(g * g + 1.0);
                g = diag[m] - diag[l] + offdiag[l] / (g + (g < 0.0 ? -Math.abs(r) : Math.abs(r)));
                double c = 1.0;
                double s = 1.0;
                double p = 0.0;
                for (int i = m - 1; i >= l; --i) {
                    double f = s * offdiag[i];
                    double b = c * offdiag[i];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        offdiag[i + 1] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        offdiag[i + 1] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = diag[i + 1] - p;
                    r = (diag[i] - g) * s + 2.0 * c * b;
                    p = s * r;
                    diag[i + 1] = g + p;
                    g = c * r - b;
                }
                diag[l] = diag[l] - p;
                offdiag[l] = g;
                offdiag[m] = 0.0;
            } while (m != l);
        }
    }

    private static void reduceSymmetric1_SquareToTridiagonal(double[][] matrix, double[] diag, double[] offdiag) {
        int i;
        int n = diag.length;
        for (i = n - 1; i > 0; --i) {
            int l = i - 1;
            double scale = 0.0;
            double h = 0.0;
            if (l > 0) {
                int k;
                for (k = 0; k <= l; ++k) {
                    scale += Math.abs(matrix[i][k]);
                }
                if (scale == 0.0) {
                    offdiag[i] = matrix[i][l];
                } else {
                    int j;
                    for (k = 0; k <= l; ++k) {
                        double[] dArray = matrix[i];
                        int n2 = k;
                        dArray[n2] = dArray[n2] / scale;
                        h += matrix[i][k] * matrix[i][k];
                    }
                    double f = matrix[i][l];
                    double g = f >= 0.0 ? -Math.sqrt(h) : Math.sqrt(h);
                    offdiag[i] = scale * g;
                    h -= f * g;
                    matrix[i][l] = f - g;
                    f = 0.0;
                    for (j = 0; j <= l; ++j) {
                        g = 0.0;
                        for (k = 0; k <= j; ++k) {
                            g += matrix[j][k] * matrix[i][k];
                        }
                        for (k = j + 1; k <= l; ++k) {
                            g += matrix[k][j] * matrix[i][k];
                        }
                        offdiag[j] = g / h;
                        f += offdiag[j] * matrix[i][j];
                    }
                    double hh = f / (h + h);
                    for (j = 0; j <= l; ++j) {
                        f = matrix[i][j];
                        offdiag[j] = g = offdiag[j] - hh * f;
                        for (k = 0; k <= j; ++k) {
                            double[] dArray = matrix[j];
                            int n3 = k;
                            dArray[n3] = dArray[n3] - (f * offdiag[k] + g * matrix[i][k]);
                        }
                    }
                }
            } else {
                offdiag[i] = matrix[i][l];
            }
            diag[i] = h;
        }
        offdiag[0] = 0.0;
        for (i = 0; i < n; ++i) {
            diag[i] = matrix[i][i];
        }
    }

    private static void eigenSolveSymmetricTridiagonalMatrix(double[] diag, double[] offdiag, double[][] transf) throws MaximumIterationsExceededException {
        int n = diag.length;
        int nm1 = n - 1;
        for (int l = 0; l < n; ++l) {
            int m;
            int iteration = 0;
            do {
                for (m = l; m < nm1; ++m) {
                    double dd = Math.abs(diag[m]) + Math.abs(diag[m + 1]);
                    if (Math.abs(offdiag[m]) + dd == dd) break;
                }
                if (m == l) continue;
                if (iteration++ == 250) {
                    throw new MaximumIterationsExceededException("No convergence after 250 iterations.");
                }
                double g = (diag[l + 1] - diag[l]) / (2.0 * offdiag[l]);
                double r = Math.sqrt(g * g + 1.0);
                g = diag[m] - diag[l] + offdiag[l] / (g + (g < 0.0 ? -Math.abs(r) : Math.abs(r)));
                double c = 1.0;
                double s = 1.0;
                double p = 0.0;
                for (int i = m - 1; i >= l; --i) {
                    double f = s * offdiag[i];
                    double b = c * offdiag[i];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        offdiag[i + 1] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        offdiag[i + 1] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = diag[i + 1] - p;
                    r = (diag[i] - g) * s + 2.0 * c * b;
                    p = s * r;
                    diag[i + 1] = g + p;
                    g = c * r - b;
                    for (int k = 0; k < n; ++k) {
                        f = transf[k][i + 1];
                        transf[k][i + 1] = s * transf[k][i] + c * f;
                        transf[k][i] = c * transf[k][i] - s * f;
                    }
                }
                diag[l] = diag[l] - p;
                offdiag[l] = g;
                offdiag[m] = 0.0;
            } while (m != l);
        }
    }

    private static void reduceSymmetric2_SquareToTridiagonal(double[][] matrix, double[] diag, double[] offdiag) {
        int j;
        double g;
        int k;
        int l;
        int i;
        int n = diag.length;
        for (i = n - 1; i > 0; --i) {
            l = i - 1;
            double scale = 0.0;
            double h = 0.0;
            if (l > 0) {
                for (k = 0; k <= l; ++k) {
                    scale += Math.abs(matrix[i][k]);
                }
                if (scale == 0.0) {
                    offdiag[i] = matrix[i][l];
                } else {
                    for (k = 0; k <= l; ++k) {
                        double[] dArray = matrix[i];
                        int n2 = k;
                        dArray[n2] = dArray[n2] / scale;
                        h += matrix[i][k] * matrix[i][k];
                    }
                    double f = matrix[i][l];
                    g = f >= 0.0 ? -Math.sqrt(h) : Math.sqrt(h);
                    offdiag[i] = scale * g;
                    h -= f * g;
                    matrix[i][l] = f - g;
                    f = 0.0;
                    for (j = 0; j <= l; ++j) {
                        matrix[j][i] = matrix[i][j] / h;
                        g = 0.0;
                        for (k = 0; k <= j; ++k) {
                            g += matrix[j][k] * matrix[i][k];
                        }
                        for (k = j + 1; k <= l; ++k) {
                            g += matrix[k][j] * matrix[i][k];
                        }
                        offdiag[j] = g / h;
                        f += offdiag[j] * matrix[i][j];
                    }
                    double hh = f / (h + h);
                    for (j = 0; j <= l; ++j) {
                        f = matrix[i][j];
                        offdiag[j] = g = offdiag[j] - hh * f;
                        for (k = 0; k <= j; ++k) {
                            double[] dArray = matrix[j];
                            int n3 = k;
                            dArray[n3] = dArray[n3] - (f * offdiag[k] + g * matrix[i][k]);
                        }
                    }
                }
            } else {
                offdiag[i] = matrix[i][l];
            }
            diag[i] = h;
        }
        offdiag[0] = 0.0;
        diag[0] = 0.0;
        for (i = 0; i < n; ++i) {
            l = i - 1;
            if (diag[i] != 0.0) {
                for (j = 0; j <= l; ++j) {
                    g = 0.0;
                    for (k = 0; k <= l; ++k) {
                        g += matrix[i][k] * matrix[k][j];
                    }
                    for (k = 0; k <= l; ++k) {
                        double[] dArray = matrix[k];
                        int n4 = j;
                        dArray[n4] = dArray[n4] - g * matrix[k][i];
                    }
                }
            }
            diag[i] = matrix[i][i];
            matrix[i][i] = 1.0;
            for (j = 0; j <= l; ++j) {
                matrix[i][j] = 0.0;
                matrix[j][i] = 0.0;
            }
        }
    }
}

