/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jsci.maths.MathSet;

public final class FiniteSet
implements MathSet {
    private final Set elements;

    public FiniteSet(Set set) {
        this.elements = set;
    }

    public boolean equals(Object s) {
        return s != null && s instanceof FiniteSet && this.elements.equals(((FiniteSet)s).elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        return this.elements.toString();
    }

    public Set getElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    @Override
    public int cardinality() {
        return this.elements.size();
    }

    @Override
    public MathSet union(MathSet set) {
        HashSet union = new HashSet(this.elements);
        union.addAll(((FiniteSet)set).elements);
        return new FiniteSet(union);
    }

    @Override
    public MathSet intersect(MathSet set) {
        HashSet intersection = new HashSet(this.elements);
        intersection.retainAll(((FiniteSet)set).elements);
        return new FiniteSet(intersection);
    }
}

