/*
 * Decompiled with CFR 0.152.
 */
package jsci.biology;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jsci.biology.AminoAcid;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class AminoAcids {
    private static final Map table = new HashMap();
    private static Map symbols;

    private AminoAcids() {
    }

    public static String getName(String symbol) {
        if (symbols == null) {
            symbols = AminoAcids.loadIndex();
        }
        return (String)symbols.get(symbol);
    }

    public static AminoAcid getAminoAcid(String name) {
        AminoAcid aminoacid = (AminoAcid)table.get(name = name.toLowerCase());
        if (aminoacid == null && (aminoacid = AminoAcids.loadAminoAcid("aminoacids/" + name.replace(' ', '-') + ".xml")) != null) {
            table.put(name, aminoacid);
        }
        return aminoacid;
    }

    private static Map loadIndex() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(AminoAcids.class.getResource("aminoacids/index.xml").toString());
            Element root = doc.getDocumentElement();
            NodeList nl = root.getChildNodes();
            HashMap<String, String> index = new HashMap<String, String>();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!node.getNodeName().equals("amino-acid")) continue;
                NamedNodeMap attr = node.getAttributes();
                index.put(attr.getNamedItem("symbol").getNodeValue(), attr.getNamedItem("name").getNodeValue());
            }
            return index;
        }
        catch (ParserConfigurationException e) {
            return Collections.EMPTY_MAP;
        }
        catch (IOException e) {
            return Collections.EMPTY_MAP;
        }
        catch (SAXException e) {
            return Collections.EMPTY_MAP;
        }
    }

    private static AminoAcid loadAminoAcid(String resname) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(AminoAcids.class.getResource(resname).toString());
            Element root = doc.getDocumentElement();
            NodeList nl = root.getChildNodes();
            String name = AminoAcids.findStringValue(nl, "name");
            String abbreviation = AminoAcids.findStringValue(nl, "abbreviation");
            String symbol = AminoAcids.findStringValue(nl, "symbol");
            String formula = AminoAcids.findStringValue(nl, "molecular-formula");
            AminoAcid aminoacid = new AminoAcid(name, abbreviation, symbol, formula);
            aminoacid.setMolecularWeight(AminoAcids.findDoubleValue(nl, "molecular-weight"));
            aminoacid.setIsoelectricPoint(AminoAcids.findDoubleValue(nl, "isoelectric-point"));
            aminoacid.setCASRegistryNumber(AminoAcids.findStringValue(nl, "CAS-registry-number"));
            return aminoacid;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
    }

    private static String findStringValue(NodeList nl, String name) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if (!item.getNodeName().equals(name)) continue;
            return item.getFirstChild().getNodeValue();
        }
        return "";
    }

    private static double findDoubleValue(NodeList nl, String name) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if (!item.getNodeName().equals(name)) continue;
            return Double.parseDouble(item.getFirstChild().getNodeValue());
        }
        return Double.NaN;
    }
}

