/*
 * Decompiled with CFR 0.152.
 */
package org.la4j;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;
import java.util.StringTokenizer;
import org.la4j.LinearAlgebra;
import org.la4j.Matrices;
import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.inversion.MatrixInverter;
import org.la4j.iterator.ColumnMajorMatrixIterator;
import org.la4j.iterator.MatrixIterator;
import org.la4j.iterator.RowMajorMatrixIterator;
import org.la4j.iterator.VectorIterator;
import org.la4j.linear.LinearSystemSolver;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.MatrixFactory;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.matrix.SparseMatrix;
import org.la4j.matrix.dense.Basic1DMatrix;
import org.la4j.matrix.dense.Basic2DMatrix;
import org.la4j.matrix.functor.AdvancedMatrixPredicate;
import org.la4j.matrix.functor.MatrixAccumulator;
import org.la4j.matrix.functor.MatrixFunction;
import org.la4j.matrix.functor.MatrixPredicate;
import org.la4j.matrix.functor.MatrixProcedure;
import org.la4j.operation.MatrixMatrixOperation;
import org.la4j.operation.MatrixOperation;
import org.la4j.operation.MatrixVectorOperation;
import org.la4j.vector.functor.VectorAccumulator;
import org.la4j.vector.functor.VectorFunction;
import org.la4j.vector.functor.VectorProcedure;

public abstract class Matrix
implements Iterable<Double> {
    private static final String DEFAULT_ROWS_DELIMITER = "\n";
    private static final String DEFAULT_COLUMNS_DELIMITER = " ";
    private static final NumberFormat DEFAULT_FORMATTER = new DecimalFormat("0.000");
    private static final String[] INDENTS = new String[]{" ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};
    protected int rows;
    protected int columns;

    public static Matrix zero(int rows, int columns) {
        long size = (long)rows * (long)columns;
        return size > 1000L ? SparseMatrix.zero(rows, columns) : DenseMatrix.zero(rows, columns);
    }

    public static Matrix constant(int rows, int columns, double constant) {
        return DenseMatrix.constant(rows, columns, constant);
    }

    public static Matrix diagonal(int size, double diagonal) {
        return SparseMatrix.diagonal(size, diagonal);
    }

    public static Matrix unit(int rows, int columns) {
        return DenseMatrix.unit(rows, columns);
    }

    public static Matrix identity(int size) {
        return SparseMatrix.identity(size);
    }

    public static Matrix random(int rows, int columns, Random random) {
        return DenseMatrix.random(rows, columns, random);
    }

    public static Matrix randomSymmetric(int size, Random random) {
        return DenseMatrix.randomSymmetric(size, random);
    }

    public static Matrix from1DArray(int rows, int columns, double[] array) {
        return Basic1DMatrix.from1DArray(rows, columns, array);
    }

    public static Matrix from2DArray(double[][] array) {
        return Basic2DMatrix.from2DArray(array);
    }

    public static Matrix block(Matrix a, Matrix b, Matrix c, Matrix d) {
        return DenseMatrix.block(a, b, c, d);
    }

    public static Matrix fromCSV(String csv) {
        StringTokenizer lines = new StringTokenizer(csv, DEFAULT_ROWS_DELIMITER);
        Matrix result = DenseMatrix.zero(10, 10);
        int rows = 0;
        int columns = 0;
        while (lines.hasMoreTokens()) {
            if (result.rows() == rows) {
                result = result.copyOfRows(rows * 3 / 2 + 1);
            }
            StringTokenizer elements = new StringTokenizer(lines.nextToken(), ", ");
            int j = 0;
            while (elements.hasMoreElements()) {
                if (j == result.columns()) {
                    result = result.copyOfColumns(j * 3 / 2 + 1);
                }
                double x = Double.valueOf(elements.nextToken());
                result.set(rows, j++, x);
            }
            ++rows;
            columns = j > columns ? j : columns;
        }
        return result.copyOfShape(rows, columns);
    }

    public static Matrix fromMatrixMarket(String mm) {
        StringTokenizer body = new StringTokenizer(mm, DEFAULT_ROWS_DELIMITER);
        String headerString = body.nextToken();
        StringTokenizer header = new StringTokenizer(headerString);
        if (!"%%MatrixMarket".equals(header.nextToken())) {
            throw new IllegalArgumentException("Wrong input file format: can not read header '%%MatrixMarket'.");
        }
        String object = header.nextToken();
        if (!"matrix".equals(object)) {
            throw new IllegalArgumentException("Unexpected object: " + object + ".");
        }
        String format = header.nextToken();
        if (!"coordinate".equals(format) && !"array".equals(format)) {
            throw new IllegalArgumentException("Unknown format: " + format + ".");
        }
        String field = header.nextToken();
        if (!"real".equals(field)) {
            throw new IllegalArgumentException("Unknown field type: " + field + ".");
        }
        String symmetry = header.nextToken();
        if (!symmetry.equals("general")) {
            throw new IllegalArgumentException("Unknown symmetry type: " + symmetry + ".");
        }
        String majority = header.hasMoreTokens() ? header.nextToken() : "row-major";
        String nextToken = body.nextToken();
        while (nextToken.startsWith("%")) {
            nextToken = body.nextToken();
        }
        if ("coordinate".equals(format)) {
            StringTokenizer lines = new StringTokenizer(nextToken);
            int rows = Integer.valueOf(lines.nextToken());
            int columns = Integer.valueOf(lines.nextToken());
            int cardinality = Integer.valueOf(lines.nextToken());
            SparseMatrix result = "row-major".equals(majority) ? RowMajorSparseMatrix.zero(rows, columns, cardinality) : ColumnMajorSparseMatrix.zero(rows, columns, cardinality);
            for (int k = 0; k < cardinality; ++k) {
                lines = new StringTokenizer(body.nextToken());
                int i = Integer.valueOf(lines.nextToken());
                int j = Integer.valueOf(lines.nextToken());
                double x = Double.valueOf(lines.nextToken());
                result.set(i - 1, j - 1, x);
            }
            return result;
        }
        StringTokenizer lines = new StringTokenizer(nextToken);
        int rows = Integer.valueOf(lines.nextToken());
        int columns = Integer.valueOf(lines.nextToken());
        DenseMatrix result = DenseMatrix.zero(rows, columns);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                result.set(i, j, Double.valueOf(body.nextToken()));
            }
        }
        return result;
    }

    public Matrix() {
        this(0, 0);
    }

    public Matrix(int rows, int columns) {
        this.ensureDimensionsAreCorrect(rows, columns);
        this.rows = rows;
        this.columns = columns;
    }

    public abstract double get(int var1, int var2);

    public abstract void set(int var1, int var2, double var3);

    public abstract Vector getRow(int var1);

    public abstract Vector getColumn(int var1);

    public abstract Matrix blankOfShape(int var1, int var2);

    public abstract Matrix copyOfShape(int var1, int var2);

    public abstract <T> T apply(MatrixOperation<T> var1);

    public abstract <T> T apply(MatrixMatrixOperation<T> var1, Matrix var2);

    public abstract <T> T apply(MatrixVectorOperation<T> var1, Vector var2);

    public abstract byte[] toBinary();

    public abstract String toMatrixMarket(NumberFormat var1);

    public void setAll(double value) {
        MatrixIterator it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.set(value);
        }
    }

    public void setRow(int i, double value) {
        VectorIterator it = this.iteratorOfRow(i);
        while (it.hasNext()) {
            it.next();
            it.set(value);
        }
    }

    public void setColumn(int j, double value) {
        VectorIterator it = this.iteratorOfColumn(j);
        while (it.hasNext()) {
            it.next();
            it.set(value);
        }
    }

    public void swapRows(int i, int j) {
        if (i != j) {
            Vector ii = this.getRow(i);
            Vector jj = this.getRow(j);
            this.setRow(i, jj);
            this.setRow(j, ii);
        }
    }

    public void swapColumns(int i, int j) {
        if (i != j) {
            Vector ii = this.getColumn(i);
            Vector jj = this.getColumn(j);
            this.setColumn(i, jj);
            this.setColumn(j, ii);
        }
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public Matrix transpose() {
        Matrix result = this.blankOfShape(this.columns, this.rows);
        MatrixIterator it = result.iterator();
        while (it.hasNext()) {
            it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            it.set(this.get(j, i));
        }
        return result;
    }

    public Matrix rotate() {
        Matrix result = this.blankOfShape(this.columns, this.rows);
        MatrixIterator it = result.iterator();
        while (it.hasNext()) {
            it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            it.set(this.get(this.rows - 1 - j, i));
        }
        return result;
    }

    public Matrix power(int n) {
        if (n < 0) {
            this.fail("The exponent should be positive: " + n + ".");
        }
        Matrix result = this.blankOfShape(this.rows, this.rows);
        Matrix that = this;
        for (int i = 0; i < this.rows; ++i) {
            result.set(i, i, 1.0);
        }
        while (n > 0) {
            if (n % 2 == 1) {
                result = result.multiply(that);
            }
            n /= 2;
            that = that.multiply(that);
        }
        return result;
    }

    public Matrix multiply(double value) {
        Matrix result = this.blank();
        MatrixIterator it = this.iterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(i, j, x * value);
        }
        return result;
    }

    public Vector multiply(Vector that) {
        return this.apply(LinearAlgebra.OO_PLACE_MATRIX_BY_VECTOR_MULTIPLICATION, that);
    }

    public Matrix multiply(Matrix that) {
        return this.apply(LinearAlgebra.OO_PLACE_MATRICES_MULTIPLICATION, that);
    }

    public Matrix multiplyByItsTranspose() {
        return this.apply(LinearAlgebra.OO_PLACE_MATRIX_BY_ITS_TRANSPOSE_MULTIPLICATION);
    }

    public Matrix subtract(double value) {
        return this.add(-value);
    }

    public Matrix subtract(Matrix that) {
        return this.apply(LinearAlgebra.OO_PLACE_MATRICES_SUBTRACTION, that);
    }

    public Matrix add(double value) {
        MatrixIterator it = this.iterator();
        Matrix result = this.blank();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(i, j, x + value);
        }
        return result;
    }

    public Matrix add(Matrix that) {
        return this.apply(LinearAlgebra.OO_PLACE_MATRIX_ADDITION, that);
    }

    public Matrix insert(Matrix that) {
        return this.insert(that, 0, 0, 0, 0, that.rows(), that.columns());
    }

    public Matrix insert(Matrix that, int rows, int columns) {
        return this.insert(that, 0, 0, 0, 0, rows, columns);
    }

    public Matrix insert(Matrix that, int destRow, int destColumn, int rows, int columns) {
        return this.insert(that, 0, 0, destRow, destColumn, rows, columns);
    }

    public Matrix insert(Matrix that, int srcRow, int srcColumn, int destRow, int destColumn, int rows, int columns) {
        if (rows < 0 || columns < 0) {
            this.fail("Cannot have negative rows or columns: " + rows + "x" + columns);
        }
        if (destRow < 0 || destColumn < 0) {
            this.fail("Cannot have negative destination position: " + destRow + ", " + destColumn);
        }
        if (destRow > this.rows || destColumn > this.columns) {
            this.fail("Destination position out of bounds: " + destRow + ", " + destColumn);
        }
        if (srcRow < 0 || srcColumn < 0) {
            this.fail("Cannot have negative source position: " + destRow + ", " + destColumn);
        }
        if (srcRow > that.rows || srcColumn > that.columns) {
            this.fail("Destination position out of bounds: " + srcRow + ", " + srcColumn);
        }
        if (destRow + rows > this.rows || destColumn + columns > this.columns) {
            this.fail("Out of bounds: Cannot add " + rows + " rows and " + columns + " cols at " + destRow + ", " + destColumn + " in a " + this.rows + "x" + this.columns + " matrix.");
        }
        if (srcRow + rows > that.rows || srcColumn + columns > that.columns) {
            this.fail("Out of bounds: Cannot get " + rows + " rows and " + columns + " cols at " + srcRow + ", " + srcColumn + " from a " + that.rows + "x" + that.columns + " matrix.");
        }
        Matrix result = this.copy();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                result.set(i + destRow, j + destColumn, that.get(i + srcRow, j + srcColumn));
            }
        }
        return result;
    }

    public Matrix divide(double value) {
        return this.multiply(1.0 / value);
    }

    public Matrix kroneckerProduct(Matrix that) {
        return this.apply(LinearAlgebra.OO_PLACE_KRONECKER_PRODUCT, that);
    }

    public double trace() {
        double result = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            result += this.get(i, i);
        }
        return result;
    }

    public double diagonalProduct() {
        BigDecimal result = BigDecimal.ONE;
        for (int i = 0; i < this.rows; ++i) {
            result = result.multiply(BigDecimal.valueOf(this.get(i, i)));
        }
        return result.setScale(Matrices.ROUND_FACTOR, RoundingMode.CEILING).doubleValue();
    }

    public double norm() {
        return this.euclideanNorm();
    }

    public double euclideanNorm() {
        return this.fold(Matrices.mkEuclideanNormAccumulator());
    }

    public double manhattanNorm() {
        return this.fold(Matrices.mkManhattanNormAccumulator());
    }

    public double infinityNorm() {
        return this.fold(Matrices.mkInfinityNormAccumulator());
    }

    public double product() {
        return this.fold(Matrices.asProductAccumulator(1.0));
    }

    public double sum() {
        return this.fold(Matrices.asSumAccumulator(0.0));
    }

    public Matrix hadamardProduct(Matrix that) {
        return this.apply(LinearAlgebra.OO_PLACE_MATRIX_HADAMARD_PRODUCT, that);
    }

    public double determinant() {
        if (this.rows != this.columns) {
            throw new IllegalStateException("Can not compute determinant of non-square matrix.");
        }
        if (this.rows == 0) {
            return 0.0;
        }
        if (this.rows == 1) {
            return this.get(0, 0);
        }
        if (this.rows == 2) {
            return this.get(0, 0) * this.get(1, 1) - this.get(0, 1) * this.get(1, 0);
        }
        if (this.rows == 3) {
            return this.get(0, 0) * this.get(1, 1) * this.get(2, 2) + this.get(0, 1) * this.get(1, 2) * this.get(2, 0) + this.get(0, 2) * this.get(1, 0) * this.get(2, 1) - this.get(0, 2) * this.get(1, 1) * this.get(2, 0) - this.get(0, 1) * this.get(1, 0) * this.get(2, 2) - this.get(0, 0) * this.get(1, 2) * this.get(2, 1);
        }
        MatrixDecompositor decompositor = this.withDecompositor(LinearAlgebra.LU);
        Matrix[] lup = decompositor.decompose();
        Matrix u = lup[1];
        Matrix p = lup[2];
        double result = u.diagonalProduct();
        int[] permutations = new int[p.rows()];
        block0: for (int i = 0; i < p.rows(); ++i) {
            for (int j = 0; j < p.columns(); ++j) {
                if (!(p.get(i, j) > 0.0)) continue;
                permutations[i] = j;
                continue block0;
            }
        }
        int sign = 1;
        for (int i = 0; i < permutations.length; ++i) {
            for (int j = i + 1; j < permutations.length; ++j) {
                if (permutations[j] >= permutations[i]) continue;
                sign *= -1;
            }
        }
        return (double)sign * result;
    }

    public int rank() {
        if (this.rows == 0 || this.columns == 0) {
            return 0;
        }
        MatrixDecompositor decompositor = this.withDecompositor(LinearAlgebra.SVD);
        Matrix[] usv = decompositor.decompose();
        Matrix s = usv[1];
        double tolerance = (double)Math.max(this.rows, this.columns) * s.get(0, 0) * Matrices.EPS;
        int result = 0;
        for (int i = 0; i < s.rows(); ++i) {
            if (!(s.get(i, i) > tolerance)) continue;
            ++result;
        }
        return result;
    }

    public void setRow(int i, Vector row) {
        if (this.columns != row.length()) {
            this.fail("Wrong vector length: " + row.length() + ". Should be: " + this.columns + ".");
        }
        for (int j = 0; j < row.length(); ++j) {
            this.set(i, j, row.get(j));
        }
    }

    public void setColumn(int j, Vector column) {
        if (this.rows != column.length()) {
            this.fail("Wrong vector length: " + column.length() + ". Should be: " + this.rows + ".");
        }
        for (int i = 0; i < column.length(); ++i) {
            this.set(i, j, column.get(i));
        }
    }

    public Matrix insertRow(int i, Vector row) {
        int ii;
        if (i >= this.rows || i < 0) {
            throw new IndexOutOfBoundsException("Illegal row number, must be 0.." + (this.rows - 1));
        }
        Matrix result = this.blankOfShape(this.rows + 1, this.columns);
        for (ii = 0; ii < i; ++ii) {
            result.setRow(ii, this.getRow(ii));
        }
        result.setRow(i, row);
        for (ii = i; ii < this.rows; ++ii) {
            result.setRow(ii + 1, this.getRow(ii));
        }
        return result;
    }

    public Matrix insertColumn(int j, Vector column) {
        int jj;
        if (j >= this.columns || j < 0) {
            throw new IndexOutOfBoundsException("Illegal row number, must be 0.." + (this.columns - 1));
        }
        Matrix result = this.blankOfShape(this.rows, this.columns + 1);
        for (jj = 0; jj < j; ++jj) {
            result.setColumn(jj, this.getColumn(jj));
        }
        result.setColumn(j, column);
        for (jj = j; jj < this.columns; ++jj) {
            result.setColumn(jj + 1, this.getColumn(jj));
        }
        return result;
    }

    public Matrix removeRow(int i) {
        int ii;
        if (i >= this.rows || i < 0) {
            throw new IndexOutOfBoundsException("Illegal row number, must be 0.." + (this.rows - 1));
        }
        Matrix result = this.blankOfShape(this.rows - 1, this.columns);
        for (ii = 0; ii < i; ++ii) {
            result.setRow(ii, this.getRow(ii));
        }
        for (ii = i + 1; ii < this.rows; ++ii) {
            result.setRow(ii - 1, this.getRow(ii));
        }
        return result;
    }

    public Matrix removeColumn(int j) {
        int jj;
        if (j >= this.columns || j < 0) {
            throw new IndexOutOfBoundsException("Illegal row number, must be 0.." + (this.columns - 1));
        }
        Matrix result = this.blankOfShape(this.rows, this.columns - 1);
        for (jj = 0; jj < j; ++jj) {
            result.setColumn(jj, this.getColumn(jj));
        }
        for (jj = j + 1; jj < this.columns; ++jj) {
            result.setColumn(jj - 1, this.getColumn(jj));
        }
        return result;
    }

    public Matrix removeFirstRow() {
        return this.removeRow(0);
    }

    public Matrix removeFirstColumn() {
        return this.removeColumn(0);
    }

    public Matrix removeLastRow() {
        return this.removeRow(this.rows - 1);
    }

    public Matrix removeLastColumn() {
        return this.removeColumn(this.columns - 1);
    }

    public Matrix blank() {
        return this.blankOfShape(this.rows, this.columns);
    }

    public Matrix blankOfRows(int rows) {
        return this.blankOfShape(rows, this.columns);
    }

    public Matrix blankOfColumns(int columns) {
        return this.blankOfShape(this.rows, columns);
    }

    public Matrix copy() {
        return this.copyOfShape(this.rows, this.columns);
    }

    public Matrix copyOfRows(int rows) {
        return this.copyOfShape(rows, this.columns);
    }

    public Matrix copyOfColumns(int columns) {
        return this.copyOfShape(this.rows, columns);
    }

    public Matrix shuffle() {
        Matrix result = this.copy();
        Random random = new Random();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                int ii = random.nextInt(this.rows - i) + i;
                int jj = random.nextInt(this.columns - j) + j;
                double a = result.get(ii, jj);
                result.set(ii, jj, result.get(i, j));
                result.set(i, j, a);
            }
        }
        return result;
    }

    public Matrix slice(int fromRow, int fromColumn, int untilRow, int untilColumn) {
        if (untilRow - fromRow < 0 || untilColumn - fromColumn < 0) {
            this.fail("Wrong slice range: [" + fromRow + ".." + untilRow + "][" + fromColumn + ".." + untilColumn + "].");
        }
        Matrix result = this.blankOfShape(untilRow - fromRow, untilColumn - fromColumn);
        for (int i = fromRow; i < untilRow; ++i) {
            for (int j = fromColumn; j < untilColumn; ++j) {
                result.set(i - fromRow, j - fromColumn, this.get(i, j));
            }
        }
        return result;
    }

    public Matrix sliceTopLeft(int untilRow, int untilColumn) {
        return this.slice(0, 0, untilRow, untilColumn);
    }

    public Matrix sliceBottomRight(int fromRow, int fromColumn) {
        return this.slice(fromRow, fromColumn, this.rows, this.columns);
    }

    public Matrix select(int[] rowIndices, int[] columnIndices) {
        int m = rowIndices.length;
        int n = columnIndices.length;
        if (m == 0 || n == 0) {
            this.fail("No rows or columns selected.");
        }
        Matrix result = this.blankOfShape(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                result.set(i, j, this.get(rowIndices[i], columnIndices[j]));
            }
        }
        return result;
    }

    public void each(MatrixProcedure procedure) {
        MatrixIterator it = this.iterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            procedure.apply(i, j, x);
        }
    }

    public void eachInRow(int i, VectorProcedure procedure) {
        VectorIterator it = this.iteratorOfRow(i);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int j = it.index();
            procedure.apply(j, x);
        }
    }

    public void eachInColumn(int j, VectorProcedure procedure) {
        VectorIterator it = this.iteratorOfColumn(j);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            procedure.apply(i, x);
        }
    }

    public double max() {
        return this.fold(Matrices.mkMaxAccumulator());
    }

    public double min() {
        return this.fold(Matrices.mkMinAccumulator());
    }

    public double maxInRow(int i) {
        return this.foldRow(i, Vectors.mkMaxAccumulator());
    }

    public double minInRow(int i) {
        return this.foldRow(i, Vectors.mkMinAccumulator());
    }

    public double maxInColumn(int j) {
        return this.foldColumn(j, Vectors.mkMaxAccumulator());
    }

    public double minInColumn(int j) {
        return this.foldColumn(j, Vectors.mkMinAccumulator());
    }

    public Matrix transform(MatrixFunction function) {
        Matrix result = this.blank();
        MatrixIterator it = this.iterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(i, j, function.evaluate(i, j, x));
        }
        return result;
    }

    public Matrix transformRow(int i, VectorFunction function) {
        Matrix result = this.copy();
        VectorIterator it = result.iteratorOfRow(i);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int j = it.index();
            it.set(function.evaluate(j, x));
        }
        return result;
    }

    public Matrix transformColumn(int j, VectorFunction function) {
        Matrix result = this.copy();
        VectorIterator it = result.iteratorOfColumn(j);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            it.set(function.evaluate(i, x));
        }
        return result;
    }

    public void update(MatrixFunction function) {
        MatrixIterator it = this.iterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            it.set(function.evaluate(i, j, x));
        }
    }

    public void updateAt(int i, int j, MatrixFunction function) {
        this.set(i, j, function.evaluate(i, j, this.get(i, j)));
    }

    public void updateRow(int i, VectorFunction function) {
        VectorIterator it = this.iteratorOfRow(i);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int j = it.index();
            it.set(function.evaluate(j, x));
        }
    }

    public void updateColumn(int j, VectorFunction function) {
        VectorIterator it = this.iteratorOfColumn(j);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            it.set(function.evaluate(i, x));
        }
    }

    public double fold(MatrixAccumulator accumulator) {
        this.each(Matrices.asAccumulatorProcedure(accumulator));
        return accumulator.accumulate();
    }

    public double foldRow(int i, VectorAccumulator accumulator) {
        this.eachInRow(i, Vectors.asAccumulatorProcedure(accumulator));
        return accumulator.accumulate();
    }

    public double[] foldRows(VectorAccumulator accumulator) {
        double[] result = new double[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            result[i] = this.foldRow(i, accumulator);
        }
        return result;
    }

    public double foldColumn(int j, VectorAccumulator accumulator) {
        this.eachInColumn(j, Vectors.asAccumulatorProcedure(accumulator));
        return accumulator.accumulate();
    }

    public double[] foldColumns(VectorAccumulator accumulator) {
        double[] result = new double[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            result[i] = this.foldColumn(i, accumulator);
        }
        return result;
    }

    public boolean is(MatrixPredicate predicate) {
        MatrixIterator it = this.iterator();
        boolean result = predicate.test(this.rows, this.columns);
        while (it.hasNext() && result) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result = predicate.test(i, j, x);
        }
        return result;
    }

    public boolean is(AdvancedMatrixPredicate predicate) {
        return predicate.test(this);
    }

    public boolean non(MatrixPredicate predicate) {
        return !this.is(predicate);
    }

    public boolean non(AdvancedMatrixPredicate predicate) {
        return !this.is(predicate);
    }

    public Vector toRowVector() {
        return this.getRow(0);
    }

    public Vector toColumnVector() {
        return this.getColumn(0);
    }

    public LinearSystemSolver withSolver(LinearAlgebra.SolverFactory factory) {
        return factory.create(this);
    }

    public MatrixInverter withInverter(LinearAlgebra.InverterFactory factory) {
        return factory.create(this);
    }

    public MatrixDecompositor withDecompositor(LinearAlgebra.DecompositorFactory factory) {
        return factory.create(this);
    }

    public boolean equals(Matrix matrix, double precision) {
        if (this.rows != matrix.rows() || this.columns != matrix.columns()) {
            return false;
        }
        boolean result = true;
        for (int i = 0; result && i < this.rows; ++i) {
            for (int j = 0; result && j < this.columns; ++j) {
                double a = this.get(i, j);
                double b = matrix.get(i, j);
                double diff = Math.abs(a - b);
                result = a == b || diff < precision || diff / Math.max(Math.abs(a), Math.abs(b)) < precision;
            }
        }
        return result;
    }

    public String mkString(NumberFormat formatter) {
        return this.mkString(formatter, DEFAULT_ROWS_DELIMITER, DEFAULT_COLUMNS_DELIMITER);
    }

    public String mkString(String rowsDelimiter, String columnsDelimiter) {
        return this.mkString(DEFAULT_FORMATTER, rowsDelimiter, columnsDelimiter);
    }

    public String mkString(NumberFormat formatter, String rowsDelimiter, String columnsDelimiter) {
        int[] formats = new int[this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double value = this.get(i, j);
                String output = formatter.format(value);
                int size = output.length();
                formats[j] = size > formats[j] ? size : formats[j];
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                String output = formatter.format(this.get(i, j));
                int outputLength = output.length();
                if (outputLength < formats[j]) {
                    int align = formats[j] - outputLength;
                    if (align > INDENTS.length - 1) {
                        this.indent(sb, align);
                    } else {
                        sb.append(INDENTS[align - 1]);
                    }
                }
                sb.append(output).append(j < this.columns - 1 ? columnsDelimiter : "");
            }
            sb.append(rowsDelimiter);
        }
        return sb.toString();
    }

    public String toString() {
        return this.mkString(DEFAULT_FORMATTER, DEFAULT_ROWS_DELIMITER, DEFAULT_COLUMNS_DELIMITER);
    }

    public MatrixIterator iterator() {
        return this.rowMajorIterator();
    }

    public RowMajorMatrixIterator rowMajorIterator() {
        return new RowMajorMatrixIterator(this.rows, this.columns){
            private long limit;
            private int i;
            {
                this.limit = (long)this.rows * (long)this.columns;
                this.i = -1;
            }

            @Override
            public int rowIndex() {
                return this.i / this.columns;
            }

            @Override
            public int columnIndex() {
                return this.i - this.rowIndex() * this.columns;
            }

            @Override
            public double get() {
                return Matrix.this.get(this.rowIndex(), this.columnIndex());
            }

            @Override
            public void set(double value) {
                Matrix.this.set(this.rowIndex(), this.columnIndex(), value);
            }

            @Override
            public boolean hasNext() {
                return (long)(this.i + 1) < this.limit;
            }

            @Override
            public Double next() {
                ++this.i;
                return this.get();
            }
        };
    }

    public ColumnMajorMatrixIterator columnMajorIterator() {
        return new ColumnMajorMatrixIterator(this.rows, this.columns){
            private long limit;
            private int i;
            {
                this.limit = (long)this.rows * (long)this.columns;
                this.i = -1;
            }

            @Override
            public int rowIndex() {
                return this.i - this.columnIndex() * this.rows;
            }

            @Override
            public int columnIndex() {
                return this.i / this.rows;
            }

            @Override
            public double get() {
                return Matrix.this.get(this.rowIndex(), this.columnIndex());
            }

            @Override
            public void set(double value) {
                Matrix.this.set(this.rowIndex(), this.columnIndex(), value);
            }

            @Override
            public boolean hasNext() {
                return (long)(this.i + 1) < this.limit;
            }

            @Override
            public Double next() {
                ++this.i;
                return this.get();
            }
        };
    }

    public VectorIterator iteratorOfRow(int i) {
        final int ii = i;
        return new VectorIterator(this.columns){
            private int j;
            {
                super(length);
                this.j = -1;
            }

            @Override
            public int index() {
                return this.j;
            }

            @Override
            public double get() {
                return Matrix.this.get(ii, this.j);
            }

            @Override
            public void set(double value) {
                Matrix.this.set(ii, this.j, value);
            }

            @Override
            public boolean hasNext() {
                return this.j + 1 < Matrix.this.columns;
            }

            @Override
            public Double next() {
                ++this.j;
                return this.get();
            }
        };
    }

    public VectorIterator iteratorOfColumn(int j) {
        final int jj = j;
        return new VectorIterator(this.rows){
            private int i;
            {
                super(length);
                this.i = -1;
            }

            @Override
            public int index() {
                return this.i;
            }

            @Override
            public double get() {
                return Matrix.this.get(this.i, jj);
            }

            @Override
            public void set(double value) {
                Matrix.this.set(this.i, jj, value);
            }

            @Override
            public boolean hasNext() {
                return this.i + 1 < Matrix.this.rows;
            }

            @Override
            public Double next() {
                ++this.i;
                return this.get();
            }
        };
    }

    public int hashCode() {
        MatrixIterator it = this.iterator();
        int result = 17;
        while (it.hasNext()) {
            long value = ((Double)it.next()).longValue();
            result = 37 * result + (int)(value ^ value >>> 32);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Matrix)) {
            return false;
        }
        Matrix matrix = (Matrix)o;
        return this.equals(matrix, Matrices.EPS);
    }

    public <T extends Matrix> T to(MatrixFactory<T> factory) {
        T result = factory.apply(this.rows, this.columns);
        this.apply((MatrixMatrixOperation<T>)LinearAlgebra.IN_PLACE_COPY_MATRIX_TO_MATRIX, (Matrix)result);
        return result;
    }

    public SparseMatrix toSparseMatrix() {
        return this.to(Matrices.SPARSE);
    }

    public DenseMatrix toDenseMatrix() {
        return this.to(Matrices.DENSE);
    }

    public RowMajorSparseMatrix toRowMajorSparseMatrix() {
        return this.to(Matrices.SPARSE_ROW_MAJOR);
    }

    public ColumnMajorSparseMatrix toColumnMajorSparseMatrix() {
        return this.to(Matrices.SPARSE_COLUMN_MAJOR);
    }

    public String toCSV() {
        return this.toCSV(DEFAULT_FORMATTER);
    }

    public String toMatrixMarket() {
        return this.toMatrixMarket(DEFAULT_FORMATTER);
    }

    public String toCSV(NumberFormat formatter) {
        return this.mkString(formatter, DEFAULT_ROWS_DELIMITER, ", ");
    }

    protected void ensureDimensionsAreCorrect(int rows, int columns) {
        if (rows < 0 || columns < 0) {
            this.fail("Wrong matrix dimensions: " + rows + "x" + columns);
        }
        if (rows == Integer.MAX_VALUE || columns == Integer.MAX_VALUE) {
            this.fail("Wrong matrix dimensions: use 'Integer.MAX_VALUE - 1' instead.");
        }
    }

    protected void ensureIndexesAreInBounds(int i, int j) {
        if (i < 0 || i >= this.rows) {
            throw new IndexOutOfBoundsException("Row '" + i + "' is invalid.");
        }
        if (j < 0 || j >= this.columns) {
            throw new IndexOutOfBoundsException("Column '" + j + "' is invalid.");
        }
    }

    protected void fail(String message) {
        throw new IllegalArgumentException(message);
    }

    private void indent(StringBuilder sb, int howMany) {
        while (howMany > 0) {
            sb.append(DEFAULT_COLUMNS_DELIMITER);
            --howMany;
        }
    }
}

